/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.subset;

import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.AndroidProjectKeys;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.ui.Cell;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.PairFunction;
import com.intellij.util.PlatformIcons;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import icons.AndroidIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.jdesktop.swingx.JXLabel;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModulesToImportDialog
extends DialogWrapper {
    private static final int SELECTED_MODULE_COLUMN = 0;
    private static final int MODULE_NAME_COLUMN = 1;
    @NotNull
    private final List<DataNode<ModuleData>> alwaysIncludedModules;
    @Nullable
    private final Project myProject;
    private JPanel myPanel;
    private JBTable myModulesTable;
    private JXLabel myDescriptionLabel;
    private JPanel myContentsPanel;
    private JBLabel mySelectionStatusLabel;
    private volatile boolean mySkipValidation;
    private int myMaxSelectionCount;

    public ModulesToImportDialog(@NotNull Collection<DataNode<ModuleData>> modules, @Nullable Project project) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/android/tools/idea/gradle/project/subset/ModulesToImportDialog", "<init>"));
        }
        super(project, true, DialogWrapper.IdeModalityType.IDE);
        this.$$$setupUI$$$();
        this.alwaysIncludedModules = Lists.newArrayList();
        this.myMaxSelectionCount = -1;
        this.setTitle("Select Modules to Include in Project Subset");
        this.myProject = project;
        this.init();
        ModuleTableModel model = this.getModulesTable().getModel();
        for (DataNode<ModuleData> module : modules) {
            Collection gradleProjects = ExternalSystemApiUtil.getChildren(module, AndroidProjectKeys.GRADLE_MODEL);
            if (gradleProjects.isEmpty()) {
                this.alwaysIncludedModules.add(module);
                continue;
            }
            model.add(module);
        }
        this.getModulesTable().sort();
        this.myDescriptionLabel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        DefaultActionGroup group = new DefaultActionGroup();
        group.addAll(new AnAction[]{new SelectAllAction(true), new SelectAllAction(false)});
        group.addSeparator();
        group.add((AnAction)new ShowSelectedModulesAction(this.getModulesTable()));
        group.addSeparator();
        group.addAll(new AnAction[]{new LoadFromFileAction(), new SaveToFileAction()});
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("android.gradle.module.selection.dialog.toolbar", (ActionGroup)group, true);
        this.myContentsPanel.add((Component)toolbar.getComponent(), "North");
        this.mySelectionStatusLabel = new JBLabel();
        this.myContentsPanel.add((Component)this.mySelectionStatusLabel, "South");
        this.updateSelectionStatus();
    }

    @NotNull
    private ModuleTable getModulesTable() {
        ModuleTable moduleTable = (ModuleTable)this.myModulesTable;
        if (moduleTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/subset/ModulesToImportDialog", "getModulesTable"));
        }
        return moduleTable;
    }

    private void updateSelectionStatus() {
        ModuleTable table = this.getModulesTable();
        ModuleTableModel model = table.getModel();
        int rowCount = model.getRowCount();
        int selectedRowCount = model.selectedRowCount;
        String msg = String.format("%1$d Modules. %2$d selected", rowCount, selectedRowCount);
        this.mySelectionStatusLabel.setText(msg);
        table.updateFilter();
    }

    @NotNull
    private static String getNameOf(@NotNull DataNode<ModuleData> module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/subset/ModulesToImportDialog", "getNameOf"));
        }
        String string = ((ModuleData)module.getData()).getExternalName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/subset/ModulesToImportDialog", "getNameOf"));
        }
        return string;
    }

    public void setDescription(@NotNull String description) {
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/android/tools/idea/gradle/project/subset/ModulesToImportDialog", "setDescription"));
        }
        this.myDescriptionLabel.setText(description);
    }

    @Nullable
    protected ValidationInfo doValidate() {
        int selectionCount = this.getModulesTable().getModel().selectedRowCount;
        if (selectionCount <= 0) {
            return new ValidationInfo("Please select at least one Module", (JComponent)this.myModulesTable);
        }
        if (this.myMaxSelectionCount > 0 && selectionCount > this.myMaxSelectionCount) {
            String message = "Please select only " + this.myMaxSelectionCount + " module";
            if (this.myMaxSelectionCount > 1) {
                message = message + "s";
            }
            message = message + ".";
            return new ValidationInfo(message, (JComponent)this.myModulesTable);
        }
        return null;
    }

    private boolean hasSelectedModules() {
        return this.getModulesTable().getModel().selectedRowCount > 0;
    }

    private void setAllSelected(boolean selected) {
        ModuleTableModel model = this.getModulesTable().getModel();
        int count = model.getRowCount();
        this.mySkipValidation = true;
        for (int i = 0; i < count; ++i) {
            model.setItemSelected(i, selected);
        }
        this.mySkipValidation = false;
        if (!selected) {
            this.initValidation();
        }
        this.updateSelectionStatus();
    }

    @NotNull
    public Collection<DataNode<ModuleData>> getSelectedModules() {
        ArrayList modules = Lists.newArrayList(this.alwaysIncludedModules);
        modules.addAll(this.getUserSelectedModules());
        ArrayList arrayList = modules;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/subset/ModulesToImportDialog", "getSelectedModules"));
        }
        return arrayList;
    }

    @VisibleForTesting
    @NotNull
    public Collection<String> getDisplayedModules() {
        Collection<String> collection = this.getModulesTable().getModel().getModuleNames();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/subset/ModulesToImportDialog", "getDisplayedModules"));
        }
        return collection;
    }

    @NotNull
    private Collection<DataNode<ModuleData>> getUserSelectedModules() {
        ArrayList modules = Lists.newArrayList();
        ModuleTable table = this.getModulesTable();
        ModuleTableModel model = table.getModel();
        int count = model.getRowCount();
        for (int i = 0; i < count; ++i) {
            if (!model.isItemSelected(i)) continue;
            modules.add(model.getItemAt(i));
        }
        ArrayList arrayList = modules;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/subset/ModulesToImportDialog", "getUserSelectedModules"));
        }
        return arrayList;
    }

    private void select(@NotNull List<String> moduleNames) {
        if (moduleNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleNames", "com/android/tools/idea/gradle/project/subset/ModulesToImportDialog", "select"));
        }
        ModuleTableModel model = this.getModulesTable().getModel();
        int count = model.getRowCount();
        for (int i = 0; i < count; ++i) {
            DataNode<ModuleData> module = model.getItemAt(i);
            String name = ModulesToImportDialog.getNameOf(module);
            model.setItemSelected(i, moduleNames.contains(name));
        }
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/subset/ModulesToImportDialog", "createCenterPanel"));
        }
        return jPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myModulesTable;
    }

    private void createUIComponents() {
        this.myModulesTable = new ModuleTable();
        new TableSpeedSearch((JTable)this.myModulesTable, (PairFunction)new PairFunction<Object, Cell, String>(){

            public String fun(Object o, Cell v) {
                if (o instanceof ModuleRow) {
                    ModuleRow row = (ModuleRow)o;
                    return ModulesToImportDialog.getNameOf((DataNode<ModuleData>)row.module);
                }
                return o == null || o instanceof Boolean ? "" : o.toString();
            }
        });
    }

    public void updateSelection(@NotNull Collection<String> selection) {
        if (selection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selection", "com/android/tools/idea/gradle/project/subset/ModulesToImportDialog", "updateSelection"));
        }
        ModuleTableModel model = this.getModulesTable().getModel();
        int count = model.getRowCount();
        this.mySkipValidation = true;
        for (int i = 0; i < count; ++i) {
            DataNode<ModuleData> module = model.getItemAt(i);
            String name = ModulesToImportDialog.getNameOf(module);
            boolean selected = selection.contains(name);
            model.setItemSelected(i, selected);
        }
        this.mySkipValidation = false;
        this.initValidation();
        this.updateSelectionStatus();
    }

    public void setMaxSelectionCount(int maxSelectionCount) {
        if (maxSelectionCount == 0) {
            throw new IllegalArgumentException("Value must be different than zero");
        }
        this.myMaxSelectionCount = maxSelectionCount;
    }

    public void clearSelection() {
        List<String> selection = Collections.emptyList();
        this.updateSelection(selection);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JXLabel jXLabel;
        JPanel jPanel2;
        this.createUIComponents();
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myDescriptionLabel = jXLabel = new JXLabel();
        jXLabel.setLineWrap(true);
        jXLabel.setPaintBorderInsets(false);
        jXLabel.setText("Please select the modules to include in the project.");
        jPanel2.add((Component)jXLabel, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 1, null, null, null));
        this.myContentsPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, "Center");
        JBTable jBTable = this.myModulesTable;
        jBScrollPane.setViewportView((Component)jBTable);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private static class ModuleRow {
        @NotNull
        public final DataNode<ModuleData> module;
        @NotNull
        public final Icon icon;
        public boolean selected;

        ModuleRow(@NotNull DataNode<ModuleData> module) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/subset/ModulesToImportDialog$ModuleRow", "<init>"));
            }
            this.selected = true;
            this.module = module;
            this.icon = ModuleRow.getModuleIcon(module);
        }

        @NotNull
        private static Icon getModuleIcon(@NotNull DataNode<ModuleData> module) {
            DataNode child;
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/subset/ModulesToImportDialog$ModuleRow", "getModuleIcon"));
            }
            Collection children = ExternalSystemApiUtil.getChildren(module, AndroidProjectKeys.ANDROID_MODEL);
            if (!children.isEmpty() && (child = (DataNode)ContainerUtil.getFirstItem((Collection)children)) != null) {
                AndroidGradleModel androidModel = (AndroidGradleModel)child.getData();
                Icon icon = androidModel.getAndroidProject().isLibrary() ? AndroidIcons.LibraryModule : AndroidIcons.AppModule;
                if (icon == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/subset/ModulesToImportDialog$ModuleRow", "getModuleIcon"));
                }
                return icon;
            }
            Icon icon = AllIcons.Nodes.PpJdk;
            if (icon == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/subset/ModulesToImportDialog$ModuleRow", "getModuleIcon"));
            }
            return icon;
        }

        public String toString() {
            return ModulesToImportDialog.getNameOf((DataNode<ModuleData>)this.module);
        }
    }

    private class ModuleTableModel
    extends AbstractTableModel {
        public int selectedRowCount;
        @NotNull
        private final List<ModuleRow> rows = Lists.newArrayList();

        private ModuleTableModel() {
        }

        @NotNull
        Collection<String> getModuleNames() {
            if (this.rows.isEmpty()) {
                List<String> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/subset/ModulesToImportDialog$ModuleTableModel", "getModuleNames"));
                }
                return list;
            }
            ArrayList names = Lists.newArrayListWithExpectedSize((int)this.rows.size());
            for (ModuleRow row : this.rows) {
                names.add(ModulesToImportDialog.getNameOf((DataNode<ModuleData>)row.module));
            }
            ArrayList arrayList = names;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/subset/ModulesToImportDialog$ModuleTableModel", "getModuleNames"));
            }
            return arrayList;
        }

        @Override
        public int getRowCount() {
            return this.rows.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        @Nullable
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (rowIndex < this.rows.size()) {
                ModuleRow row = this.rows.get(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return row.selected;
                    }
                }
                return row;
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return Boolean.class;
                }
                case 1: {
                    return ModuleRow.class;
                }
            }
            return Object.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        @Override
        public void setValueAt(@Nullable Object aValue, int rowIndex, int columnIndex) {
            boolean selected;
            if (rowIndex < this.rows.size() && columnIndex == 0 && aValue instanceof Boolean && this.setItemSelected(rowIndex, selected = ((Boolean)aValue).booleanValue()) && !ModulesToImportDialog.this.mySkipValidation) {
                ModulesToImportDialog.this.initValidation();
                ModulesToImportDialog.this.updateSelectionStatus();
            }
        }

        void add(@NotNull DataNode<ModuleData> module) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/subset/ModulesToImportDialog$ModuleTableModel", "add"));
            }
            this.rows.add(new ModuleRow(module));
            ++this.selectedRowCount;
        }

        boolean isItemSelected(int rowIndex) {
            ModuleRow row = this.rows.get(rowIndex);
            return row.selected;
        }

        @NotNull
        DataNode<ModuleData> getItemAt(int rowIndex) {
            ModuleRow row = this.rows.get(rowIndex);
            DataNode<ModuleData> dataNode = row.module;
            if (dataNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/subset/ModulesToImportDialog$ModuleTableModel", "getItemAt"));
            }
            return dataNode;
        }

        boolean setItemSelected(int rowIndex, boolean selected) {
            ModuleRow row = this.rows.get(rowIndex);
            if (row.selected != selected) {
                row.selected = selected;
                this.selectedRowCount = row.selected ? ++this.selectedRowCount : --this.selectedRowCount;
                return true;
            }
            return false;
        }
    }

    private static class ModuleTableRowSorter
    extends TableRowSorter<ModuleTableModel> {
        ModuleTableRowSorter(@NotNull ModuleTableModel model) {
            if (model == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/gradle/project/subset/ModulesToImportDialog$ModuleTableRowSorter", "<init>"));
            }
            super(model);
            this.setComparator(1, new Comparator<ModuleRow>(){

                @Override
                public int compare(ModuleRow row1, ModuleRow row2) {
                    return Collator.getInstance().compare(row1.toString(), row2.toString());
                }
            });
            ArrayList sortKeys = Lists.newArrayList();
            sortKeys.add(new RowSorter.SortKey(1, SortOrder.ASCENDING));
            this.setSortKeys(sortKeys);
        }
    }

    private class ModuleTable
    extends JBTable {
        private ModuleTableRowSorter myRowSorter;
        private boolean myShowSelectedRowsOnly;

        ModuleTable() {
            super((TableModel)new ModuleTableModel());
            this.setCheckBoxColumnWidth();
            this.setModuleNameCellRenderer();
            this.setAutoResizeMode(3);
            this.setIntercellSpacing(new Dimension(0, 0));
            this.setRowSelectionAllowed(true);
            this.setSelectionMode(0);
            this.setShowGrid(false);
            this.setTableHeader(null);
        }

        private void setCheckBoxColumnWidth() {
            TableColumn column = this.getColumnModel().getColumn(0);
            int width = 30;
            column.setMaxWidth(width);
            column.setPreferredWidth(width);
            column.setWidth(width);
        }

        private void setModuleNameCellRenderer() {
            TableColumn column = this.getColumnModel().getColumn(1);
            column.setCellRenderer(new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int columnIndex) {
                    Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, rowIndex, columnIndex);
                    if (c instanceof JLabel && value instanceof ModuleRow) {
                        JLabel label = (JLabel)c;
                        ModuleRow row = (ModuleRow)value;
                        label.setIcon(row.icon);
                        label.setText(ModulesToImportDialog.getNameOf((DataNode<ModuleData>)row.module));
                    }
                    return c;
                }
            });
        }

        void updateFilter() {
            this.setShowSelectedRowsOnly(this.myShowSelectedRowsOnly);
        }

        void setShowSelectedRowsOnly(boolean showSelectedRowsOnly) {
            this.myShowSelectedRowsOnly = showSelectedRowsOnly;
            if (this.myRowSorter == null) {
                this.sort();
            }
            if (showSelectedRowsOnly) {
                this.myRowSorter.setRowFilter(new RowFilter<ModuleTableModel, Integer>(){

                    @Override
                    public boolean include(RowFilter.Entry<? extends ModuleTableModel, ? extends Integer> entry) {
                        Object value = entry.getValue(1);
                        if (value instanceof ModuleRow) {
                            ModuleRow row = (ModuleRow)value;
                            return row.selected;
                        }
                        return false;
                    }
                });
            } else {
                this.myRowSorter.setRowFilter(null);
            }
        }

        void sort() {
            this.myRowSorter = new ModuleTableRowSorter(this.getModel());
            this.setRowSorter(this.myRowSorter);
        }

        @NotNull
        public ModuleTableModel getModel() {
            ModuleTableModel moduleTableModel = (ModuleTableModel)super.getModel();
            if (moduleTableModel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/subset/ModulesToImportDialog$ModuleTable", "getModel"));
            }
            return moduleTableModel;
        }
    }

    @VisibleForTesting
    static class Selection {
        @NonNls
        private static final String ROOT_ELEMENT_NAME = "selectedModules";
        @NonNls
        private static final String MODULE_ELEMENT_NAME = "module";
        @NonNls
        private static final String MODULE_NAME_ATTRIBUTE_NAME = "name";

        Selection() {
        }

        @NotNull
        static List<String> load(@NotNull File file) throws JDOMException, IOException {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/gradle/project/subset/ModulesToImportDialog$Selection", "load"));
            }
            Document document = JDOMUtil.loadDocument((File)file);
            ArrayList modules = Lists.newArrayList();
            Element rootElement = document.getRootElement();
            if (rootElement != null && ROOT_ELEMENT_NAME.equals(rootElement.getName())) {
                for (Element child : rootElement.getChildren(MODULE_ELEMENT_NAME)) {
                    String moduleName = child.getAttributeValue(MODULE_NAME_ATTRIBUTE_NAME);
                    if (!StringUtil.isNotEmpty((String)moduleName)) continue;
                    modules.add(moduleName);
                }
            }
            ArrayList arrayList = modules;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/subset/ModulesToImportDialog$Selection", "load"));
            }
            return arrayList;
        }

        static void save(@NotNull Collection<DataNode<ModuleData>> modules, @NotNull File file) throws IOException {
            if (modules == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/android/tools/idea/gradle/project/subset/ModulesToImportDialog$Selection", "save"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/gradle/project/subset/ModulesToImportDialog$Selection", "save"));
            }
            Document document = new Document(new Element(ROOT_ELEMENT_NAME));
            for (DataNode<ModuleData> module : modules) {
                Element child = new Element(MODULE_ELEMENT_NAME);
                child.setAttribute(MODULE_NAME_ATTRIBUTE_NAME, ModulesToImportDialog.getNameOf((DataNode<ModuleData>)module));
                document.getRootElement().addContent(child);
            }
            JDOMUtil.writeDocument((Document)document, (File)file, (String)SystemProperties.getLineSeparator());
        }
    }

    private class SaveToFileAction
    extends DumbAwareAction {
        SaveToFileAction() {
            super("Save Selection As", null, AllIcons.Actions.Menu_saveall);
            this.registerCustomShortcutSet(83, SystemInfo.isMac ? 4 : 2, (JComponent)ModulesToImportDialog.this.myModulesTable);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/gradle/project/subset/ModulesToImportDialog$SaveToFileAction", "update"));
            }
            e.getPresentation().setEnabled(ModulesToImportDialog.this.hasSelectedModules());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            VirtualFile baseDir;
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/gradle/project/subset/ModulesToImportDialog$SaveToFileAction", "actionPerformed"));
            }
            String title = "Save Module Selection";
            FileSaverDescriptor descriptor = new FileSaverDescriptor(title, "Save the list of selected Modules to a file", new String[]{"xml"});
            FileSaverDialog dialog = FileChooserFactory.getInstance().createSaveFileDialog(descriptor, (Component)ModulesToImportDialog.this.getWindow());
            VirtualFileWrapper result = dialog.save(baseDir = ModulesToImportDialog.this.myProject != null ? ModulesToImportDialog.this.myProject.getBaseDir() : null, null);
            if (result != null) {
                File file = result.getFile();
                try {
                    Selection.save(ModulesToImportDialog.this.getUserSelectedModules(), file);
                }
                catch (IOException error) {
                    String msg = String.format("Failed to save Module selection to file '%1$s'", file.getPath());
                    Messages.showErrorDialog((Component)ModulesToImportDialog.this.getWindow(), (String)msg, (String)title);
                    String cause = error.getMessage();
                    if (StringUtil.isNotEmpty((String)cause)) {
                        msg = msg + ":\n" + cause;
                    }
                    Logger.getInstance(ModulesToImportDialog.class).info(msg, (Throwable)error);
                }
            }
        }
    }

    private class LoadFromFileAction
    extends DumbAwareAction {
        LoadFromFileAction() {
            super("Load Selection from File", null, AllIcons.Actions.Menu_open);
            this.registerCustomShortcutSet(79, SystemInfo.isMac ? 4 : 2, (JComponent)ModulesToImportDialog.this.myModulesTable);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/gradle/project/subset/ModulesToImportDialog$LoadFromFileAction", "actionPerformed"));
            }
            FileChooserDescriptor descriptor = new FileChooserDescriptor(true, false, false, false, false, false){

                public boolean isFileSelectable(VirtualFile file) {
                    boolean selectable = super.isFileSelectable(file);
                    if (selectable) {
                        selectable = "xml".equals(file.getExtension());
                    }
                    return selectable;
                }
            };
            String title = "Load Module Selection";
            descriptor.setTitle(title);
            FileChooserDialog dialog = FileChooserFactory.getInstance().createFileChooser(descriptor, ModulesToImportDialog.this.myProject, (Component)ModulesToImportDialog.this.getWindow());
            VirtualFile[] allSelected = dialog.choose(ModulesToImportDialog.this.myProject, new VirtualFile[0]);
            if (allSelected.length > 0) {
                File file = VfsUtilCore.virtualToIoFile((VirtualFile)allSelected[0]);
                try {
                    List<String> loadedModuleNames = Selection.load(file);
                    ModulesToImportDialog.this.select(loadedModuleNames);
                }
                catch (Throwable error) {
                    String msg = String.format("Failed to load Module selection from file '%1$s'", file.getPath());
                    Messages.showErrorDialog((Component)ModulesToImportDialog.this.getWindow(), (String)msg, (String)title);
                    String cause = error.getMessage();
                    if (StringUtil.isNotEmpty((String)cause)) {
                        msg = msg + ":\n" + cause;
                    }
                    Logger.getInstance(ModulesToImportDialog.class).info(msg, error);
                }
            }
        }
    }

    private class SelectAllAction
    extends DumbAwareAction {
        private final boolean mySelect;

        SelectAllAction(boolean select) {
            super(select ? "Select All" : "Unselect All", null, select ? PlatformIcons.SELECT_ALL_ICON : PlatformIcons.UNSELECT_ALL_ICON);
            this.mySelect = select;
            int keyCode = select ? 65 : 78;
            this.registerCustomShortcutSet(keyCode, SystemInfo.isMac ? 4 : 2, (JComponent)ModulesToImportDialog.this.myModulesTable);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/gradle/project/subset/ModulesToImportDialog$SelectAllAction", "update"));
            }
            int rowCount = ModulesToImportDialog.this.getModulesTable().getModel().getRowCount();
            e.getPresentation().setEnabled(rowCount > 0);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/gradle/project/subset/ModulesToImportDialog$SelectAllAction", "actionPerformed"));
            }
            ModulesToImportDialog.this.setAllSelected(this.mySelect);
        }
    }

    private static class ShowSelectedModulesAction
    extends ToggleAction {
        private ModuleTable myTable;

        ShowSelectedModulesAction(@NotNull ModuleTable table) {
            if (table == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/android/tools/idea/gradle/project/subset/ModulesToImportDialog$ShowSelectedModulesAction", "<init>"));
            }
            super("Show Selected Modules Only", null, AllIcons.Actions.ShowHiddens);
            this.myTable = table;
        }

        public boolean isSelected(AnActionEvent e) {
            return this.myTable.myShowSelectedRowsOnly;
        }

        public void setSelected(AnActionEvent e, boolean state) {
            this.myTable.setShowSelectedRowsOnly(state);
        }
    }
}

