/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;

public final class PsiElements {
    private PsiElements() {
    }

    @Nullable
    public static String getUnquotedText(@NotNull GrLiteral literal) {
        if (literal == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literal", "com/android/tools/idea/gradle/dsl/parser/PsiElements", "getUnquotedText"));
        }
        String text = literal.getText();
        if (text != null && text.length() > 2 && StringUtil.isQuotedString((String)text)) {
            return StringUtil.unquoteString((String)text);
        }
        return null;
    }

    @Nullable
    public static GrClosableBlock findClosableBlock(@NotNull GrMethodCallExpression expression, String ... possibleBlockNames) {
        GrClosableBlock closableBlock;
        GrClosableBlock[] closureArguments;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/android/tools/idea/gradle/dsl/parser/PsiElements", "findClosableBlock"));
        }
        if (possibleBlockNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "possibleBlockNames", "com/android/tools/idea/gradle/dsl/parser/PsiElements", "findClosableBlock"));
        }
        GrExpression invokedExpression = expression.getInvokedExpression();
        GrReferenceExpression childExpression = (GrReferenceExpression)PsiTreeUtil.findChildOfType((PsiElement)invokedExpression, GrReferenceExpression.class, (boolean)false);
        if (PsiElements.isNotNullWithText((PsiElement)childExpression, possibleBlockNames) && (closureArguments = expression.getClosureArguments()).length > 0 && (closableBlock = closureArguments[0]) != null) {
            return closableBlock;
        }
        return null;
    }

    public static boolean isNotNullWithText(@Nullable PsiElement e, String ... possibleTextValues) {
        if (possibleTextValues == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "possibleTextValues", "com/android/tools/idea/gradle/dsl/parser/PsiElements", "isNotNullWithText"));
        }
        if (e != null) {
            String elementText = e.getText();
            for (String text : possibleTextValues) {
                if (!text.equals(elementText)) continue;
                return true;
            }
        }
        return false;
    }

    public static GrLiteral setLiteralText(@NotNull GrLiteral literal, @NotNull String text) {
        if (literal == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literal", "com/android/tools/idea/gradle/dsl/parser/PsiElements", "setLiteralText"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/gradle/dsl/parser/PsiElements", "setLiteralText"));
        }
        Project project = literal.getProject();
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)project);
        GrLiteral newLiteral = factory.createLiteralFromValue((Object)text);
        PsiElement replace = literal.replace((PsiElement)newLiteral);
        assert (replace instanceof GrLiteral);
        return (GrLiteral)replace;
    }
}

