/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme;

import com.android.SdkConstants;
import com.android.ide.common.rendering.api.ItemResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.ResourceUrl;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.editors.theme.datamodels.ThemeEditorStyle;
import com.android.tools.lint.checks.ApiLookup;
import com.google.common.base.Strings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.inspections.lint.IntellijLintClient;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResolutionUtils {
    private static final Logger LOG = Logger.getInstance(ResolutionUtils.class);
    private static final Pattern RESOURCE_URL_MATCHER = Pattern.compile("@(.*:)?(.+/)(.+)");

    private ResolutionUtils() {
    }

    @NotNull
    public static String getStyleResourceUrl(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/android/tools/idea/editors/theme/ResolutionUtils", "getStyleResourceUrl"));
        }
        int colonIndex = qualifiedName.indexOf(58);
        if (colonIndex != -1) {
            String namespace = qualifiedName.substring(0, colonIndex + 1);
            String themeNameWithoutNamespace = StringUtil.trimStart((String)qualifiedName, (String)namespace);
            String string = "@" + namespace + "style" + "/" + themeNameWithoutNamespace;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ResolutionUtils", "getStyleResourceUrl"));
            }
            return string;
        }
        String string = "@style/" + qualifiedName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ResolutionUtils", "getStyleResourceUrl"));
        }
        return string;
    }

    @NotNull
    public static String getQualifiedNameFromResourceUrl(@NotNull String styleResourceUrl) {
        if (styleResourceUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "styleResourceUrl", "com/android/tools/idea/editors/theme/ResolutionUtils", "getQualifiedNameFromResourceUrl"));
        }
        Matcher matcher = RESOURCE_URL_MATCHER.matcher(styleResourceUrl);
        boolean matches = matcher.find();
        assert (matches);
        String namespace = Strings.nullToEmpty((String)matcher.group(1));
        String resourceName = matcher.group(3);
        String string = namespace + resourceName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ResolutionUtils", "getQualifiedNameFromResourceUrl"));
        }
        return string;
    }

    @NotNull
    public static String getNameFromQualifiedName(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/android/tools/idea/editors/theme/ResolutionUtils", "getNameFromQualifiedName"));
        }
        if (qualifiedName.startsWith("android:")) {
            String string = qualifiedName.substring("android:".length());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ResolutionUtils", "getNameFromQualifiedName"));
            }
            return string;
        }
        String string = qualifiedName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ResolutionUtils", "getNameFromQualifiedName"));
        }
        return string;
    }

    @NotNull
    public static String getQualifiedStyleName(@NotNull StyleResourceValue style) {
        if (style == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "style", "com/android/tools/idea/editors/theme/ResolutionUtils", "getQualifiedStyleName"));
        }
        String string = (style.isFramework() ? "android:" : "") + style.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ResolutionUtils", "getQualifiedStyleName"));
        }
        return string;
    }

    @NotNull
    public static String getQualifiedItemName(@NotNull ItemResourceValue item) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/android/tools/idea/editors/theme/ResolutionUtils", "getQualifiedItemName"));
        }
        String string = (item.isFrameworkAttr() ? "android:" : "") + item.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ResolutionUtils", "getQualifiedItemName"));
        }
        return string;
    }

    @NotNull
    public static String getQualifiedValue(@NotNull ItemResourceValue item) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/android/tools/idea/editors/theme/ResolutionUtils", "getQualifiedValue"));
        }
        ResourceUrl url = ResourceUrl.parse((String)item.getRawXmlValue(), (boolean)item.isFramework());
        String string = url == null ? item.getRawXmlValue() : url.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ResolutionUtils", "getQualifiedValue"));
        }
        return string;
    }

    @Nullable
    private static StyleResourceValue getStyleResourceValue(@NotNull ResourceResolver resolver, @NotNull String qualifiedStyleName) {
        boolean isFrameworkStyle;
        String styleName;
        if (resolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "com/android/tools/idea/editors/theme/ResolutionUtils", "getStyleResourceValue"));
        }
        if (qualifiedStyleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedStyleName", "com/android/tools/idea/editors/theme/ResolutionUtils", "getStyleResourceValue"));
        }
        assert (!qualifiedStyleName.startsWith("@android:style/"));
        assert (!qualifiedStyleName.startsWith("@style/"));
        if (qualifiedStyleName.startsWith("android:")) {
            styleName = qualifiedStyleName.substring("android:".length());
            isFrameworkStyle = true;
        } else {
            styleName = qualifiedStyleName;
            isFrameworkStyle = false;
        }
        return resolver.getStyle(styleName, isFrameworkStyle);
    }

    @Nullable
    public static ThemeEditorStyle getStyle(@NotNull Configuration configuration, @NotNull ResourceResolver resolver, @NotNull String qualifiedStyleName, @Nullable Module module) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/editors/theme/ResolutionUtils", "getStyle"));
        }
        if (resolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "com/android/tools/idea/editors/theme/ResolutionUtils", "getStyle"));
        }
        if (qualifiedStyleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedStyleName", "com/android/tools/idea/editors/theme/ResolutionUtils", "getStyle"));
        }
        StyleResourceValue style = ResolutionUtils.getStyleResourceValue(resolver, qualifiedStyleName);
        return style == null ? null : new ThemeEditorStyle(configuration, style, module);
    }

    @Nullable
    public static ThemeEditorStyle getStyle(@NotNull Configuration configuration, @NotNull String qualifiedStyleName, @Nullable Module module) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/editors/theme/ResolutionUtils", "getStyle"));
        }
        if (qualifiedStyleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedStyleName", "com/android/tools/idea/editors/theme/ResolutionUtils", "getStyle"));
        }
        ResourceResolver resolver = configuration.getResourceResolver();
        assert (resolver != null);
        return ResolutionUtils.getStyle(configuration, configuration.getResourceResolver(), qualifiedStyleName, module);
    }

    @Nullable
    public static AttributeDefinition getAttributeDefinition(@NotNull Configuration configuration, @NotNull ItemResourceValue itemResValue) {
        AttributeDefinitions definitions;
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/editors/theme/ResolutionUtils", "getAttributeDefinition"));
        }
        if (itemResValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "itemResValue", "com/android/tools/idea/editors/theme/ResolutionUtils", "getAttributeDefinition"));
        }
        Module module = configuration.getModule();
        if (itemResValue.isFrameworkAttr()) {
            IAndroidTarget target = configuration.getTarget();
            assert (target != null);
            AndroidTargetData androidTargetData = AndroidTargetData.getTargetData(target, module);
            assert (androidTargetData != null);
            definitions = androidTargetData.getAllAttrDefs(module.getProject());
        } else {
            AndroidFacet facet = AndroidFacet.getInstance(module);
            assert (facet != null) : String.format("Module %s is not an Android module", module.getName());
            definitions = facet.getLocalResourceManager().getAttributeDefinitions();
        }
        if (definitions == null) {
            return null;
        }
        return definitions.getAttrDefByName(itemResValue.getName());
    }

    public static int getOriginalApiLevel(@Nullable String name, @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/editors/theme/ResolutionUtils", "getOriginalApiLevel"));
        }
        if (name == null) {
            return -1;
        }
        ApiLookup apiLookup = IntellijLintClient.getApiLookup(project);
        if (apiLookup == null) {
            LOG.warn("Could not find Lint client for project " + project.getName());
            return -1;
        }
        ResourceUrl resUrl = ResourceUrl.parse((String)name);
        if (resUrl == null) {
            if (!name.startsWith("android:")) {
                return -1;
            }
            return apiLookup.getFieldVersion("android/R$attr", name.substring(SdkConstants.ANDROID_NS_NAME_PREFIX_LEN));
        }
        if (!resUrl.framework) {
            return -1;
        }
        return apiLookup.getFieldVersion("android/R$" + resUrl.type, AndroidResourceUtil.getFieldNameByResourceName(resUrl.name));
    }

    @Nullable(value="if this style doesn't have parent")
    public static String getParentQualifiedName(@NotNull StyleResourceValue style) {
        if (style == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "style", "com/android/tools/idea/editors/theme/ResolutionUtils", "getParentQualifiedName"));
        }
        String parentName = ResourceResolver.getParentName((StyleResourceValue)style);
        if (parentName == null) {
            return null;
        }
        if (parentName.startsWith("@")) {
            parentName = ResolutionUtils.getQualifiedNameFromResourceUrl(parentName);
        }
        if (style.isFramework() && !parentName.startsWith("android:")) {
            parentName = "android:" + parentName;
        }
        return parentName;
    }
}

