/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme;

import com.android.ide.common.rendering.api.ItemResourceValue;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.tools.idea.editors.theme.ThemeEditorContext;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.editors.theme.datamodels.ThemeEditorStyle;
import com.android.tools.idea.rendering.ResourceHelper;
import com.android.utils.Pair;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.awt.Color;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ColorUtils {
    private static final Logger LOG = Logger.getInstance(ColorUtils.class);
    @NotNull
    private static final ImmutableSetMultimap<String, String> CONTRAST_MAP;
    @NotNull
    private static final ImmutableSet<String> BACKGROUND_ATTRIBUTES;
    private static final double THRESHOLD = 4.5;
    private static final String DISABLED_PREFIX = "Disabled";

    @NotNull
    public static ImmutableSet<ItemResourceValue> getContrastItems(@NotNull ThemeEditorContext context, @NotNull String styleAttributeName) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/editors/theme/ColorUtils", "getContrastItems"));
        }
        if (styleAttributeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "styleAttributeName", "com/android/tools/idea/editors/theme/ColorUtils", "getContrastItems"));
        }
        ImmutableSet contrastColorSet = CONTRAST_MAP.get((Object)styleAttributeName);
        if (contrastColorSet == null) {
            ImmutableSet immutableSet = ImmutableSet.of();
            if (immutableSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ColorUtils", "getContrastItems"));
            }
            return immutableSet;
        }
        ImmutableSet.Builder contrastItemsBuilder = ImmutableSet.builder();
        ThemeEditorStyle currentTheme = context.getCurrentTheme();
        assert (currentTheme != null);
        for (String contrastColor : contrastColorSet) {
            ItemResourceValue contrastItem = ThemeEditorUtils.resolveItemFromParents(currentTheme, contrastColor, false);
            if (contrastItem == null) {
                contrastItem = ThemeEditorUtils.resolveItemFromParents(currentTheme, contrastColor, true);
            }
            if (contrastItem == null) continue;
            contrastItemsBuilder.add((Object)contrastItem);
        }
        ImmutableSet immutableSet = contrastItemsBuilder.build();
        if (immutableSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ColorUtils", "getContrastItems"));
        }
        return immutableSet;
    }

    @NotNull
    public static ImmutableMap<String, Color> getContrastColorsWithDescription(@NotNull ThemeEditorContext context, @NotNull String styleAttributeName) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/editors/theme/ColorUtils", "getContrastColorsWithDescription"));
        }
        if (styleAttributeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "styleAttributeName", "com/android/tools/idea/editors/theme/ColorUtils", "getContrastColorsWithDescription"));
        }
        ImmutableMap.Builder contrastColorsBuilder = ImmutableMap.builder();
        ResourceResolver styleResourceResolver = context.getResourceResolver();
        assert (styleResourceResolver != null);
        Project project = context.getProject();
        ImmutableSet<ItemResourceValue> contrastItems = ColorUtils.getContrastItems(context, styleAttributeName);
        for (ItemResourceValue contrastItem : contrastItems) {
            ResourceHelper.StateList stateList = ResourceHelper.resolveStateList((RenderResources)styleResourceResolver, (ResourceValue)contrastItem, project);
            if (stateList != null) {
                ImmutableList<ResourceHelper.StateListState> disabledStates = stateList.getDisabledStates();
                for (ResourceHelper.StateListState stateListState : stateList.getStates()) {
                    Color stateListColor = ResourceHelper.resolveColor((RenderResources)styleResourceResolver, styleResourceResolver.findResValue(stateListState.getValue(), false), project);
                    if (stateListColor == null) continue;
                    try {
                        stateListColor = ResourceHelper.makeColorWithAlpha((RenderResources)styleResourceResolver, stateListColor, stateListState.getAlpha());
                    }
                    catch (NumberFormatException e) {
                        LOG.warn(String.format("The alpha attribute in %1$s/%2$s does not resolve to a floating point number", stateList.getDirName(), stateList.getFileName()));
                    }
                    String disabledPrefix = disabledStates.contains(stateListState) ? DISABLED_PREFIX : "";
                    contrastColorsBuilder.put((Object)(disabledPrefix + ThemeEditorUtils.generateWordEnumeration(stateListState.getAttributesNames(false)) + " <b>" + contrastItem.getName() + "</b>"), (Object)stateListColor);
                }
                continue;
            }
            Color resolvedColor = ResourceHelper.resolveColor((RenderResources)styleResourceResolver, (ResourceValue)contrastItem, project);
            if (resolvedColor == null) continue;
            contrastColorsBuilder.put((Object)("<b>" + contrastItem.getName() + "</b>"), (Object)resolvedColor);
        }
        ImmutableMap immutableMap = contrastColorsBuilder.build();
        if (immutableMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ColorUtils", "getContrastColorsWithDescription"));
        }
        return immutableMap;
    }

    @NotNull
    public static String getContrastWarningMessage(@NotNull Map<String, Color> contrastColorsWithDescription, @NotNull Color color, boolean isBackground) {
        if (contrastColorsWithDescription == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contrastColorsWithDescription", "com/android/tools/idea/editors/theme/ColorUtils", "getContrastWarningMessage"));
        }
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/android/tools/idea/editors/theme/ColorUtils", "getContrastWarningMessage"));
        }
        ImmutableSet.Builder lowContrastColorsBuilder = ImmutableSet.builder();
        for (Map.Entry<String, Color> contrastColor : contrastColorsWithDescription.entrySet()) {
            Color backgroundColor;
            String colorDescription = contrastColor.getKey();
            if (colorDescription.startsWith(DISABLED_PREFIX)) continue;
            Color otherColor = contrastColor.getValue();
            if (isBackground) {
                backgroundColor = ColorUtils.worstContrastColor(otherColor, color);
                color = ColorUtils.alphaBlending(color, backgroundColor);
                otherColor = ColorUtils.alphaBlending(otherColor, color);
            } else {
                backgroundColor = ColorUtils.worstContrastColor(color, otherColor);
                otherColor = ColorUtils.alphaBlending(otherColor, backgroundColor);
                color = ColorUtils.alphaBlending(color, otherColor);
            }
            if (!(ColorUtils.calculateContrastRatio(color, otherColor) < 4.5)) continue;
            lowContrastColorsBuilder.add((Object)colorDescription);
        }
        ImmutableSet lowContrastColors = lowContrastColorsBuilder.build();
        if (!lowContrastColors.isEmpty()) {
            String string = "<html>Not enough contrast with " + ThemeEditorUtils.generateWordEnumeration((Collection<String>)lowContrastColors);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ColorUtils", "getContrastWarningMessage"));
            }
            return string;
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ColorUtils", "getContrastWarningMessage"));
        }
        return "";
    }

    @NotNull
    public static Color worstContrastColor(@NotNull Color foreground, @NotNull Color background) {
        if (foreground == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foreground", "com/android/tools/idea/editors/theme/ColorUtils", "worstContrastColor"));
        }
        if (background == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "background", "com/android/tools/idea/editors/theme/ColorUtils", "worstContrastColor"));
        }
        int backgroundAlpha = background.getAlpha();
        int r = ColorUtils.worstContrastComponent(foreground.getRed(), background.getRed(), backgroundAlpha);
        int g = ColorUtils.worstContrastComponent(foreground.getGreen(), background.getGreen(), backgroundAlpha);
        int b = ColorUtils.worstContrastComponent(foreground.getBlue(), background.getBlue(), backgroundAlpha);
        Color color = new Color(r, g, b);
        if (color == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ColorUtils", "worstContrastColor"));
        }
        return color;
    }

    private static int worstContrastComponent(int foregroundComponent, int backgroundComponent, int backgroundAlpha) {
        if (backgroundAlpha == 255) {
            return 0;
        }
        int component = (255 * foregroundComponent - backgroundAlpha * backgroundComponent) / (255 - backgroundAlpha);
        return ResourceHelper.clamp(component, 0, 255);
    }

    @NotNull
    public static Color alphaBlending(@NotNull Color foreground, @NotNull Color background) {
        if (foreground == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foreground", "com/android/tools/idea/editors/theme/ColorUtils", "alphaBlending"));
        }
        if (background == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "background", "com/android/tools/idea/editors/theme/ColorUtils", "alphaBlending"));
        }
        float foregroundAlpha = (float)foreground.getAlpha() / 255.0f;
        float backgroundAlpha = (float)background.getAlpha() / 255.0f;
        float a = foregroundAlpha + backgroundAlpha * (1.0f - foregroundAlpha);
        float r = ColorUtils.alphaBlendingComponent(foreground.getRed(), foregroundAlpha, background.getRed(), backgroundAlpha);
        float g = ColorUtils.alphaBlendingComponent(foreground.getGreen(), foregroundAlpha, background.getGreen(), backgroundAlpha);
        float b = ColorUtils.alphaBlendingComponent(foreground.getBlue(), foregroundAlpha, background.getBlue(), backgroundAlpha);
        Color color = new Color(r, g, b, a);
        if (color == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ColorUtils", "alphaBlending"));
        }
        return color;
    }

    private static float alphaBlendingComponent(int foregroundComponent, float foregroundAlpha, int backgroundComponent, float backgroundAlpha) {
        float alpha = foregroundAlpha + backgroundAlpha * (1.0f - foregroundAlpha);
        if ((double)Math.abs(alpha) < 0.001) {
            return 1.0f;
        }
        return (foregroundAlpha * (float)foregroundComponent + backgroundAlpha * (float)backgroundComponent * (1.0f - foregroundAlpha)) / (255.0f * alpha);
    }

    public static boolean isBackgroundAttribute(String text) {
        return BACKGROUND_ATTRIBUTES.contains((Object)text);
    }

    public static double calculateContrastRatio(@NotNull Color color1, @NotNull Color color2) {
        if (color1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color1", "com/android/tools/idea/editors/theme/ColorUtils", "calculateContrastRatio"));
        }
        if (color2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color2", "com/android/tools/idea/editors/theme/ColorUtils", "calculateContrastRatio"));
        }
        double color1Luminance = ColorUtils.calculateColorLuminance(color1);
        double color2Luminance = ColorUtils.calculateColorLuminance(color2);
        return (Math.max(color1Luminance, color2Luminance) + 0.05) / (Math.min(color2Luminance, color1Luminance) + 0.05);
    }

    private static double calculateColorLuminance(@NotNull Color color) {
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/android/tools/idea/editors/theme/ColorUtils", "calculateColorLuminance"));
        }
        return ColorUtils.calculateLuminanceContribution((double)color.getRed() / 255.0) * 0.2126 + ColorUtils.calculateLuminanceContribution((double)color.getGreen() / 255.0) * 0.7152 + ColorUtils.calculateLuminanceContribution((double)color.getBlue() / 255.0) * 0.0722;
    }

    private static double calculateLuminanceContribution(double colorValue) {
        if (colorValue <= 0.03928) {
            return colorValue / 12.92;
        }
        return Math.pow((colorValue + 0.055) / 1.055, 2.4);
    }

    static {
        Pair[] contrastPairs = new Pair[]{Pair.of((Object)"textColor", (Object)"colorBackground"), Pair.of((Object)"textColor", (Object)"colorPrimary"), Pair.of((Object)"textColorPrimary", (Object)"colorButtonNormal"), Pair.of((Object)"textColorPrimary", (Object)"colorPrimary"), Pair.of((Object)"textColorPrimary", (Object)"colorBackground")};
        ImmutableSetMultimap.Builder contrastMapBuilder = ImmutableSetMultimap.builder();
        ImmutableSet.Builder backgroundAttributesBuilder = ImmutableSet.builder();
        for (Pair pair : contrastPairs) {
            contrastMapBuilder.put(pair.getFirst(), pair.getSecond());
            contrastMapBuilder.put(pair.getSecond(), pair.getFirst());
            backgroundAttributesBuilder.add(pair.getSecond());
        }
        CONTRAST_MAP = contrastMapBuilder.build();
        BACKGROUND_ATTRIBUTES = backgroundAttributesBuilder.build();
    }
}

