/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings.table;

import com.android.ide.common.res2.ResourceItem;
import com.android.tools.idea.configurations.LocaleMenuAction;
import com.android.tools.idea.editors.strings.StringResourceData;
import com.android.tools.idea.editors.strings.table.ConstantColumn;
import com.android.tools.idea.rendering.Locale;
import javax.swing.table.AbstractTableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringResourceTableModel
extends AbstractTableModel {
    @Nullable
    private StringResourceData myData;

    public void setData(@NotNull StringResourceData data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/android/tools/idea/editors/strings/table/StringResourceTableModel", "setData"));
        }
        this.myData = data;
    }

    @NotNull
    public String keyOfRow(int row) {
        String string = this.myData == null ? "" : this.myData.getKeys().get(row);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/strings/table/StringResourceTableModel", "keyOfRow"));
        }
        return string;
    }

    @Nullable
    public Locale localeOfColumn(int column) {
        return column < ConstantColumn.COUNT || this.myData == null ? null : this.myData.getLocales().get(column - ConstantColumn.COUNT);
    }

    @Override
    public int getRowCount() {
        return this.myData == null ? 0 : this.myData.getKeys().size();
    }

    @Override
    public int getColumnCount() {
        return this.myData == null ? 0 : this.myData.getLocales().size() + ConstantColumn.COUNT;
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        assert (this.myData != null);
        if (ConstantColumn.KEY.ordinal() == column) {
            this.myData.changeKeyName(row, (String)value);
            this.fireTableRowsUpdated(0, this.myData.getKeys().size());
        } else if (ConstantColumn.UNTRANSLATABLE.ordinal() == column) {
            Boolean doNotTranslate = (Boolean)value;
            if (this.myData.setDoNotTranslate(this.keyOfRow(row), doNotTranslate)) {
                this.fireTableCellUpdated(row, column);
            }
        } else if (this.myData.setTranslation(this.keyOfRow(row), this.localeOfColumn(column), (String)value)) {
            this.fireTableCellUpdated(row, column);
        }
    }

    @Override
    @NotNull
    public Object getValueAt(int row, int column) {
        if (this.myData == null) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/strings/table/StringResourceTableModel", "getValueAt"));
            }
            return "";
        }
        if (column >= ConstantColumn.COUNT) {
            Locale locale = this.localeOfColumn(column);
            String string = this.myData.getTranslations().contains((Object)this.keyOfRow(row), (Object)locale) ? StringResourceData.resourceToString((ResourceItem)this.myData.getTranslations().get((Object)this.keyOfRow(row), (Object)locale)) : "";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/strings/table/StringResourceTableModel", "getValueAt"));
            }
            return string;
        }
        switch (ConstantColumn.values()[column]) {
            case KEY: {
                String string = this.keyOfRow(row);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/strings/table/StringResourceTableModel", "getValueAt"));
                }
                return string;
            }
            case DEFAULT_VALUE: {
                String string = this.myData.getDefaultValues().containsKey(this.keyOfRow(row)) ? StringResourceData.resourceToString(this.myData.getDefaultValues().get(this.keyOfRow(row))) : "";
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/strings/table/StringResourceTableModel", "getValueAt"));
                }
                return string;
            }
            case UNTRANSLATABLE: {
                Boolean bl = this.myData.getUntranslatableKeys().contains(this.keyOfRow(row));
                if (bl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/strings/table/StringResourceTableModel", "getValueAt"));
                }
                return bl;
            }
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/strings/table/StringResourceTableModel", "getValueAt"));
        }
        return "";
    }

    @Override
    public String getColumnName(int column) {
        if (column >= ConstantColumn.COUNT) {
            return LocaleMenuAction.getLocaleLabel(this.localeOfColumn(column), false);
        }
        return ConstantColumn.values()[column].name;
    }

    public Class getColumnClass(int column) {
        if (column >= ConstantColumn.COUNT) {
            return ConstantColumn.DEFAULT_VALUE.sampleData.getClass();
        }
        return ConstantColumn.values()[column].sampleData.getClass();
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return true;
    }

    @Nullable
    public String getCellProblem(int row, int column) {
        if (this.myData == null) {
            return null;
        }
        String key = this.keyOfRow(row);
        if (ConstantColumn.KEY.ordinal() == column) {
            return this.myData.validateKey(key);
        }
        Locale l = this.localeOfColumn(column);
        return this.myData.validateTranslation(key, l);
    }
}

