/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.impl.YAMLValueImpl;

public abstract class YAMLScalarImpl
extends YAMLValueImpl
implements YAMLScalar {
    public YAMLScalarImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/yaml/psi/impl/YAMLScalarImpl", "<init>"));
        }
        super(node);
    }

    @NotNull
    public abstract List<TextRange> getContentRanges();

    @NotNull
    protected abstract String getRangesJoiner(@NotNull CharSequence var1, @NotNull CharSequence var2);

    @Override
    @NotNull
    public String getTextValue() {
        String text = this.getText();
        StringBuilder builder = new StringBuilder();
        CharSequence prevString = null;
        boolean isFirst = true;
        for (TextRange range : this.getContentRanges()) {
            CharSequence curString = range.subSequence((CharSequence)text);
            if (!isFirst) {
                builder.append(this.getRangesJoiner(prevString, curString));
            } else {
                isFirst = false;
            }
            builder.append(curString);
            prevString = curString;
        }
        String string = builder.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/psi/impl/YAMLScalarImpl", "getTextValue"));
        }
        return string;
    }

    public PsiReference getReference() {
        PsiReference[] references = this.getReferences();
        return references.length == 1 ? references[0] : null;
    }

    @NotNull
    public PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray = ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)this);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/psi/impl/YAMLScalarImpl", "getReferences"));
        }
        return psiReferenceArray;
    }
}

