/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.parser;

import com.intellij.lang.ASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.Stack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLElementType;
import org.jetbrains.yaml.YAMLElementTypes;
import org.jetbrains.yaml.YAMLTokenTypes;

public class YAMLParser
implements PsiParser,
YAMLTokenTypes {
    public static final TokenSet HASH_STOP_TOKENS = TokenSet.create((IElementType[])new IElementType[]{RBRACE, COMMA});
    public static final TokenSet ARRAY_STOP_TOKENS = TokenSet.create((IElementType[])new IElementType[]{RBRACKET, COMMA});
    private PsiBuilder myBuilder;
    private boolean eolSeen = false;
    private int myIndent;
    private PsiBuilder.Marker myAfterLastEolMarker;
    private final Stack<TokenSet> myStopTokensStack = new Stack();

    @NotNull
    public ASTNode parse(@NotNull IElementType root, @NotNull PsiBuilder builder) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/yaml/parser/YAMLParser", "parse"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/yaml/parser/YAMLParser", "parse"));
        }
        this.myBuilder = builder;
        this.myStopTokensStack.clear();
        PsiBuilder.Marker fileMarker = this.mark();
        this.parseFile();
        assert (this.myBuilder.eof()) : "Not all tokens were passed.";
        fileMarker.done(root);
        ASTNode aSTNode = builder.getTreeBuilt();
        if (aSTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/parser/YAMLParser", "parse"));
        }
        return aSTNode;
    }

    private void parseFile() {
        this.passJunk();
        this.parseDocument();
        this.passJunk();
        while (!this.myBuilder.eof()) {
            this.parseDocument();
            this.passJunk();
        }
        this.dropEolMarker();
    }

    private void parseDocument() {
        PsiBuilder.Marker marker = this.mark();
        if (this.myBuilder.getTokenType() == DOCUMENT_MARKER) {
            this.advanceLexer();
        }
        this.parseBlockNode(0, false);
        this.dropEolMarker();
        marker.done((IElementType)YAMLElementTypes.DOCUMENT);
    }

    private void parseBlockNode(int indent, boolean insideSequence) {
        this.passJunk();
        PsiBuilder.Marker marker = this.mark();
        PsiBuilder.Marker endOfNodeMarker = null;
        YAMLElementType nodeType = null;
        if (this.getTokenType() == YAMLTokenTypes.TAG && this.myBuilder.lookAhead(1) == YAMLTokenTypes.EOL) {
            this.advanceLexer();
        }
        int numberOfItems = 0;
        while (!(this.eof() || !this.isJunk() && this.eolSeen && this.myIndent + this.getIndentBonus(insideSequence) < indent)) {
            if (this.isJunk()) {
                this.advanceLexer();
                continue;
            }
            if (!this.myStopTokensStack.isEmpty() && ((TokenSet)this.myStopTokensStack.peek()).contains(this.getTokenType())) {
                this.rollBackToEol();
                break;
            }
            ++numberOfItems;
            IElementType parsedTokenType = this.parseSingleStatement(this.eolSeen ? this.myIndent : indent);
            if (nodeType == null) {
                if (parsedTokenType == YAMLElementTypes.SEQUENCE_ITEM) {
                    nodeType = YAMLElementTypes.SEQUENCE;
                } else if (parsedTokenType == YAMLElementTypes.KEY_VALUE_PAIR) {
                    nodeType = YAMLElementTypes.MAPPING;
                } else if (numberOfItems > 1) {
                    nodeType = YAMLElementTypes.COMPOUND_VALUE;
                }
            }
            if (endOfNodeMarker != null) {
                endOfNodeMarker.drop();
            }
            endOfNodeMarker = this.mark();
        }
        if (endOfNodeMarker != null) {
            this.dropEolMarker();
            endOfNodeMarker.rollbackTo();
        } else {
            this.rollBackToEol();
        }
        if (nodeType != null) {
            marker.done(nodeType);
        } else {
            marker.drop();
        }
    }

    private int getIndentBonus(boolean insideSequence) {
        if (!insideSequence && this.getTokenType() == SEQUENCE_MARKER) {
            return 1;
        }
        return 0;
    }

    private int getShorthandIndentAddition() {
        int offset = this.myBuilder.getCurrentOffset();
        IElementType nextToken = this.myBuilder.lookAhead(1);
        if (nextToken != SEQUENCE_MARKER && nextToken != SCALAR_KEY) {
            return 1;
        }
        if (this.myBuilder.rawLookup(1) == WHITESPACE) {
            return this.myBuilder.rawTokenTypeStart(2) - offset;
        }
        return 1;
    }

    @Nullable
    private IElementType parseSingleStatement(int indent) {
        IElementType nodeType;
        IElementType tokenType;
        if (this.eof()) {
            return null;
        }
        PsiBuilder.Marker marker = this.mark();
        if (this.getTokenType() == YAMLTokenTypes.TAG) {
            this.advanceLexer();
        }
        if ((tokenType = this.getTokenType()) == LBRACE) {
            nodeType = this.parseHash();
        } else if (tokenType == LBRACKET) {
            nodeType = this.parseArray();
        } else if (tokenType == SEQUENCE_MARKER) {
            nodeType = this.parseSequenceItem(indent);
        } else if (tokenType == QUESTION) {
            nodeType = this.parseExplicitKeyValue(indent);
        } else if (tokenType == SCALAR_KEY) {
            nodeType = this.parseScalarKeyValue(indent);
        } else if (YAMLElementTypes.SCALAR_VALUES.contains(this.getTokenType())) {
            nodeType = this.parseScalarValue(indent);
        } else {
            this.advanceLexer();
            nodeType = null;
        }
        if (nodeType != null) {
            marker.done(nodeType);
        } else {
            marker.drop();
        }
        return nodeType;
    }

    @Nullable
    private IElementType parseScalarValue(int indent) {
        IElementType tokenType = this.getTokenType();
        assert (YAMLElementTypes.SCALAR_VALUES.contains(tokenType)) : "Scalar value expected!";
        if (tokenType == SCALAR_LIST || tokenType == SCALAR_TEXT) {
            return this.parseMultiLineScalar(tokenType);
        }
        if (tokenType == TEXT) {
            return this.parseMultiLinePlainScalar(indent);
        }
        if (tokenType == SCALAR_DSTRING || tokenType == SCALAR_STRING) {
            return this.parseQuotedString();
        }
        this.advanceLexer();
        return null;
    }

    @NotNull
    private IElementType parseQuotedString() {
        this.advanceLexer();
        YAMLElementType yAMLElementType = YAMLElementTypes.SCALAR_QUOTED_STRING;
        if (yAMLElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/parser/YAMLParser", "parseQuotedString"));
        }
        return yAMLElementType;
    }

    @NotNull
    private IElementType parseMultiLineScalar(IElementType tokenType) {
        IElementType type = this.getTokenType();
        while (type == tokenType || type == INDENT || type == EOL) {
            this.advanceLexer();
            type = this.getTokenType();
        }
        this.rollBackToEol();
        YAMLElementType yAMLElementType = tokenType == SCALAR_LIST ? YAMLElementTypes.SCALAR_LIST_VALUE : YAMLElementTypes.SCALAR_TEXT_VALUE;
        if (yAMLElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/parser/YAMLParser", "parseMultiLineScalar"));
        }
        return yAMLElementType;
    }

    @NotNull
    private IElementType parseMultiLinePlainScalar(int indent) {
        PsiBuilder.Marker lastTextEnd = null;
        IElementType type = this.getTokenType();
        while (type == TEXT || type == INDENT || type == EOL) {
            this.advanceLexer();
            if (type == TEXT) {
                if (lastTextEnd != null && this.myIndent < indent) break;
                if (lastTextEnd != null) {
                    lastTextEnd.drop();
                }
                lastTextEnd = this.mark();
            }
            type = this.getTokenType();
        }
        this.rollBackToEol();
        assert (lastTextEnd != null);
        lastTextEnd.rollbackTo();
        YAMLElementType yAMLElementType = YAMLElementTypes.SCALAR_PLAIN_VALUE;
        if (yAMLElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/parser/YAMLParser", "parseMultiLinePlainScalar"));
        }
        return yAMLElementType;
    }

    @NotNull
    private IElementType parseExplicitKeyValue(int indent) {
        assert (this.getTokenType() == QUESTION);
        int indentAddition = this.getShorthandIndentAddition();
        this.advanceLexer();
        if (!this.myStopTokensStack.isEmpty() && this.myStopTokensStack.peek() == HASH_STOP_TOKENS && this.getTokenType() == SCALAR_KEY) {
            this.parseScalarKeyValue(indent);
        } else {
            this.myStopTokensStack.add((Object)TokenSet.create((IElementType[])new IElementType[]{COLON}));
            this.eolSeen = false;
            this.passJunk();
            this.parseBlockNode(indent + indentAddition, false);
            this.myStopTokensStack.pop();
            this.passJunk();
            if (this.getTokenType() == COLON) {
                indentAddition = this.getShorthandIndentAddition();
                this.advanceLexer();
                this.eolSeen = false;
                this.parseBlockNode(indent + indentAddition, false);
            }
        }
        YAMLElementType yAMLElementType = YAMLElementTypes.KEY_VALUE_PAIR;
        if (yAMLElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/parser/YAMLParser", "parseExplicitKeyValue"));
        }
        return yAMLElementType;
    }

    @NotNull
    private IElementType parseScalarKeyValue(int indent) {
        assert (this.getTokenType() == SCALAR_KEY) : "Expected scalar key";
        this.eolSeen = false;
        int indentAddition = this.getShorthandIndentAddition();
        this.advanceLexer();
        PsiBuilder.Marker rollbackMarker = this.mark();
        this.passJunk();
        if (this.eolSeen && (this.eof() || this.myIndent + this.getIndentBonus(false) < indent + indentAddition)) {
            this.dropEolMarker();
            rollbackMarker.rollbackTo();
        } else {
            rollbackMarker.drop();
            this.parseBlockNode(indent + indentAddition, false);
        }
        YAMLElementType yAMLElementType = YAMLElementTypes.KEY_VALUE_PAIR;
        if (yAMLElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/parser/YAMLParser", "parseScalarKeyValue"));
        }
        return yAMLElementType;
    }

    @NotNull
    private IElementType parseSequenceItem(int indent) {
        assert (this.getTokenType() == SEQUENCE_MARKER);
        int indentAddition = this.getShorthandIndentAddition();
        this.advanceLexer();
        this.eolSeen = false;
        this.passJunk();
        this.parseBlockNode(indent + indentAddition, true);
        this.rollBackToEol();
        YAMLElementType yAMLElementType = YAMLElementTypes.SEQUENCE_ITEM;
        if (yAMLElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/parser/YAMLParser", "parseSequenceItem"));
        }
        return yAMLElementType;
    }

    @NotNull
    private IElementType parseHash() {
        assert (this.getTokenType() == LBRACE);
        this.advanceLexer();
        this.myStopTokensStack.add((Object)HASH_STOP_TOKENS);
        while (!this.eof()) {
            if (this.getTokenType() == RBRACE) {
                this.advanceLexer();
                break;
            }
            this.parseSingleStatement(0);
        }
        this.myStopTokensStack.pop();
        this.dropEolMarker();
        YAMLElementType yAMLElementType = YAMLElementTypes.HASH;
        if (yAMLElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/parser/YAMLParser", "parseHash"));
        }
        return yAMLElementType;
    }

    @NotNull
    private IElementType parseArray() {
        assert (this.getTokenType() == LBRACKET);
        this.advanceLexer();
        this.myStopTokensStack.add((Object)ARRAY_STOP_TOKENS);
        while (!this.eof()) {
            if (this.getTokenType() == RBRACKET) {
                this.advanceLexer();
                break;
            }
            if (this.isJunk()) {
                this.advanceLexer();
                continue;
            }
            PsiBuilder.Marker marker = this.mark();
            IElementType parsedElement = this.parseSingleStatement(0);
            if (parsedElement != null) {
                marker.done((IElementType)YAMLElementTypes.SEQUENCE_ITEM);
            } else {
                marker.error("Sequence item expected");
            }
            if (this.getTokenType() != YAMLTokenTypes.COMMA) continue;
            this.advanceLexer();
        }
        this.myStopTokensStack.pop();
        this.dropEolMarker();
        YAMLElementType yAMLElementType = YAMLElementTypes.ARRAY;
        if (yAMLElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/parser/YAMLParser", "parseArray"));
        }
        return yAMLElementType;
    }

    private boolean eof() {
        return this.myBuilder.eof() || this.myBuilder.getTokenType() == DOCUMENT_MARKER;
    }

    @Nullable
    private IElementType getTokenType() {
        return this.eof() ? null : this.myBuilder.getTokenType();
    }

    private void dropEolMarker() {
        if (this.myAfterLastEolMarker != null) {
            this.myAfterLastEolMarker.drop();
            this.myAfterLastEolMarker = null;
        }
    }

    private void rollBackToEol() {
        if (this.eolSeen && this.myAfterLastEolMarker != null) {
            this.eolSeen = false;
            this.myAfterLastEolMarker.rollbackTo();
            this.myAfterLastEolMarker = null;
        }
    }

    private PsiBuilder.Marker mark() {
        this.dropEolMarker();
        return this.myBuilder.mark();
    }

    private void advanceLexer() {
        if (this.myBuilder.eof()) {
            return;
        }
        IElementType type = this.myBuilder.getTokenType();
        boolean bl = this.eolSeen = this.eolSeen || type == EOL;
        if (type == EOL) {
            this.myAfterLastEolMarker = this.mark();
            this.myIndent = 0;
        } else if (type == INDENT) {
            this.myIndent = this.getCurrentTokenLength();
        } else {
            this.dropEolMarker();
        }
        this.myBuilder.advanceLexer();
    }

    private int getCurrentTokenLength() {
        return this.myBuilder.rawTokenTypeStart(1) - this.myBuilder.getCurrentOffset();
    }

    private void passJunk() {
        while (!this.eof() && this.isJunk()) {
            this.advanceLexer();
        }
    }

    private boolean isJunk() {
        IElementType type = this.getTokenType();
        return type == INDENT || type == EOL;
    }
}

