/*
 * Decompiled with CFR 0.152.
 */
package com.pty4j.windows;

import com.pty4j.windows.NamedPipe;
import java.io.IOException;
import java.io.OutputStream;

public class WinPTYOutputStream
extends OutputStream {
    private final NamedPipe myNamedPipe;
    private boolean myClosed;
    private final boolean myPatchNewline;
    private final boolean mySendEOFInsteadClose;

    public WinPTYOutputStream(NamedPipe namedPipe) {
        this(namedPipe, false, false);
    }

    public WinPTYOutputStream(NamedPipe namedPipe, boolean patchNewline, boolean sendEOFInsteadClose) {
        this.myNamedPipe = namedPipe;
        this.myPatchNewline = patchNewline;
        this.mySendEOFInsteadClose = sendEOFInsteadClose;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.myClosed) {
            return;
        }
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        if (this.myPatchNewline) {
            byte[] newBuf = new byte[len * 2];
            int newPos = 0;
            for (int i = off; i < off + len; ++i) {
                if (b[i] == 10) {
                    newBuf[newPos++] = 13;
                }
                newBuf[newPos++] = b[i];
            }
            b = newBuf;
            off = 0;
            len = newPos;
        }
        this.myNamedPipe.write(b, off, len);
    }

    public void write(int b) throws IOException {
        byte[] buf = new byte[]{(byte)b};
        this.write(buf, 0, 1);
    }

    public void close() throws IOException {
        if (this.mySendEOFInsteadClose) {
            this.write(new byte[]{94, 90, 10});
        } else {
            this.myClosed = true;
            this.myNamedPipe.close();
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }
}

