/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.command;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.execution.HgCommandExecutor;
import org.zmlx.hg4idea.execution.HgCommandResult;

public class HgShowConfigCommand {
    @NotNull
    private final Project project;

    public HgShowConfigCommand(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/command/HgShowConfigCommand", "<init>"));
        }
        this.project = project;
    }

    @NotNull
    public Map<String, Map<String, String>> execute(@Nullable VirtualFile repo) {
        if (repo == null) {
            Map<String, Map<String, String>> map = Collections.emptyMap();
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/command/HgShowConfigCommand", "execute"));
            }
            return map;
        }
        HgCommandExecutor executor = new HgCommandExecutor(this.project);
        executor.setSilent(true);
        HgCommandResult result = executor.executeInCurrentThread(repo, "showconfig", Arrays.asList("--config", "ui.debug=false"));
        if (result == null) {
            Map<String, Map<String, String>> map = Collections.emptyMap();
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/command/HgShowConfigCommand", "execute"));
            }
            return map;
        }
        HashMap<String, Map<String, String>> configMap = new HashMap<String, Map<String, String>>();
        for (String line : result.getOutputLines()) {
            List option = StringUtil.split((String)line, (String)"=", (boolean)true, (boolean)false);
            if (option.size() != 2) continue;
            String sectionAndName = ((String)option.get(0)).trim();
            String value = ((String)option.get(1)).trim();
            int dotIndex = sectionAndName.indexOf(46);
            if (dotIndex <= 0) continue;
            String sectionName = sectionAndName.substring(0, dotIndex);
            String optionName = sectionAndName.substring(dotIndex + 1, sectionAndName.length());
            if (configMap.containsKey(sectionName)) {
                ((Map)configMap.get(sectionName)).put(optionName, value);
                continue;
            }
            HashMap<String, String> sectionMap = new HashMap<String, String>();
            sectionMap.put(optionName, value);
            configMap.put(sectionName, sectionMap);
        }
        HashMap<String, Map<String, String>> hashMap = configMap;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/command/HgShowConfigCommand", "execute"));
        }
        return hashMap;
    }
}

