/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils;

import com.intellij.openapi.diagnostic.Logger;
import java.io.PrintStream;
import org.apache.log4j.Level;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PrintingLogger
extends Logger {
    public static final Logger SYSTEM_OUT = new PrintingLogger(System.out);
    public static final Logger SYSTEM_ERR = new PrintingLogger(System.err);
    private final PrintStream out;

    public PrintingLogger(@NotNull PrintStream out) {
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "org/jetbrains/kotlin/utils/PrintingLogger", "<init>"));
        }
        this.out = out;
    }

    public boolean isDebugEnabled() {
        return true;
    }

    public void debug(@NonNls String message2) {
        this.out.println(message2);
    }

    public void debug(@Nullable Throwable t) {
        t.printStackTrace(this.out);
    }

    public void debug(@NonNls String message2, @Nullable Throwable t) {
        this.debug(message2);
        this.debug(t);
    }

    public void info(@NonNls String message2) {
        this.debug(message2);
    }

    public void info(@NonNls String message2, @Nullable Throwable t) {
        this.debug(message2, t);
    }

    public void warn(@NonNls String message2, @Nullable Throwable t) {
        this.debug(message2, t);
    }

    public void error(@NonNls String message2, @Nullable Throwable t, String ... details) {
        if (details == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "details", "org/jetbrains/kotlin/utils/PrintingLogger", "error"));
        }
        this.debug(message2, t);
        for (String detail : details) {
            this.debug(detail);
        }
    }

    public void setLevel(Level level) {
    }
}

