/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0010\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B'\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0000J\u0006\u0010\u0011\u001a\u00020\u0000J\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0000J\b\u0010\u0014\u001a\u00020\u0003H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/types/Variance;", "", "label", "", "allowsInPosition", "", "allowsOutPosition", "superpositionFactor", "", "(Ljava/lang/String;ILjava/lang/String;ZZI)V", "getAllowsInPosition", "()Z", "getAllowsOutPosition", "getLabel", "()Ljava/lang/String;", "allowsPosition", "position", "opposite", "superpose", "other", "toString", "INVARIANT", "IN_VARIANCE", "OUT_VARIANCE", "descriptors"})
public final class Variance
extends Enum<Variance> {
    public static final /* enum */ Variance INVARIANT;
    public static final /* enum */ Variance IN_VARIANCE;
    public static final /* enum */ Variance OUT_VARIANCE;
    private static final /* synthetic */ Variance[] $VALUES;
    @NotNull
    private final String label;
    private final boolean allowsInPosition;
    private final boolean allowsOutPosition;
    private final int superpositionFactor;

    static {
        Variance[] varianceArray = new Variance[3];
        Variance[] varianceArray2 = varianceArray;
        varianceArray[0] = INVARIANT = new Variance("", true, true, 0);
        varianceArray[1] = IN_VARIANCE = new Variance("in", true, false, -1);
        varianceArray[2] = OUT_VARIANCE = new Variance("out", false, true, 1);
        $VALUES = varianceArray;
    }

    public final boolean allowsPosition(@NotNull Variance position) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)((Object)position), (String)"position");
        Variance variance = position;
        if (Intrinsics.areEqual((Object)((Object)variance), (Object)((Object)IN_VARIANCE))) {
            bl = this.allowsInPosition;
        } else if (Intrinsics.areEqual((Object)((Object)variance), (Object)((Object)OUT_VARIANCE))) {
            bl = this.allowsOutPosition;
        } else if (Intrinsics.areEqual((Object)((Object)variance), (Object)((Object)INVARIANT))) {
            bl = this.allowsInPosition && this.allowsOutPosition;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    @NotNull
    public final Variance superpose(@NotNull Variance other) {
        Variance variance;
        Intrinsics.checkParameterIsNotNull((Object)((Object)other), (String)"other");
        int r = this.superpositionFactor * other.superpositionFactor;
        switch (r) {
            case 0: {
                variance = INVARIANT;
                break;
            }
            case -1: {
                variance = IN_VARIANCE;
                break;
            }
            case 1: {
                variance = OUT_VARIANCE;
                break;
            }
            default: {
                throw (Throwable)new IllegalStateException("Illegal factor: " + r);
            }
        }
        return variance;
    }

    @NotNull
    public final Variance opposite() {
        Variance variance;
        Variance variance2 = this;
        if (Intrinsics.areEqual((Object)((Object)variance2), (Object)((Object)INVARIANT))) {
            variance = INVARIANT;
        } else if (Intrinsics.areEqual((Object)((Object)variance2), (Object)((Object)IN_VARIANCE))) {
            variance = OUT_VARIANCE;
        } else if (Intrinsics.areEqual((Object)((Object)variance2), (Object)((Object)OUT_VARIANCE))) {
            variance = IN_VARIANCE;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return variance;
    }

    @NotNull
    public String toString() {
        return this.label;
    }

    @NotNull
    public final String getLabel() {
        return this.label;
    }

    public final boolean getAllowsInPosition() {
        return this.allowsInPosition;
    }

    public final boolean getAllowsOutPosition() {
        return this.allowsOutPosition;
    }

    protected Variance(String label, boolean allowsInPosition, boolean allowsOutPosition, int superpositionFactor) {
        Intrinsics.checkParameterIsNotNull((Object)label, (String)"label");
        this.label = label;
        this.allowsInPosition = allowsInPosition;
        this.allowsOutPosition = allowsOutPosition;
        this.superpositionFactor = superpositionFactor;
    }

    public static Variance[] values() {
        return (Variance[])$VALUES.clone();
    }

    public static Variance valueOf(String string) {
        return Enum.valueOf(Variance.class, string);
    }
}

