/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization.js;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.serialization.js.KotlinJavascriptSerializationUtil;
import org.jetbrains.kotlin.serialization.js.KotlinJavascriptSerializedResourcePaths;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\u001a\u0010\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002\u001a\u0010\u0010\t\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u0007H\u0002\u001a\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u0001H\u0002\u001a\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u0001\u001a\u000e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u0001\u001a\u000e\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u0001\u001a\u000e\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u0001\u001a\n\u0010\u0013\u001a\u00020\u000f*\u00020\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"DEFAULT_PACKAGE_CLASS_NAME", "", "DEFAULT_PACKAGE_METAFILE_NAME", "PACKAGE_CLASS_NAME_SUFFIX", "capitalizeNonEmptyString", "s", "getPackageClassFqName", "Lorg/jetbrains/kotlin/name/FqName;", "packageFQN", "getPackageClassName", "getPackageFqName", "fileName", "getPackageName", "filePath", "isClassesInPackageFile", "", "isDefaultPackageMetafile", "isPackageMetadataFile", "isStringTableFile", "isPackageClassFqName", "js.serializer"})
public final class KotlinJavascriptSerializedResourcePathsKt {
    private static final String PACKAGE_CLASS_NAME_SUFFIX = "Package";
    private static final String DEFAULT_PACKAGE_CLASS_NAME = "_DefaultPackage";
    private static final String DEFAULT_PACKAGE_METAFILE_NAME = "_DefaultPackage.kjsm";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isPackageClassFqName(FqName $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if ($receiver.isRoot()) return false;
        FqName fqName2 = $receiver.parent();
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"this.parent()");
        if (!Intrinsics.areEqual((Object)KotlinJavascriptSerializedResourcePathsKt.getPackageClassFqName(fqName2), (Object)$receiver)) return false;
        return true;
    }

    public static final boolean isDefaultPackageMetafile(@NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        return Intrinsics.areEqual((Object)fileName, (Object)DEFAULT_PACKAGE_METAFILE_NAME);
    }

    public static final boolean isPackageMetadataFile(@NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        return Intrinsics.areEqual((Object)KotlinJavascriptSerializedResourcePaths.INSTANCE.getPackageFilePath(KotlinJavascriptSerializedResourcePathsKt.getPackageFqName(fileName)), (Object)fileName);
    }

    public static final boolean isStringTableFile(@NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        return Intrinsics.areEqual((Object)KotlinJavascriptSerializedResourcePaths.INSTANCE.getStringTableFilePath(KotlinJavascriptSerializedResourcePathsKt.getPackageFqName(fileName)), (Object)fileName);
    }

    public static final boolean isClassesInPackageFile(@NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        return Intrinsics.areEqual((Object)KotlinJavascriptSerializedResourcePaths.INSTANCE.getClassesInPackageFilePath(KotlinJavascriptSerializedResourcePathsKt.getPackageFqName(fileName)), (Object)fileName);
    }

    private static final FqName getPackageFqName(String fileName) {
        return new FqName(KotlinJavascriptSerializedResourcePathsKt.getPackageName(fileName));
    }

    private static final String getPackageName(String filePath) {
        return StringsKt.indexOf$default((CharSequence)filePath, (char)'/', (int)0, (boolean)false, (int)6, null) >= 0 ? StringsKt.replace$default((String)StringsKt.substringBeforeLast$default((String)filePath, (char)'/', null, (int)2, null), (char)'/', (char)'.', (boolean)false, (int)4, null) : "";
    }

    private static final FqName getPackageClassFqName(FqName packageFQN) {
        FqName fqName2 = packageFQN.child(Name.identifier(KotlinJavascriptSerializedResourcePathsKt.getPackageClassName(packageFQN)));
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"packageFQN.child(Name.id\u2026geClassName(packageFQN)))");
        return fqName2;
    }

    private static final String getPackageClassName(FqName packageFQN) {
        String string;
        if (packageFQN.isRoot()) {
            string = DEFAULT_PACKAGE_CLASS_NAME;
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = packageFQN.shortName().asString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"packageFQN.shortName().asString()");
            string = stringBuilder.append(KotlinJavascriptSerializedResourcePathsKt.capitalizeNonEmptyString(string2)).append(PACKAGE_CLASS_NAME_SUFFIX).toString();
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private static final String capitalizeNonEmptyString(String s) {
        String string;
        char $receiver$iv = s.charAt(0);
        if (Character.isUpperCase($receiver$iv)) {
            string = s;
        } else {
            void $receiver$iv2;
            $receiver$iv = s.charAt(0);
            $receiver$iv = Character.toUpperCase($receiver$iv);
            String $i$f$toUpperCase = s;
            int startIndex$iv = 1;
            void v1 = $receiver$iv2;
            if (v1 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string2 = ((String)v1).substring(startIndex$iv);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
            String other$iv = string2;
            string = String.valueOf($receiver$iv) + other$iv;
        }
        return string;
    }

    static {
        PACKAGE_CLASS_NAME_SUFFIX = PACKAGE_CLASS_NAME_SUFFIX;
        DEFAULT_PACKAGE_CLASS_NAME = "_Default" + PACKAGE_CLASS_NAME_SUFFIX;
        DEFAULT_PACKAGE_METAFILE_NAME = DEFAULT_PACKAGE_CLASS_NAME + "." + KotlinJavascriptSerializationUtil.INSTANCE.getCLASS_METADATA_FILE_EXTENSION();
    }

    @NotNull
    public static final /* synthetic */ FqName access$getPackageClassFqName(@NotNull FqName packageFQN) {
        return KotlinJavascriptSerializedResourcePathsKt.getPackageClassFqName(packageFQN);
    }
}

