/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters1;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeInsight.DescriptorToSourceUtilsIde;
import org.jetbrains.kotlin.idea.core.KotlinNameSuggester;
import org.jetbrains.kotlin.idea.core.UtilsKt;
import org.jetbrains.kotlin.idea.quickfix.AddFunctionParametersFix;
import org.jetbrains.kotlin.idea.quickfix.ChangeFunctionSignatureFix;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactoryWithDelegate;
import org.jetbrains.kotlin.idea.refactoring.JetRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinChangeSignatureConfiguration;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinChangeSignatureKt;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinMethodDescriptor;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinMutableMethodDescriptor;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.ValueArgumentName;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u001b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001bB\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016J$\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00120\u0011H\u0004J\"\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0012H\u0016R\u0014\u0010\u0003\u001a\u00020\u0002X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeFunctionSignatureFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lcom/intellij/psi/PsiElement;", "context", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "(Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;)V", "getContext", "()Lcom/intellij/psi/PsiElement;", "getFunctionDescriptor", "()Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "getFamilyName", "", "getNewArgumentName", "argument", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "validator", "Lkotlin/Function1;", "", "isAvailable", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "startInWriteAction", "Companion", "idea"})
public abstract class ChangeFunctionSignatureFix
extends KotlinQuickFixAction<PsiElement> {
    @NotNull
    private final PsiElement context;
    @NotNull
    private final FunctionDescriptor functionDescriptor;
    @NotNull
    private static final String FAMILY_NAME = "Change signature of function/constructor";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getFamilyName() {
        return Companion.getFAMILY_NAME();
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile file) {
        boolean bl;
        Iterable $receiver$iv;
        Collection<PsiElement> declarations2;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        if (!super.isAvailable(project, editor, file)) {
            return false;
        }
        Collection<PsiElement> collection = declarations2 = DescriptorToSourceUtilsIde.INSTANCE.getAllDeclarations(project, this.functionDescriptor);
        if ($receiver$iv.isEmpty()) return false;
        boolean bl2 = true;
        if (!bl2) return false;
        $receiver$iv = declarations2;
        Iterator iterator2 = $receiver$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
            Object element$iv = iterator2.next();
            PsiElement it = (PsiElement)element$iv;
            if (!it.isValid()) return false;
            if (!JetRefactoringUtilKt.canRefactor(it)) return false;
            bl = true;
        } while (bl);
        return false;
    }

    @NotNull
    protected final String getNewArgumentName(@NotNull ValueArgument argument2, @NotNull Function1<? super String, Boolean> validator2) {
        Intrinsics.checkParameterIsNotNull((Object)argument2, (String)"argument");
        Intrinsics.checkParameterIsNotNull(validator2, (String)"validator");
        ValueArgumentName argumentName2 = argument2.getArgumentName();
        KtExpression expression2 = argument2.getArgumentExpression();
        if (argumentName2 != null) {
            String string = argumentName2.getAsName().asString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"argumentName.asName.asString()");
            return KotlinNameSuggester.INSTANCE.suggestNameByName(string, validator2);
        }
        if (expression2 != null) {
            BindingContext bindingContext2 = ResolutionUtils.analyze(expression2, BodyResolveMode.PARTIAL);
            return (String)CollectionsKt.first((Iterable)KotlinNameSuggester.INSTANCE.suggestNamesByExpressionAndType(expression2, null, bindingContext2, validator2, "param"));
        }
        return KotlinNameSuggester.INSTANCE.suggestNameByName("param", validator2);
    }

    @NotNull
    protected final PsiElement getContext() {
        return this.context;
    }

    @NotNull
    protected final FunctionDescriptor getFunctionDescriptor() {
        return this.functionDescriptor;
    }

    public ChangeFunctionSignatureFix(@NotNull PsiElement context, @NotNull FunctionDescriptor functionDescriptor) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)functionDescriptor, (String)"functionDescriptor");
        super(context);
        this.context = context;
        this.functionDescriptor = functionDescriptor;
    }

    static {
        FAMILY_NAME = FAMILY_NAME;
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0018B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0003H\u0014J\u001a\u0010\r\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017R\u0014\u0010\u0005\u001a\u00020\u0006X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeFunctionSignatureFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactoryWithDelegate;", "Lorg/jetbrains/kotlin/psi/KtCallElement;", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "()V", "FAMILY_NAME", "", "getFAMILY_NAME", "()Ljava/lang/String;", "createFix", "Lorg/jetbrains/kotlin/idea/quickfix/ChangeFunctionSignatureFix;", "originalElement", "data", "extractFixData", "element", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "getElementOfInterest", "runRemoveParameter", "", "parameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "context", "Lcom/intellij/psi/PsiElement;", "RemoveParameterFix", "idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactoryWithDelegate<KtCallElement, CallableDescriptor> {
        @Override
        @Nullable
        protected KtCallElement getElementOfInterest(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            PsiElement $receiver$iv = diagnostic.getPsiElement();
            return (KtCallElement)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtCallElement.class, (boolean)false);
        }

        @Override
        @Nullable
        protected CallableDescriptor extractFixData(@NotNull KtCallElement element2, @NotNull Diagnostic diagnostic) {
            Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            return (CallableDescriptor)((DiagnosticWithParameters1)DiagnosticFactory.cast(diagnostic, Errors.TOO_MANY_ARGUMENTS, Errors.NO_VALUE_FOR_PARAMETER)).getA();
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        protected ChangeFunctionSignatureFix createFix(@NotNull KtCallElement originalElement, @NotNull CallableDescriptor data) {
            FunctionDescriptor functionDescriptor;
            Intrinsics.checkParameterIsNotNull((Object)originalElement, (String)"originalElement");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            CallableDescriptor callableDescriptor = data;
            if (!(callableDescriptor instanceof FunctionDescriptor)) {
                callableDescriptor = null;
            }
            if ((functionDescriptor = (FunctionDescriptor)callableDescriptor) == null) {
                CallableDescriptor callableDescriptor2 = data;
                if (!(callableDescriptor2 instanceof ValueParameterDescriptor)) {
                    callableDescriptor2 = null;
                }
                ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)callableDescriptor2;
                CallableDescriptor callableDescriptor3 = valueParameterDescriptor != null ? valueParameterDescriptor.getContainingDeclaration() : null;
                if (!(callableDescriptor3 instanceof FunctionDescriptor)) {
                    callableDescriptor3 = null;
                }
                functionDescriptor = (FunctionDescriptor)callableDescriptor3;
            }
            if (functionDescriptor == null) {
                return null;
            }
            FunctionDescriptor functionDescriptor2 = functionDescriptor;
            if (Intrinsics.areEqual((Object)((Object)functionDescriptor2.getKind()), (Object)((Object)CallableMemberDescriptor.Kind.SYNTHESIZED))) {
                return null;
            }
            if (data instanceof ValueParameterDescriptor) {
                return new RemoveParameterFix((PsiElement)originalElement, functionDescriptor2, (ValueParameterDescriptor)data);
            }
            List<ValueParameterDescriptor> parameters2 = functionDescriptor2.getValueParameters();
            List<? extends ValueArgument> arguments2 = originalElement.getValueArguments();
            if (arguments2.size() > parameters2.size()) {
                boolean bl;
                block12: {
                    void $receiver$iv$iv;
                    void $receiver$iv;
                    Map<ValueArgument, ValueParameterDescriptor> argumentToParameter;
                    BindingContext bindingContext2 = ResolutionUtils.analyze$default(originalElement, null, 1, null);
                    Call call = CallUtilKt.getCall(originalElement, bindingContext2);
                    if (call == null) {
                        return null;
                    }
                    Call call2 = call;
                    Map<ValueArgument, ValueParameterDescriptor> map2 = argumentToParameter = UtilsKt.mapArgumentsToParameters(call2, functionDescriptor2);
                    void var11_10 = $receiver$iv;
                    Iterator iterator2 = $receiver$iv$iv.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        void parameter;
                        KotlinType argumentType;
                        KotlinType kotlinType;
                        void argument2;
                        Object $receiver$iv2;
                        Map.Entry element$iv;
                        Map.Entry it;
                        Map.Entry entry;
                        Map.Entry entry2 = entry = (it = (element$iv = iterator2.next()));
                        ValueArgument valueArgument = (ValueArgument)$receiver$iv2.getKey();
                        $receiver$iv2 = entry;
                        ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)$receiver$iv2.getValue();
                        entry = null;
                        KtExpression ktExpression = argument2.getArgumentExpression();
                        if (ktExpression != null) {
                            $receiver$iv2 = ktExpression;
                            KtExpression it2 = (KtExpression)$receiver$iv2;
                            kotlinType = bindingContext2.getType(it2);
                        } else {
                            kotlinType = null;
                        }
                        if (!((argumentType = kotlinType) == null || !KotlinTypeChecker.DEFAULT.isSubtypeOf(argumentType, parameter.getType()))) continue;
                        bl = true;
                        break block12;
                    }
                    bl = false;
                }
                boolean hasTypeMismatches = bl;
                return new AddFunctionParametersFix(originalElement, functionDescriptor2, hasTypeMismatches);
            }
            return null;
        }

        @NotNull
        public final String getFAMILY_NAME() {
            return FAMILY_NAME;
        }

        public final void runRemoveParameter(@NotNull ValueParameterDescriptor parameterDescriptor, @NotNull PsiElement context) {
            Intrinsics.checkParameterIsNotNull((Object)parameterDescriptor, (String)"parameterDescriptor");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            CallableDescriptor callableDescriptor = parameterDescriptor.getContainingDeclaration();
            if (callableDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.FunctionDescriptor");
            }
            FunctionDescriptor functionDescriptor = (FunctionDescriptor)callableDescriptor;
            Project project = context.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"context.project");
            KotlinChangeSignatureKt.runChangeSignature(project, functionDescriptor, new KotlinChangeSignatureConfiguration(parameterDescriptor){
                final /* synthetic */ ValueParameterDescriptor $parameterDescriptor;

                @NotNull
                public KotlinMethodDescriptor configure(@NotNull KotlinMethodDescriptor originalDescriptor) {
                    Intrinsics.checkParameterIsNotNull((Object)originalDescriptor, (String)"originalDescriptor");
                    return KotlinChangeSignatureKt.modify(originalDescriptor, (Function1<? super KotlinMutableMethodDescriptor, Unit>)((Function1)new Function1<KotlinMutableMethodDescriptor, Unit>(this){
                        final /* synthetic */ runRemoveParameter.1 this$0;

                        public final void invoke(@NotNull KotlinMutableMethodDescriptor descriptor2) {
                            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
                            int index2 = descriptor2.getReceiver() != null ? this.this$0.$parameterDescriptor.getIndex() + 1 : this.this$0.$parameterDescriptor.getIndex();
                            descriptor2.removeParameter(index2);
                        }
                        {
                            this.this$0 = var1_1;
                            super(1);
                        }
                    }));
                }

                public boolean performSilently(@NotNull Collection<? extends PsiElement> affectedFunctions) {
                    Intrinsics.checkParameterIsNotNull(affectedFunctions, (String)"affectedFunctions");
                    return false;
                }

                public boolean forcePerformForSelectedFunctionOnly() {
                    return false;
                }
                {
                    this.$parameterDescriptor = $captured_local_variable$0;
                }
            }, context, "Remove parameter '" + parameterDescriptor.getName().asString() + "'");
        }

        private Companion() {
            super(null, 1, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\"\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeFunctionSignatureFix$Companion$RemoveParameterFix;", "Lorg/jetbrains/kotlin/idea/quickfix/ChangeFunctionSignatureFix;", "context", "Lcom/intellij/psi/PsiElement;", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "parameterToRemove", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "(Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;)V", "getText", "", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "idea"})
        private static final class RemoveParameterFix
        extends ChangeFunctionSignatureFix {
            private final ValueParameterDescriptor parameterToRemove;

            @NotNull
            public String getText() {
                return "Remove parameter '" + this.parameterToRemove.getName().asString() + "'";
            }

            @Override
            protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                Companion.runRemoveParameter(this.parameterToRemove, this.getContext());
            }

            public RemoveParameterFix(@NotNull PsiElement context, @NotNull FunctionDescriptor functionDescriptor, @NotNull ValueParameterDescriptor parameterToRemove) {
                Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                Intrinsics.checkParameterIsNotNull((Object)functionDescriptor, (String)"functionDescriptor");
                Intrinsics.checkParameterIsNotNull((Object)parameterToRemove, (String)"parameterToRemove");
                super(context, functionDescriptor);
                this.parameterToRemove = parameterToRemove;
            }
        }
    }
}

