/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters3;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.quickfix.QuickFixUtil;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.idea.quickfix.ChangeFunctionLiteralReturnTypeFix;
import org.jetbrains.kotlin.idea.quickfix.KotlinIntentionActionsFactory;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.idea.util.ShortenReferences;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.dataClassUtils.DataClassUtilsKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;

public class ChangeFunctionReturnTypeFix
extends KotlinQuickFixAction<KtFunction> {
    private final KotlinType type;
    private final ChangeFunctionLiteralReturnTypeFix changeFunctionLiteralReturnTypeFix;

    public ChangeFunctionReturnTypeFix(@NotNull KtFunction element2, @NotNull KotlinType type2) {
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionReturnTypeFix", "<init>"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionReturnTypeFix", "<init>"));
        }
        super(element2);
        this.type = type2;
        if (element2 instanceof KtFunctionLiteral) {
            KtLambdaExpression functionLiteralExpression = (KtLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)element2, KtLambdaExpression.class);
            assert (functionLiteralExpression != null) : "FunctionLiteral outside any FunctionLiteralExpression: " + PsiUtilsKt.getElementTextWithContext(element2);
            this.changeFunctionLiteralReturnTypeFix = new ChangeFunctionLiteralReturnTypeFix(functionLiteralExpression, type2);
        } else {
            this.changeFunctionLiteralReturnTypeFix = null;
        }
    }

    @NotNull
    public String getText() {
        if (this.changeFunctionLiteralReturnTypeFix != null) {
            String string = this.changeFunctionLiteralReturnTypeFix.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionReturnTypeFix", "getText"));
            }
            return string;
        }
        String functionName = ((KtFunction)this.getElement()).getName();
        FqName fqName2 = ((KtFunction)this.getElement()).getFqName();
        if (fqName2 != null) {
            functionName = fqName2.asString();
        }
        if (KotlinBuiltIns.isUnit(this.type) && ((KtFunction)this.getElement()).hasBlockBody()) {
            String string = functionName == null ? KotlinBundle.message("remove.no.name.function.return.type", new Object[0]) : KotlinBundle.message("remove.function.return.type", functionName);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionReturnTypeFix", "getText"));
            }
            return string;
        }
        String renderedType = IdeDescriptorRenderers.SOURCE_CODE_SHORT_NAMES_IN_TYPES.renderType(this.type);
        String string = functionName == null ? KotlinBundle.message("change.no.name.function.return.type", renderedType) : KotlinBundle.message("change.function.return.type", functionName, renderedType);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionReturnTypeFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = KotlinBundle.message("change.type.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionReturnTypeFix", "getFamilyName"));
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionReturnTypeFix", "isAvailable"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionReturnTypeFix", "isAvailable"));
        }
        return super.isAvailable(project, editor, file) && !ErrorUtils.containsErrorType(this.type) && !(this.getElement() instanceof KtConstructor);
    }

    @Override
    public void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionReturnTypeFix", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionReturnTypeFix", "invoke"));
        }
        if (this.changeFunctionLiteralReturnTypeFix != null) {
            this.changeFunctionLiteralReturnTypeFix.invoke(project, editor, file);
        } else if (!KotlinBuiltIns.isUnit(this.type) || !((KtFunction)this.getElement()).hasBlockBody()) {
            KtTypeReference newTypeRef = KtPsiFactoryKt.KtPsiFactory(project).createType(IdeDescriptorRenderers.SOURCE_CODE.renderType(this.type));
            newTypeRef = ((KtFunction)this.getElement()).setTypeReference(newTypeRef);
            assert (newTypeRef != null);
            ShortenReferences.DEFAULT.process(newTypeRef);
        } else {
            ((KtFunction)this.getElement()).setTypeReference(null);
        }
    }

    @NotNull
    public static KtDestructuringDeclarationEntry getDestructuringDeclarationEntryThatTypeMismatchComponentFunction(Diagnostic diagnostic) {
        Name componentName = (Name)((DiagnosticWithParameters3)Errors.COMPONENT_FUNCTION_RETURN_TYPE_MISMATCH.cast(diagnostic)).getA();
        int componentIndex = DataClassUtilsKt.getComponentIndex(componentName);
        KtDestructuringDeclaration multiDeclaration = QuickFixUtil.getParentElementOfType(diagnostic, KtDestructuringDeclaration.class);
        assert (multiDeclaration != null) : "COMPONENT_FUNCTION_RETURN_TYPE_MISMATCH reported on expression that is not within any multi declaration";
        KtDestructuringDeclarationEntry ktDestructuringDeclarationEntry = multiDeclaration.getEntries().get(componentIndex - 1);
        if (ktDestructuringDeclarationEntry == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionReturnTypeFix", "getDestructuringDeclarationEntryThatTypeMismatchComponentFunction"));
        }
        return ktDestructuringDeclarationEntry;
    }

    @NotNull
    public static KotlinSingleIntentionActionFactory createFactoryForComponentFunctionReturnTypeMismatch() {
        KotlinSingleIntentionActionFactory kotlinSingleIntentionActionFactory = new KotlinSingleIntentionActionFactory(){

            @Override
            @Nullable
            public IntentionAction createAction(@NotNull Diagnostic diagnostic) {
                if (diagnostic == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionReturnTypeFix$1", "createAction"));
                }
                KtDestructuringDeclarationEntry entry = ChangeFunctionReturnTypeFix.getDestructuringDeclarationEntryThatTypeMismatchComponentFunction(diagnostic);
                BindingContext context = ResolutionUtils.analyze(entry);
                ResolvedCall<FunctionDescriptor> resolvedCall2 = context.get(BindingContext.COMPONENT_RESOLVED_CALL, entry);
                if (resolvedCall2 == null) {
                    return null;
                }
                KtFunction componentFunction = (KtFunction)DescriptorToSourceUtils.descriptorToDeclaration(resolvedCall2.getCandidateDescriptor());
                KotlinType expectedType = context.get(BindingContext.TYPE, entry.getTypeReference());
                if (componentFunction != null && expectedType != null) {
                    return new ChangeFunctionReturnTypeFix(componentFunction, expectedType);
                }
                return null;
            }
        };
        if (kotlinSingleIntentionActionFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionReturnTypeFix", "createFactoryForComponentFunctionReturnTypeMismatch"));
        }
        return kotlinSingleIntentionActionFactory;
    }

    @NotNull
    public static KotlinSingleIntentionActionFactory createFactoryForHasNextFunctionTypeMismatch() {
        KotlinSingleIntentionActionFactory kotlinSingleIntentionActionFactory = new KotlinSingleIntentionActionFactory(){

            @Override
            @Nullable
            public IntentionAction createAction(@NotNull Diagnostic diagnostic) {
                if (diagnostic == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionReturnTypeFix$2", "createAction"));
                }
                KtExpression expression2 = QuickFixUtil.getParentElementOfType(diagnostic, KtExpression.class);
                assert (expression2 != null) : "HAS_NEXT_FUNCTION_TYPE_MISMATCH reported on element that is not within any expression";
                BindingContext context = ResolutionUtils.analyze(expression2);
                ResolvedCall<FunctionDescriptor> resolvedCall2 = context.get(BindingContext.LOOP_RANGE_HAS_NEXT_RESOLVED_CALL, expression2);
                if (resolvedCall2 == null) {
                    return null;
                }
                FunctionDescriptor hasNextDescriptor = resolvedCall2.getCandidateDescriptor();
                KtFunction hasNextFunction = (KtFunction)DescriptorToSourceUtils.descriptorToDeclaration(hasNextDescriptor);
                if (hasNextFunction != null) {
                    return new ChangeFunctionReturnTypeFix(hasNextFunction, DescriptorUtilsKt.getBuiltIns(hasNextDescriptor).getBooleanType());
                }
                return null;
            }
        };
        if (kotlinSingleIntentionActionFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionReturnTypeFix", "createFactoryForHasNextFunctionTypeMismatch"));
        }
        return kotlinSingleIntentionActionFactory;
    }

    @NotNull
    public static KotlinSingleIntentionActionFactory createFactoryForCompareToTypeMismatch() {
        KotlinSingleIntentionActionFactory kotlinSingleIntentionActionFactory = new KotlinSingleIntentionActionFactory(){

            @Override
            @Nullable
            public IntentionAction createAction(@NotNull Diagnostic diagnostic) {
                if (diagnostic == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionReturnTypeFix$3", "createAction"));
                }
                KtBinaryExpression expression2 = QuickFixUtil.getParentElementOfType(diagnostic, KtBinaryExpression.class);
                assert (expression2 != null) : "COMPARE_TO_TYPE_MISMATCH reported on element that is not within any expression";
                BindingContext context = ResolutionUtils.analyze(expression2);
                ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(expression2, context);
                if (resolvedCall2 == null) {
                    return null;
                }
                CallableDescriptor compareToDescriptor = resolvedCall2.getCandidateDescriptor();
                PsiElement compareTo = DescriptorToSourceUtils.descriptorToDeclaration(compareToDescriptor);
                if (!(compareTo instanceof KtFunction)) {
                    return null;
                }
                return new ChangeFunctionReturnTypeFix((KtFunction)compareTo, DescriptorUtilsKt.getBuiltIns(compareToDescriptor).getIntType());
            }
        };
        if (kotlinSingleIntentionActionFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionReturnTypeFix", "createFactoryForCompareToTypeMismatch"));
        }
        return kotlinSingleIntentionActionFactory;
    }

    @NotNull
    public static KotlinIntentionActionsFactory createFactoryForReturnTypeMismatchOnOverride() {
        KotlinIntentionActionsFactory kotlinIntentionActionsFactory = new KotlinIntentionActionsFactory(){

            @Override
            @NotNull
            protected List<IntentionAction> doCreateActions(@NotNull Diagnostic diagnostic) {
                if (diagnostic == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionReturnTypeFix$4", "doCreateActions"));
                }
                LinkedList<IntentionAction> actions2 = new LinkedList<IntentionAction>();
                KtFunction function2 = QuickFixUtil.getParentElementOfType(diagnostic, KtFunction.class);
                if (function2 != null) {
                    PsiElement overriddenFunction;
                    KotlinType functionType;
                    FunctionDescriptor descriptor2 = (FunctionDescriptor)ResolutionUtils.resolveToDescriptor(function2);
                    KotlinType matchingReturnType = QuickFixUtil.findLowerBoundOfOverriddenCallablesReturnTypes(descriptor2);
                    if (matchingReturnType != null) {
                        actions2.add(new ChangeFunctionReturnTypeFix(function2, matchingReturnType));
                    }
                    if ((functionType = descriptor2.getReturnType()) == null) {
                        LinkedList<IntentionAction> linkedList = actions2;
                        if (linkedList == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionReturnTypeFix$4", "doCreateActions"));
                        }
                        return linkedList;
                    }
                    LinkedList<FunctionDescriptor> overriddenMismatchingFunctions = new LinkedList<FunctionDescriptor>();
                    for (FunctionDescriptor functionDescriptor : descriptor2.getOverriddenDescriptors()) {
                        KotlinType overriddenFunctionType = functionDescriptor.getReturnType();
                        if (overriddenFunctionType == null || KotlinTypeChecker.DEFAULT.isSubtypeOf(functionType, overriddenFunctionType)) continue;
                        overriddenMismatchingFunctions.add(functionDescriptor);
                    }
                    if (overriddenMismatchingFunctions.size() == 1 && (overriddenFunction = DescriptorToSourceUtils.descriptorToDeclaration((DeclarationDescriptor)overriddenMismatchingFunctions.get(0))) instanceof KtFunction) {
                        actions2.add(new ChangeFunctionReturnTypeFix((KtFunction)overriddenFunction, functionType));
                    }
                }
                LinkedList<IntentionAction> linkedList = actions2;
                if (linkedList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionReturnTypeFix$4", "doCreateActions"));
                }
                return linkedList;
            }
        };
        if (kotlinIntentionActionsFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionReturnTypeFix", "createFactoryForReturnTypeMismatchOnOverride"));
        }
        return kotlinIntentionActionsFactory;
    }

    @NotNull
    public static KotlinSingleIntentionActionFactory createFactoryForChangingReturnTypeToUnit() {
        KotlinSingleIntentionActionFactory kotlinSingleIntentionActionFactory = new KotlinSingleIntentionActionFactory(){

            @Override
            @Nullable
            public IntentionAction createAction(@NotNull Diagnostic diagnostic) {
                if (diagnostic == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionReturnTypeFix$5", "createAction"));
                }
                KtFunction function2 = QuickFixUtil.getParentElementOfType(diagnostic, KtFunction.class);
                return function2 == null ? null : new ChangeFunctionReturnTypeFix(function2, PlatformKt.getPlatform(function2).getBuiltIns().getUnitType());
            }
        };
        if (kotlinSingleIntentionActionFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionReturnTypeFix", "createFactoryForChangingReturnTypeToUnit"));
        }
        return kotlinSingleIntentionActionFactory;
    }

    @NotNull
    public static KotlinSingleIntentionActionFactory createFactoryForChangingReturnTypeToNothing() {
        KotlinSingleIntentionActionFactory kotlinSingleIntentionActionFactory = new KotlinSingleIntentionActionFactory(){

            @Override
            @Nullable
            public IntentionAction createAction(@NotNull Diagnostic diagnostic) {
                if (diagnostic == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionReturnTypeFix$6", "createAction"));
                }
                KtFunction function2 = QuickFixUtil.getParentElementOfType(diagnostic, KtFunction.class);
                return function2 == null ? null : new ChangeFunctionReturnTypeFix(function2, PlatformKt.getPlatform(function2).getBuiltIns().getNothingType());
            }
        };
        if (kotlinSingleIntentionActionFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionReturnTypeFix", "createFactoryForChangingReturnTypeToNothing"));
        }
        return kotlinSingleIntentionActionFactory;
    }
}

