/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtExpression;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\u00020\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/CaretBox;", "E", "Lorg/jetbrains/kotlin/psi/KtExpression;", "", "expression", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lcom/intellij/openapi/editor/Editor;)V", "getExpression", "()Lorg/jetbrains/kotlin/psi/KtExpression;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "offsetInExpression", "", "positionCaretInCopy", "", "copy", "Lcom/intellij/psi/PsiElement;", "idea-analysis"})
final class CaretBox<E extends KtExpression> {
    private final int offsetInExpression;
    @NotNull
    private final E expression;
    private final Editor editor;

    public final void positionCaretInCopy(@NotNull PsiElement copy) {
        Intrinsics.checkParameterIsNotNull((Object)copy, (String)"copy");
        if (this.editor == null) {
            return;
        }
        this.editor.getCaretModel().moveToOffset(copy.getTextOffset() + this.offsetInExpression);
    }

    @NotNull
    public final E getExpression() {
        return this.expression;
    }

    public CaretBox(@NotNull E expression2, @Nullable Editor editor) {
        Intrinsics.checkParameterIsNotNull(expression2, (String)"expression");
        this.expression = expression2;
        this.editor = editor;
        Editor editor2 = this.editor;
        int n = editor2 != null && (editor2 = editor2.getCaretModel()) != null ? editor2.getOffset() : 0;
        TextRange textRange = this.expression.getTextRange();
        if (textRange == null) {
            Intrinsics.throwNpe();
        }
        this.offsetInExpression = n - textRange.getStartOffset();
    }
}

