/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions.branchedTransformations.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.lang.StringEscapeUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.intentions.ChooseStringExpression;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingRangeIntention;
import org.jetbrains.kotlin.idea.intentions.branchedTransformations.IfThenUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtThrowExpression;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u00022\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/branchedTransformations/intentions/DoubleBangToIfThenIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingRangeIntention;", "Lorg/jetbrains/kotlin/psi/KtPostfixExpression;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "()V", "applicabilityRange", "Lcom/intellij/openapi/util/TextRange;", "element", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "formatForUseInExceptionArgument", "", "expressionText", "idea"})
public final class DoubleBangToIfThenIntention
extends SelfTargetingRangeIntention<KtPostfixExpression>
implements LowPriorityAction {
    @Override
    @Nullable
    public TextRange applicabilityRange(@NotNull KtPostfixExpression element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        return Intrinsics.areEqual((Object)element2.getOperationToken(), (Object)((Object)KtTokens.EXCLEXCL)) && element2.getBaseExpression() != null ? element2.getOperationReference().getTextRange() : (TextRange)null;
    }

    @Override
    public void applyTo(@NotNull KtPostfixExpression element2, @Nullable Editor editor) {
        KtIfExpression ktIfExpression;
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        if (editor == null) {
            throw (Throwable)new IllegalArgumentException("This intention requires an editor");
        }
        KtExpression ktExpression = element2.getBaseExpression();
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        KtExpression base = KtPsiUtil.safeDeparenthesize(ktExpression);
        String string = base.getText();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        String expressionText2 = this.formatForUseInExceptionArgument(string);
        KtExpression defaultException = KtPsiFactoryKt.KtPsiFactory((PsiElement)element2).createExpression("throw NullPointerException()");
        boolean isStatement = BindingContextUtilsKt.isUsedAsStatement(element2, ResolutionUtils.analyze$default(element2, null, 1, null));
        boolean isStable = IfThenUtilsKt.isStableVariable(base);
        if (isStatement) {
            KtExpression ktExpression2 = element2;
            KtExpression ktExpression3 = base;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression3, (String)"base");
            ktIfExpression = IfThenUtilsKt.convertToIfNullExpression(ktExpression2, ktExpression3, defaultException);
        } else {
            KtExpression ktExpression4 = element2;
            KtExpression ktExpression5 = base;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression5, (String)"base");
            KtExpression ktExpression6 = base;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression6, (String)"base");
            ktIfExpression = IfThenUtilsKt.convertToIfNotNullExpression(ktExpression4, ktExpression5, ktExpression6, defaultException);
        }
        KtIfExpression ifStatement = ktIfExpression;
        KtExpression ktExpression7 = isStatement ? ifStatement.getThen() : ifStatement.getElse();
        if (ktExpression7 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtThrowExpression");
        }
        KtExpression ktExpression8 = ((KtThrowExpression)ktExpression7).getThrownExpression();
        if (ktExpression8 == null) {
            Intrinsics.throwNpe();
        }
        KtExpression thrownExpression = ktExpression8;
        String message2 = StringEscapeUtils.escapeJava((String)("Expression '" + expressionText2 + "' must not be null"));
        String nullPtrExceptionText = "NullPointerException(" + "\"" + message2 + "\"" + ")";
        String kotlinNullPtrExceptionText = "KotlinNullPointerException()";
        ChooseStringExpression exceptionLookupExpression = new ChooseStringExpression((Collection)CollectionsKt.listOf((Object[])new String[]{nullPtrExceptionText, kotlinNullPtrExceptionText}), null, null, 6, null);
        Project project = element2.getProject();
        TemplateBuilderImpl builder = new TemplateBuilderImpl((PsiElement)thrownExpression);
        builder.replaceElement((PsiElement)thrownExpression, (Expression)exceptionLookupExpression);
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
        CaretModel caretModel = editor.getCaretModel();
        ASTNode aSTNode = thrownExpression.getNode();
        if (aSTNode == null) {
            Intrinsics.throwNpe();
        }
        caretModel.moveToOffset(aSTNode.getStartOffset());
        TemplateManager.getInstance((Project)project).startTemplate(editor, builder.buildInlineTemplate(), (TemplateEditingListener)new TemplateEditingAdapter(isStable, isStatement, ifStatement, editor){
            final /* synthetic */ boolean $isStable;
            final /* synthetic */ boolean $isStatement;
            final /* synthetic */ KtIfExpression $ifStatement;
            final /* synthetic */ Editor $editor;

            public void templateFinished(@Nullable Template template, boolean brokenOff) {
                if (!this.$isStable && !this.$isStatement) {
                    KtExpression ktExpression = this.$ifStatement.getThen();
                    if (ktExpression == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"ifStatement.then!!");
                    IfThenUtilsKt.introduceValueForCondition(this.$ifStatement, ktExpression, this.$editor);
                }
            }
            {
                this.$isStable = $captured_local_variable$0;
                this.$isStatement = $captured_local_variable$1;
                this.$ifStatement = $captured_local_variable$2;
                this.$editor = $captured_local_variable$3;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final String formatForUseInExceptionArgument(String expressionText2) {
        String string;
        List lines = StringsKt.split$default((CharSequence)expressionText2, (char[])new char[]{'\n'}, (boolean)false, (int)0, (int)6, null);
        if (lines.size() > 1) {
            void $receiver$iv;
            String string2 = (String)CollectionsKt.first((List)lines);
            StringBuilder stringBuilder = new StringBuilder();
            void v0 = $receiver$iv;
            if (v0 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String string3 = ((Object)StringsKt.trim((CharSequence)((CharSequence)v0))).toString();
            string = stringBuilder.append(string3).append(" ...").toString();
        } else {
            String $receiver$iv = expressionText2;
            String string4 = $receiver$iv;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            string = ((Object)StringsKt.trim((CharSequence)string4)).toString();
        }
        return string;
    }

    public DoubleBangToIfThenIntention() {
        super(KtPostfixExpression.class, "Replace '!!' expression with 'if' expression", null, 4, null);
    }
}

