/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.formatter;

import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.formatting.FormattingModelProvider;
import com.intellij.formatting.Indent;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.FormattingDocumentModelImpl;
import com.intellij.psi.formatter.PsiBasedFormattingModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.formatter.KotlinBlock;
import org.jetbrains.kotlin.idea.formatter.KotlinSpacingRulesKt;
import org.jetbrains.kotlin.idea.formatter.NodeAlignmentStrategy;

public class KotlinFormattingModelBuilder
implements FormattingModelBuilder {
    @NotNull
    public FormattingModel createModel(PsiElement element2, CodeStyleSettings settings) {
        PsiFile containingFile = element2.getContainingFile().getViewProvider().getPsi((Language)KotlinLanguage.INSTANCE);
        KotlinBlock block = new KotlinBlock((ASTNode)containingFile.getNode(), NodeAlignmentStrategy.getNullStrategy(), Indent.getNoneIndent(), null, settings, KotlinSpacingRulesKt.createSpacingBuilder(settings));
        if (!element2.isPhysical()) {
            FormattingDocumentModelImpl formattingDocumentModel = new FormattingDocumentModelImpl((Document)new DocumentImpl(containingFile.getViewProvider().getContents(), true), containingFile);
            PsiBasedFormattingModel psiBasedFormattingModel = new PsiBasedFormattingModel(containingFile, (Block)block, formattingDocumentModel);
            if (psiBasedFormattingModel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/formatter/KotlinFormattingModelBuilder", "createModel"));
            }
            return psiBasedFormattingModel;
        }
        FormattingModel formattingModel = FormattingModelProvider.createFormattingModelForPsiFile((PsiFile)element2.getContainingFile(), (Block)block, (CodeStyleSettings)settings);
        if (formattingModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/formatter/KotlinFormattingModelBuilder", "createModel"));
        }
        return formattingModel;
    }

    public TextRange getRangeAffectingIndent(PsiFile psiFile, int i, ASTNode astNode) {
        return null;
    }
}

