/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.formatter;

import com.intellij.application.options.CodeStyleAbstractConfigurable;
import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.application.options.TabbedLanguageCodeStylePanel;
import com.intellij.lang.Language;
import com.intellij.openapi.options.Configurable;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.core.formatter.KotlinCodeStyleSettings;
import org.jetbrains.kotlin.idea.formatter.ImportSettingsPanelWrapper;

public class KotlinCodeStyleSettingsProvider
extends CodeStyleSettingsProvider {
    public String getConfigurableDisplayName() {
        return "Kotlin";
    }

    public Language getLanguage() {
        return KotlinLanguage.INSTANCE;
    }

    public CustomCodeStyleSettings createCustomSettings(CodeStyleSettings settings) {
        return new KotlinCodeStyleSettings(settings);
    }

    @NotNull
    public Configurable createSettingsPage(CodeStyleSettings settings, CodeStyleSettings originalSettings) {
        CodeStyleAbstractConfigurable codeStyleAbstractConfigurable = new CodeStyleAbstractConfigurable(settings, originalSettings, "Kotlin"){

            protected CodeStyleAbstractPanel createPanel(CodeStyleSettings settings) {
                return new TabbedLanguageCodeStylePanel(KotlinLanguage.INSTANCE, this.getCurrentSettings(), settings){

                    protected void initTabs(CodeStyleSettings settings) {
                        this.addIndentOptionsTab(settings);
                        this.addSpacesTab(settings);
                        this.addWrappingAndBracesTab(settings);
                        this.addTab(new ImportSettingsPanelWrapper(settings));
                    }
                };
            }

            public String getHelpTopic() {
                return null;
            }
        };
        if (codeStyleAbstractConfigurable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/formatter/KotlinCodeStyleSettingsProvider", "createSettingsPage"));
        }
        return codeStyleAbstractConfigurable;
    }
}

