/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.formatter;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.alignment.AlignmentStrategy;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.formatter.common.AbstractBlock;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.core.formatter.KotlinCodeStyleSettings;
import org.jetbrains.kotlin.idea.formatter.KotlinSpacingBuilder;
import org.jetbrains.kotlin.idea.formatter.NodeAlignmentStrategy;
import org.jetbrains.kotlin.idea.formatter.NodeIndentStrategy;
import org.jetbrains.kotlin.idea.formatter.SyntheticKotlinBlock;
import org.jetbrains.kotlin.idea.formatter.WrappingStrategy;
import org.jetbrains.kotlin.kdoc.lexer.KDocTokens;
import org.jetbrains.kotlin.kdoc.parser.KDocElementTypes;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtDeclaration;

public class KotlinBlock
extends AbstractBlock {
    private static final int KDOC_COMMENT_INDENT = 1;
    private final NodeAlignmentStrategy myAlignmentStrategy;
    private final Indent myIndent;
    private final CodeStyleSettings mySettings;
    private final KotlinSpacingBuilder mySpacingBuilder;
    private List<Block> mySubBlocks;
    private static final TokenSet BINARY_EXPRESSIONS = TokenSet.create((IElementType[])new IElementType[]{KtNodeTypes.BINARY_EXPRESSION, KtNodeTypes.BINARY_WITH_TYPE, KtNodeTypes.IS_EXPRESSION});
    private static final TokenSet QUALIFIED_OPERATION = TokenSet.create((IElementType[])new IElementType[]{KtTokens.DOT, KtTokens.SAFE_ACCESS});
    private static final TokenSet ALIGN_FOR_BINARY_OPERATIONS = TokenSet.create((IElementType[])new IElementType[]{KtTokens.MUL, KtTokens.DIV, KtTokens.PERC, KtTokens.PLUS, KtTokens.MINUS, KtTokens.ELVIS, KtTokens.LT, KtTokens.GT, KtTokens.LTEQ, KtTokens.GTEQ, KtTokens.ANDAND, KtTokens.OROR});
    private static final TokenSet CODE_BLOCKS = TokenSet.create((IElementType[])new IElementType[]{KtNodeTypes.BLOCK, KtNodeTypes.CLASS_BODY, KtNodeTypes.FUNCTION_LITERAL});
    private static final TokenSet KDOC_CONTENT = TokenSet.create((IElementType[])new IElementType[]{KDocTokens.KDOC, KDocElementTypes.KDOC_SECTION, KDocElementTypes.KDOC_TAG});
    private static final NodeIndentStrategy[] INDENT_RULES = new NodeIndentStrategy[]{NodeIndentStrategy.strategy("No indent for braces in blocks").in(KtNodeTypes.BLOCK, KtNodeTypes.CLASS_BODY, KtNodeTypes.FUNCTION_LITERAL).forType(KtTokens.RBRACE, KtTokens.LBRACE).set(Indent.getNoneIndent()), NodeIndentStrategy.strategy("Indent for block content").in(KtNodeTypes.BLOCK, KtNodeTypes.CLASS_BODY, KtNodeTypes.FUNCTION_LITERAL).notForType(KtTokens.RBRACE, KtTokens.LBRACE, KtNodeTypes.BLOCK).set(Indent.getNormalIndent((boolean)false)), NodeIndentStrategy.strategy("Indent for property accessors").in(KtNodeTypes.PROPERTY, new IElementType[0]).forType(KtNodeTypes.PROPERTY_ACCESSOR, new IElementType[0]).set(Indent.getNormalIndent()), NodeIndentStrategy.strategy("For a single statement in 'for'").in(KtNodeTypes.BODY, new IElementType[0]).notForType(KtNodeTypes.BLOCK, new IElementType[0]).set(Indent.getNormalIndent()), NodeIndentStrategy.strategy("For the entry in when").forType(KtNodeTypes.WHEN_ENTRY, new IElementType[0]).set(Indent.getNormalIndent()), NodeIndentStrategy.strategy("For single statement in THEN and ELSE").in(KtNodeTypes.THEN, KtNodeTypes.ELSE).notForType(KtNodeTypes.BLOCK, new IElementType[0]).set(Indent.getNormalIndent()), NodeIndentStrategy.strategy("Indent for parts").in(KtNodeTypes.PROPERTY, KtNodeTypes.FUN, KtNodeTypes.DESTRUCTURING_DECLARATION).notForType(KtNodeTypes.BLOCK, KtTokens.FUN_KEYWORD, KtTokens.VAL_KEYWORD, KtTokens.VAR_KEYWORD).set(Indent.getContinuationWithoutFirstIndent()), NodeIndentStrategy.strategy("Chained calls").in(KtNodeTypes.DOT_QUALIFIED_EXPRESSION, KtNodeTypes.SAFE_ACCESS_EXPRESSION).set(Indent.getContinuationWithoutFirstIndent((boolean)false)), NodeIndentStrategy.strategy("Delegation list").in(KtNodeTypes.SUPER_TYPE_LIST, KtNodeTypes.INITIALIZER_LIST).set(Indent.getContinuationIndent((boolean)false)), NodeIndentStrategy.strategy("Indices").in(KtNodeTypes.INDICES, new IElementType[0]).set(Indent.getContinuationIndent((boolean)false)), NodeIndentStrategy.strategy("Binary expressions").in(BINARY_EXPRESSIONS).set(Indent.getContinuationWithoutFirstIndent((boolean)false)), NodeIndentStrategy.strategy("Parenthesized expression").in(KtNodeTypes.PARENTHESIZED, new IElementType[0]).set(Indent.getContinuationWithoutFirstIndent((boolean)false)), NodeIndentStrategy.strategy("KDoc comment indent").in(KDOC_CONTENT).forType(KDocTokens.LEADING_ASTERISK, KDocTokens.END).set(Indent.getSpaceIndent((int)1)), NodeIndentStrategy.strategy("Block in when entry").in(KtNodeTypes.WHEN_ENTRY, new IElementType[0]).notForType(KtNodeTypes.BLOCK, KtNodeTypes.WHEN_CONDITION_EXPRESSION, KtNodeTypes.WHEN_CONDITION_IN_RANGE, KtNodeTypes.WHEN_CONDITION_IS_PATTERN, KtTokens.ELSE_KEYWORD, KtTokens.ARROW).set(Indent.getNormalIndent())};

    public KotlinBlock(@NotNull ASTNode node, @NotNull NodeAlignmentStrategy alignmentStrategy, Indent indent, Wrap wrap, CodeStyleSettings settings, KotlinSpacingBuilder spacingBuilder) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/idea/formatter/KotlinBlock", "<init>"));
        }
        if (alignmentStrategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "alignmentStrategy", "org/jetbrains/kotlin/idea/formatter/KotlinBlock", "<init>"));
        }
        super(node, wrap, alignmentStrategy.getAlignment(node));
        this.myAlignmentStrategy = alignmentStrategy;
        this.myIndent = indent;
        this.mySettings = settings;
        this.mySpacingBuilder = spacingBuilder;
    }

    public Indent getIndent() {
        return this.myIndent;
    }

    protected List<Block> buildChildren() {
        if (this.mySubBlocks == null) {
            int operationBlockIndex;
            List nodeSubBlocks = this.buildSubBlocks();
            if ((this.getNode().getElementType() == KtNodeTypes.DOT_QUALIFIED_EXPRESSION || this.getNode().getElementType() == KtNodeTypes.SAFE_ACCESS_EXPRESSION) && (operationBlockIndex = KotlinBlock.findNodeBlockIndex(nodeSubBlocks, QUALIFIED_OPERATION)) != -1) {
                Block operationBlock = nodeSubBlocks.get(operationBlockIndex);
                SyntheticKotlinBlock operationSynteticBlock = new SyntheticKotlinBlock(((ASTBlock)operationBlock).getNode(), nodeSubBlocks.subList(operationBlockIndex, nodeSubBlocks.size()), null, operationBlock.getIndent(), null, this.mySpacingBuilder);
                nodeSubBlocks = (List)ContainerUtil.addAll((Collection)ContainerUtil.newArrayList(nodeSubBlocks.subList(0, operationBlockIndex)), (Object[])new SyntheticKotlinBlock[]{operationSynteticBlock});
            }
            this.mySubBlocks = nodeSubBlocks;
        }
        return this.mySubBlocks;
    }

    private List<Block> buildSubBlocks() {
        ArrayList<Block> blocks = new ArrayList<Block>();
        NodeAlignmentStrategy childrenAlignmentStrategy = this.getChildrenAlignmentStrategy();
        WrappingStrategy wrappingStrategy = this.getWrappingStrategy();
        for (ASTNode child = this.myNode.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType childType = child.getElementType();
            if (child.getTextRange().getLength() == 0 || childType == TokenType.WHITE_SPACE) continue;
            blocks.add(this.buildSubBlock(child, childrenAlignmentStrategy, wrappingStrategy));
        }
        return Collections.unmodifiableList(blocks);
    }

    @NotNull
    private Block buildSubBlock(@NotNull ASTNode child, NodeAlignmentStrategy alignmentStrategy, @NotNull WrappingStrategy wrappingStrategy) {
        ASTNode operationNode;
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "org/jetbrains/kotlin/idea/formatter/KotlinBlock", "buildSubBlock"));
        }
        if (wrappingStrategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrappingStrategy", "org/jetbrains/kotlin/idea/formatter/KotlinBlock", "buildSubBlock"));
        }
        Wrap wrap = wrappingStrategy.getWrap(child.getElementType());
        if (child.getElementType() == KtNodeTypes.OPERATION_REFERENCE && (operationNode = child.getFirstChildNode()) != null) {
            KotlinBlock kotlinBlock = new KotlinBlock(operationNode, alignmentStrategy, KotlinBlock.createChildIndent(child), wrap, this.mySettings, this.mySpacingBuilder);
            if (kotlinBlock == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/formatter/KotlinBlock", "buildSubBlock"));
            }
            return kotlinBlock;
        }
        KotlinBlock kotlinBlock = new KotlinBlock(child, alignmentStrategy, KotlinBlock.createChildIndent(child), wrap, this.mySettings, this.mySpacingBuilder);
        if (kotlinBlock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/formatter/KotlinBlock", "buildSubBlock"));
        }
        return kotlinBlock;
    }

    private static ASTNode getPrevWithoutWhitespace(ASTNode node) {
        for (node = node.getTreePrev(); node != null && node.getElementType() == TokenType.WHITE_SPACE; node = node.getTreePrev()) {
        }
        return node;
    }

    private static ASTNode getPrevWithoutWhitespaceAndComments(ASTNode node) {
        for (node = node.getTreePrev(); node != null && (node.getElementType() == TokenType.WHITE_SPACE || KtTokens.COMMENTS.contains(node.getElementType())); node = node.getTreePrev()) {
        }
        return node;
    }

    public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
        if (child2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child2", "org/jetbrains/kotlin/idea/formatter/KotlinBlock", "getSpacing"));
        }
        return this.mySpacingBuilder.getSpacing((Block)this, child1, child2);
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        IElementType type2 = this.getNode().getElementType();
        if (CODE_BLOCKS.contains(type2) || type2 == KtNodeTypes.WHEN || type2 == KtNodeTypes.IF || type2 == KtNodeTypes.FOR || type2 == KtNodeTypes.WHILE || type2 == KtNodeTypes.DO_WHILE) {
            ChildAttributes childAttributes = new ChildAttributes(Indent.getNormalIndent(), null);
            if (childAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/formatter/KotlinBlock", "getChildAttributes"));
            }
            return childAttributes;
        }
        if (type2 == KtNodeTypes.TRY) {
            ChildAttributes childAttributes = new ChildAttributes(Indent.getNoneIndent(), null);
            if (childAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/formatter/KotlinBlock", "getChildAttributes"));
            }
            return childAttributes;
        }
        if (type2 == KtNodeTypes.DOT_QUALIFIED_EXPRESSION || type2 == KtNodeTypes.SAFE_ACCESS_EXPRESSION) {
            ChildAttributes childAttributes = new ChildAttributes(Indent.getContinuationWithoutFirstIndent(), null);
            if (childAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/formatter/KotlinBlock", "getChildAttributes"));
            }
            return childAttributes;
        }
        if (type2 == KtNodeTypes.VALUE_PARAMETER_LIST || type2 == KtNodeTypes.VALUE_ARGUMENT_LIST) {
            if (newChildIndex != 1 && newChildIndex != 0 && newChildIndex < this.getSubBlocks().size()) {
                Block block = (Block)this.getSubBlocks().get(newChildIndex);
                ChildAttributes childAttributes = new ChildAttributes(block.getIndent(), block.getAlignment());
                if (childAttributes == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/formatter/KotlinBlock", "getChildAttributes"));
                }
                return childAttributes;
            }
            ChildAttributes childAttributes = new ChildAttributes(Indent.getContinuationIndent(), null);
            if (childAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/formatter/KotlinBlock", "getChildAttributes"));
            }
            return childAttributes;
        }
        if (type2 == KtTokens.DOC_COMMENT) {
            ChildAttributes childAttributes = new ChildAttributes(Indent.getSpaceIndent((int)1), null);
            if (childAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/formatter/KotlinBlock", "getChildAttributes"));
            }
            return childAttributes;
        }
        if (type2 == KtNodeTypes.PARENTHESIZED) {
            ChildAttributes childAttributes = super.getChildAttributes(newChildIndex);
            if (childAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/formatter/KotlinBlock", "getChildAttributes"));
            }
            return childAttributes;
        }
        List blocks = this.getSubBlocks();
        if (newChildIndex != 0) {
            boolean isIncomplete;
            boolean bl = isIncomplete = newChildIndex < blocks.size() ? ((Block)blocks.get(newChildIndex - 1)).isIncomplete() : this.isIncomplete();
            if (isIncomplete) {
                ChildAttributes childAttributes = super.getChildAttributes(newChildIndex);
                if (childAttributes == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/formatter/KotlinBlock", "getChildAttributes"));
                }
                return childAttributes;
            }
        }
        ChildAttributes childAttributes = new ChildAttributes(Indent.getNoneIndent(), null);
        if (childAttributes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/formatter/KotlinBlock", "getChildAttributes"));
        }
        return childAttributes;
    }

    public boolean isLeaf() {
        return this.myNode.getFirstChildNode() == null;
    }

    @NotNull
    private static WrappingStrategy getWrappingStrategyForItemList(int wrapType, final @NotNull IElementType itemType) {
        if (itemType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "itemType", "org/jetbrains/kotlin/idea/formatter/KotlinBlock", "getWrappingStrategyForItemList"));
        }
        final Wrap itemWrap = Wrap.createWrap((int)wrapType, (boolean)false);
        WrappingStrategy wrappingStrategy = new WrappingStrategy(){

            @Override
            @Nullable
            public Wrap getWrap(@NotNull IElementType childElementType) {
                if (childElementType == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childElementType", "org/jetbrains/kotlin/idea/formatter/KotlinBlock$1", "getWrap"));
                }
                return childElementType == itemType ? itemWrap : null;
            }
        };
        if (wrappingStrategy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/formatter/KotlinBlock", "getWrappingStrategyForItemList"));
        }
        return wrappingStrategy;
    }

    @NotNull
    private WrappingStrategy getWrappingStrategy() {
        IElementType parentElementType;
        CommonCodeStyleSettings commonSettings = this.mySettings.getCommonSettings((Language)KotlinLanguage.INSTANCE);
        IElementType elementType = this.myNode.getElementType();
        if (elementType == KtNodeTypes.VALUE_ARGUMENT_LIST) {
            WrappingStrategy wrappingStrategy = KotlinBlock.getWrappingStrategyForItemList(commonSettings.CALL_PARAMETERS_WRAP, KtNodeTypes.VALUE_ARGUMENT);
            if (wrappingStrategy == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/formatter/KotlinBlock", "getWrappingStrategy"));
            }
            return wrappingStrategy;
        }
        if (elementType == KtNodeTypes.VALUE_PARAMETER_LIST && ((parentElementType = this.myNode.getTreeParent().getElementType()) == KtNodeTypes.FUN || parentElementType == KtNodeTypes.CLASS)) {
            WrappingStrategy wrappingStrategy = KotlinBlock.getWrappingStrategyForItemList(commonSettings.METHOD_PARAMETERS_WRAP, KtNodeTypes.VALUE_PARAMETER);
            if (wrappingStrategy == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/formatter/KotlinBlock", "getWrappingStrategy"));
            }
            return wrappingStrategy;
        }
        WrappingStrategy.NoWrapping noWrapping = WrappingStrategy.NoWrapping.INSTANCE;
        if (noWrapping == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/formatter/KotlinBlock", "getWrappingStrategy"));
        }
        return noWrapping;
    }

    private NodeAlignmentStrategy getChildrenAlignmentStrategy() {
        final CommonCodeStyleSettings jetCommonSettings = this.mySettings.getCommonSettings((Language)KotlinLanguage.INSTANCE);
        KotlinCodeStyleSettings jetSettings = (KotlinCodeStyleSettings)this.mySettings.getCustomSettings(KotlinCodeStyleSettings.class);
        IElementType parentType = this.myNode.getElementType();
        if (parentType == KtNodeTypes.VALUE_PARAMETER_LIST) {
            return KotlinBlock.getAlignmentForChildInParenthesis(jetCommonSettings.ALIGN_MULTILINE_PARAMETERS, KtNodeTypes.VALUE_PARAMETER, KtTokens.COMMA, jetCommonSettings.ALIGN_MULTILINE_METHOD_BRACKETS, KtTokens.LPAR, KtTokens.RPAR);
        }
        if (parentType == KtNodeTypes.VALUE_ARGUMENT_LIST) {
            return KotlinBlock.getAlignmentForChildInParenthesis(jetCommonSettings.ALIGN_MULTILINE_PARAMETERS_IN_CALLS, KtNodeTypes.VALUE_ARGUMENT, KtTokens.COMMA, jetCommonSettings.ALIGN_MULTILINE_METHOD_BRACKETS, KtTokens.LPAR, KtTokens.RPAR);
        }
        if (parentType == KtNodeTypes.WHEN) {
            return KotlinBlock.getAlignmentForCaseBranch(jetSettings.ALIGN_IN_COLUMNS_CASE_BRANCH);
        }
        if (parentType == KtNodeTypes.WHEN_ENTRY) {
            return this.myAlignmentStrategy;
        }
        if (BINARY_EXPRESSIONS.contains(parentType) && ALIGN_FOR_BINARY_OPERATIONS.contains(KotlinBlock.getOperationType(this.getNode()))) {
            return NodeAlignmentStrategy.fromTypes(AlignmentStrategy.wrap((Alignment)KotlinBlock.createAlignment(jetCommonSettings.ALIGN_MULTILINE_BINARY_OPERATION, this.getAlignment()), (IElementType[])new IElementType[0]));
        }
        if (parentType == KtNodeTypes.SUPER_TYPE_LIST || parentType == KtNodeTypes.INITIALIZER_LIST) {
            return NodeAlignmentStrategy.fromTypes(AlignmentStrategy.wrap((Alignment)KotlinBlock.createAlignment(jetCommonSettings.ALIGN_MULTILINE_EXTENDS_LIST, this.getAlignment()), (IElementType[])new IElementType[0]));
        }
        if (parentType == KtNodeTypes.PARENTHESIZED) {
            return new NodeAlignmentStrategy(){
                Alignment bracketsAlignment;
                {
                    this.bracketsAlignment = jetCommonSettings.ALIGN_MULTILINE_BINARY_OPERATION ? Alignment.createAlignment() : null;
                }

                @Override
                @Nullable
                public Alignment getAlignment(@NotNull ASTNode childNode) {
                    if (childNode == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childNode", "org/jetbrains/kotlin/idea/formatter/KotlinBlock$2", "getAlignment"));
                    }
                    IElementType childNodeType = childNode.getElementType();
                    ASTNode prev2 = KotlinBlock.getPrevWithoutWhitespace(childNode);
                    if (prev2 != null && prev2.getElementType() == TokenType.ERROR_ELEMENT || childNodeType == TokenType.ERROR_ELEMENT) {
                        return this.bracketsAlignment;
                    }
                    if (childNodeType == KtTokens.LPAR || childNodeType == KtTokens.RPAR) {
                        return this.bracketsAlignment;
                    }
                    return null;
                }
            };
        }
        return NodeAlignmentStrategy.getNullStrategy();
    }

    private static NodeAlignmentStrategy getAlignmentForChildInParenthesis(boolean shouldAlignChild, final IElementType parameter, final IElementType delimiter, boolean shouldAlignParenthesis, final IElementType openBracket, final IElementType closeBracket) {
        final Alignment parameterAlignment = shouldAlignChild ? Alignment.createAlignment() : null;
        final Alignment bracketsAlignment = shouldAlignParenthesis ? Alignment.createAlignment() : null;
        return new NodeAlignmentStrategy(){

            @Override
            public Alignment getAlignment(@NotNull ASTNode node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/idea/formatter/KotlinBlock$3", "getAlignment"));
                }
                IElementType childNodeType = node.getElementType();
                ASTNode prev2 = KotlinBlock.getPrevWithoutWhitespace(node);
                if (prev2 != null && prev2.getElementType() == TokenType.ERROR_ELEMENT || childNodeType == TokenType.ERROR_ELEMENT) {
                    return parameterAlignment;
                }
                if (childNodeType == openBracket || childNodeType == closeBracket) {
                    return bracketsAlignment;
                }
                if (childNodeType == parameter || childNodeType == delimiter) {
                    return parameterAlignment;
                }
                return null;
            }
        };
    }

    private static NodeAlignmentStrategy getAlignmentForCaseBranch(boolean shouldAlignInColumns) {
        if (shouldAlignInColumns) {
            return NodeAlignmentStrategy.fromTypes((AlignmentStrategy)AlignmentStrategy.createAlignmentPerTypeStrategy(Arrays.asList(new IElementType[]{KtTokens.ARROW}), (IElementType)KtNodeTypes.WHEN_ENTRY, (boolean)true));
        }
        return NodeAlignmentStrategy.getNullStrategy();
    }

    @Nullable
    protected static Indent createChildIndent(@NotNull ASTNode child) {
        ASTNode prev2;
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "org/jetbrains/kotlin/idea/formatter/KotlinBlock", "createChildIndent"));
        }
        ASTNode childParent = child.getTreeParent();
        IElementType childType = child.getElementType();
        if (childParent != null && childParent.getTreeParent() != null && childParent.getElementType() == KtNodeTypes.BLOCK && childParent.getTreeParent().getElementType() == KtNodeTypes.SCRIPT) {
            return Indent.getNoneIndent();
        }
        if (childParent != null && childParent.getPsi() instanceof KtDeclaration && (prev2 = KotlinBlock.getPrevWithoutWhitespace(child)) != null && KtTokens.COMMENTS.contains(prev2.getElementType()) && KotlinBlock.getPrevWithoutWhitespaceAndComments(prev2) == null) {
            return Indent.getNoneIndent();
        }
        for (NodeIndentStrategy strategy : INDENT_RULES) {
            Indent indent = strategy.getIndent(child);
            if (indent == null) continue;
            return indent;
        }
        if (childParent != null) {
            IElementType parentType = childParent.getElementType();
            if (parentType == KtNodeTypes.VALUE_PARAMETER_LIST || parentType == KtNodeTypes.VALUE_ARGUMENT_LIST) {
                ASTNode prev3 = KotlinBlock.getPrevWithoutWhitespace(child);
                if (childType == KtTokens.RPAR && (prev3 == null || prev3.getElementType() != TokenType.ERROR_ELEMENT)) {
                    return Indent.getNoneIndent();
                }
                return Indent.getContinuationWithoutFirstIndent();
            }
            if (parentType == KtNodeTypes.TYPE_PARAMETER_LIST || parentType == KtNodeTypes.TYPE_ARGUMENT_LIST) {
                return Indent.getContinuationWithoutFirstIndent();
            }
        }
        return Indent.getNoneIndent();
    }

    @Nullable
    private static Alignment createAlignment(boolean alignOption, @Nullable Alignment defaultAlignment) {
        return alignOption ? KotlinBlock.createAlignmentOrDefault(null, defaultAlignment) : defaultAlignment;
    }

    @Nullable
    private static Alignment createAlignmentOrDefault(@Nullable Alignment base, @Nullable Alignment defaultAlignment) {
        if (defaultAlignment == null) {
            return base == null ? Alignment.createAlignment() : Alignment.createChildAlignment((Alignment)base);
        }
        return defaultAlignment;
    }

    private static int findNodeBlockIndex(List<Block> blocks, final TokenSet tokenSet) {
        return ContainerUtil.indexOf(blocks, (Condition)new Condition<Block>(){

            public boolean value(Block block) {
                if (!(block instanceof ASTBlock)) {
                    return false;
                }
                ASTNode node = ((ASTBlock)block).getNode();
                return node != null && tokenSet.contains(node.getElementType());
            }
        });
    }

    @Nullable
    private static IElementType getOperationType(ASTNode node) {
        ASTNode operationNode = node.findChildByType((IElementType)KtNodeTypes.OPERATION_REFERENCE);
        return operationNode != null ? operationNode.getFirstChildNode().getElementType() : null;
    }
}

