/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.render;

import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.ui.impl.watch.MessageDescriptor;
import com.intellij.debugger.ui.impl.watch.NodeManagerImpl;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.debugger.ui.tree.FieldDescriptor;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.debugger.ui.tree.NodeDescriptorFactory;
import com.intellij.debugger.ui.tree.NodeManager;
import com.intellij.debugger.ui.tree.render.ChildrenBuilder;
import com.intellij.debugger.ui.tree.render.ClassRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.settings.XDebuggerSettingsManager;
import com.sun.jdi.Field;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.KotlinDebuggerSettings;
import org.jetbrains.kotlin.idea.debugger.render.DelegatedPropertyFieldDescriptor;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/render/KotlinClassWithDelegatedPropertyRenderer;", "Lcom/intellij/debugger/ui/tree/render/ClassRenderer;", "()V", "buildChildren", "", "value", "Lcom/sun/jdi/Value;", "builder", "Lcom/intellij/debugger/ui/tree/render/ChildrenBuilder;", "context", "Lcom/intellij/debugger/engine/evaluation/EvaluationContext;", "isApplicable", "", "jdiType", "Lcom/sun/jdi/Type;", "idea"})
public final class KotlinClassWithDelegatedPropertyRenderer
extends ClassRenderer {
    public boolean isApplicable(@Nullable Type jdiType) {
        boolean bl;
        block3: {
            if (!super.isApplicable(jdiType)) {
                return false;
            }
            if (!(jdiType instanceof ReferenceType)) {
                return false;
            }
            Iterable $receiver$iv = ((ReferenceType)jdiType).allFields();
            for (Object element$iv : $receiver$iv) {
                Field it = (Field)element$iv;
                if (!StringsKt.endsWith$default((String)it.name(), (String)"$delegate", (boolean)false, (int)2, null)) continue;
                bl = true;
                break block3;
            }
            bl = false;
        }
        return bl;
    }

    public void buildChildren(@Nullable Value value2, @NotNull ChildrenBuilder builder, @NotNull EvaluationContext context) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (!(value2 instanceof ObjectReference)) {
            return;
        }
        NodeManager nodeManager = builder.getNodeManager();
        if (nodeManager == null) {
            Intrinsics.throwNpe();
        }
        NodeManager nodeManager2 = nodeManager;
        NodeDescriptorFactory nodeDescriptorFactory = builder.getDescriptorManager();
        if (nodeDescriptorFactory == null) {
            Intrinsics.throwNpe();
        }
        NodeDescriptorFactory nodeDescriptorFactory2 = nodeDescriptorFactory;
        List<Field> fields = ((ObjectReference)value2).referenceType().allFields();
        if (fields.isEmpty()) {
            builder.setChildren(CollectionsKt.listOf((Object)nodeManager2.createMessageNode(MessageDescriptor.CLASS_HAS_NO_FIELDS.getLabel())));
            return;
        }
        ArrayList<DebuggerTreeNode> children2 = new ArrayList<DebuggerTreeNode>();
        for (Field field2 : fields) {
            if (!this.shouldDisplay(context, (ObjectReference)value2, field2)) continue;
            FieldDescriptor fieldDescriptor = nodeDescriptorFactory2.getFieldDescriptor((NodeDescriptor)builder.getParentDescriptor(), (ObjectReference)value2, field2);
            if (StringsKt.endsWith$default((String)field2.name(), (String)"$delegate", (boolean)false, (int)2, null)) {
                boolean shouldRenderDelegatedProperty = KotlinDebuggerSettings.Companion.getInstance().getDEBUG_RENDER_DELEGATED_PROPERTIES();
                if (shouldRenderDelegatedProperty) {
                    children2.add(nodeManager2.createNode((NodeDescriptor)fieldDescriptor, context));
                }
                Project project = context.getDebugProcess().getProject();
                if (project == null) {
                    Intrinsics.throwNpe();
                }
                ObjectReference objectReference = (ObjectReference)value2;
                Field field3 = field2;
                Intrinsics.checkExpressionValueIsNotNull((Object)field3, (String)"field");
                DelegatedPropertyFieldDescriptor delegatedPropertyDescriptor = new DelegatedPropertyFieldDescriptor(project, objectReference, field3, shouldRenderDelegatedProperty);
                children2.add(nodeManager2.createNode((NodeDescriptor)delegatedPropertyDescriptor, context));
                continue;
            }
            children2.add(nodeManager2.createNode((NodeDescriptor)fieldDescriptor, context));
        }
        XDebuggerSettingsManager xDebuggerSettingsManager = XDebuggerSettingsManager.getInstance();
        if (xDebuggerSettingsManager == null) {
            Intrinsics.throwNpe();
        }
        if (xDebuggerSettingsManager.getDataViewSettings().isSortValues()) {
            Iterable iterable = children2;
            Comparator comparator = NodeManagerImpl.getNodeComparator();
            Intrinsics.checkExpressionValueIsNotNull((Object)comparator, (String)"NodeManagerImpl.getNodeComparator()");
            CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator);
        }
        builder.setChildren((List)children2);
    }
}

