/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ModuleRootAdapter;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.HyperlinkLabel;
import java.awt.Component;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.KotlinProjectConfigurator;
import org.jetbrains.kotlin.idea.configuration.KotlinSetupEnvironmentNotificationProvider$Companion$createSetupSdkPanel$;
import org.jetbrains.kotlin.idea.project.ProjectStructureUtil;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.idea.versions.UnsupportedAbiVersionNotificationPanelProvider;
import org.jetbrains.kotlin.idea.versions.UnsupportedAbiVersionNotificationPanelProviderKt;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000fB\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010\b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000eH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinSetupEnvironmentNotificationProvider;", "Lcom/intellij/ui/EditorNotifications$Provider;", "Lcom/intellij/ui/EditorNotificationPanel;", "myProject", "Lcom/intellij/openapi/project/Project;", "notifications", "Lcom/intellij/ui/EditorNotifications;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ui/EditorNotifications;)V", "createNotificationPanel", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "getKey", "Lcom/intellij/openapi/util/Key;", "Companion", "idea"})
public final class KotlinSetupEnvironmentNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    private final Project myProject;
    private static final Key<EditorNotificationPanel> KEY;
    public static final Companion Companion;

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        Key key = KotlinSetupEnvironmentNotificationProvider.Companion.getKEY();
        Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"KEY");
        return key;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)fileEditor, (String)"fileEditor");
        if (Intrinsics.areEqual((Object)file.getFileType(), (Object)((Object)KotlinFileType.INSTANCE)) ^ true) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file);
        if (psiFile == null) {
            return null;
        }
        PsiFile psiFile2 = psiFile;
        if (psiFile2.getLanguage() != KotlinLanguage.INSTANCE) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)psiFile2));
        if (module == null) {
            return null;
        }
        Module module2 = module;
        if (!ModuleRootManager.getInstance((Module)module2).getFileIndex().isInSourceContent(file)) {
            return null;
        }
        if (ModuleRootManager.getInstance((Module)module2).getSdk() == null) {
            PsiFile psiFile3 = psiFile2;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiFile3, (String)"psiFile");
            return KotlinSetupEnvironmentNotificationProvider.Companion.createSetupSdkPanel(this.myProject, psiFile3);
        }
        if (!ProjectStructureUtil.hasKotlinRuntimeInScope(module2)) {
            Module module3 = module2;
            Intrinsics.checkExpressionValueIsNotNull((Object)module3, (String)"module");
            if (UnsupportedAbiVersionNotificationPanelProvider.Companion.collectBadRoots(module3).isEmpty()) {
                Module module4 = module2;
                Intrinsics.checkExpressionValueIsNotNull((Object)module4, (String)"module");
                return KotlinSetupEnvironmentNotificationProvider.Companion.createKotlinNotConfiguredPanel(module4);
            }
        }
        return null;
    }

    public KotlinSetupEnvironmentNotificationProvider(@NotNull Project myProject, final @NotNull EditorNotifications notifications) {
        Intrinsics.checkParameterIsNotNull((Object)myProject, (String)"myProject");
        Intrinsics.checkParameterIsNotNull((Object)notifications, (String)"notifications");
        this.myProject = myProject;
        this.myProject.getMessageBus().connect((Disposable)this.myProject).subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootAdapter(){

            public void rootsChanged(@Nullable ModuleRootEvent event) {
                notifications.updateAllNotifications();
            }
        });
    }

    static {
        Companion = new Companion(null);
        KEY = Key.create((String)"Setup SDK");
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R8\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinSetupEnvironmentNotificationProvider$Companion;", "", "()V", "KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/ui/EditorNotificationPanel;", "kotlin.jvm.PlatformType", "getKEY", "()Lcom/intellij/openapi/util/Key;", "createConfiguratorsPopup", "Lcom/intellij/openapi/ui/popup/ListPopup;", "project", "Lcom/intellij/openapi/project/Project;", "configurators", "", "Lorg/jetbrains/kotlin/idea/configuration/KotlinProjectConfigurator;", "createKotlinNotConfiguredPanel", "module", "Lcom/intellij/openapi/module/Module;", "createSetupSdkPanel", "file", "Lcom/intellij/psi/PsiFile;", "idea"})
    public static final class Companion {
        private final Key<EditorNotificationPanel> getKEY() {
            return KEY;
        }

        /*
         * WARNING - void declaration
         */
        private final EditorNotificationPanel createSetupSdkPanel(Project project, PsiFile file) {
            void var3_3;
            EditorNotificationPanel $receiver$iv = new EditorNotificationPanel();
            EditorNotificationPanel $receiver = $receiver$iv;
            $receiver.setText(ProjectBundle.message((String)"project.sdk.not.defined", (Object[])new Object[0]));
            $receiver.createActionLabel(ProjectBundle.message((String)"project.sdk.setup", (Object[])new Object[0]), new Runnable(project, file){
                final /* synthetic */ Project $project$inlined;
                final /* synthetic */ PsiFile $file$inlined;

                public final void run() {
                    if (ProjectSettingsService.getInstance((Project)this.$project$inlined).chooseAndSetSdk() == null) {
                        return;
                    }
                    ApplicationUtilsKt.runWriteAction((Function0)new Function0<Unit>(this){
                        final /* synthetic */ Companion$createSetupSdkPanel$$inlined$apply$lambda$1 this$0;

                        public final void invoke() {
                            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)this.this$0.$file$inlined));
                            if (module != null) {
                                ModuleRootModificationUtil.setSdkInherited((Module)module);
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            super(0);
                        }
                    });
                }
                {
                    this.$project$inlined = project;
                    this.$file$inlined = psiFile;
                }
            });
            return (EditorNotificationPanel)var3_3;
        }

        /*
         * WARNING - void declaration
         */
        private final EditorNotificationPanel createKotlinNotConfiguredPanel(Module module) {
            void var2_2;
            EditorNotificationPanel $receiver$iv = new EditorNotificationPanel();
            EditorNotificationPanel $receiver = $receiver$iv;
            $receiver.setText("Kotlin not configured");
            List configurators = CollectionsKt.toList((Iterable)ConfigureKotlinInProjectUtilsKt.getApplicableConfigurators(module));
            if (!configurators.isEmpty()) {
                UnsupportedAbiVersionNotificationPanelProviderKt.createComponentActionLabel($receiver, "Configure", (Function1<? super HyperlinkLabel, Unit>)((Function1)new Function1<HyperlinkLabel, Unit>(configurators, module){
                    final /* synthetic */ List $configurators;
                    final /* synthetic */ Module $module$inlined;

                    public final void invoke(HyperlinkLabel label) {
                        Project project = this.$module$inlined.getProject();
                        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"module.project");
                        ListPopup configuratorsPopup = KotlinSetupEnvironmentNotificationProvider.Companion.createConfiguratorsPopup(project, this.$configurators);
                        configuratorsPopup.showUnderneathOf((Component)label);
                    }
                    {
                        this.$configurators = list2;
                        this.$module$inlined = module;
                        super(1);
                    }
                }));
            }
            return (EditorNotificationPanel)var2_2;
        }

        @NotNull
        public final ListPopup createConfiguratorsPopup(@NotNull Project project, @NotNull List<? extends KotlinProjectConfigurator> configurators) {
            ListPopup configuratorsPopup;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull(configurators, (String)"configurators");
            BaseListPopupStep<KotlinProjectConfigurator> step2 = new BaseListPopupStep<KotlinProjectConfigurator>(project, "Choose Configurator", configurators){
                final /* synthetic */ Project $project;

                @NotNull
                public String getTextFor(@Nullable KotlinProjectConfigurator value2) {
                    Object object = value2;
                    if (object == null || (object = object.getPresentableText()) == null) {
                        object = "<none>";
                    }
                    return object;
                }

                @Nullable
                public PopupStep<?> onChosen(@Nullable KotlinProjectConfigurator selectedValue, boolean finalChoice) {
                    Unit unit;
                    KotlinProjectConfigurator kotlinProjectConfigurator = selectedValue;
                    if (kotlinProjectConfigurator != null) {
                        KotlinProjectConfigurator $receiver$iv = kotlinProjectConfigurator;
                        KotlinProjectConfigurator it = $receiver$iv;
                        it.configure(this.$project, CollectionsKt.emptyList());
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    return null;
                }
                {
                    this.$project = $captured_local_variable$0;
                    super($super_call_param$1, $super_call_param$2);
                }
            };
            ListPopup listPopup = configuratorsPopup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)step2);
            Intrinsics.checkExpressionValueIsNotNull((Object)listPopup, (String)"configuratorsPopup");
            return listPopup;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

