/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea;

import com.intellij.ide.IconProvider;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.RowIcon;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.KtLightClassForExplicitDeclaration;
import org.jetbrains.kotlin.asJava.KtLightClassForFacade;
import org.jetbrains.kotlin.idea.KotlinIcons;
import org.jetbrains.kotlin.idea.caches.resolve.KtLightClassForDecompiledDeclaration;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiUtil;

public class KotlinIconProvider
extends IconProvider
implements DumbAware {
    public static KotlinIconProvider INSTANCE = new KotlinIconProvider();

    @Nullable
    public static KtClassOrObject getMainClass(@NotNull KtFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/KotlinIconProvider", "getMainClass"));
        }
        List classes2 = ContainerUtil.filter(file.getDeclarations(), (Condition)new Condition<KtDeclaration>(){

            public boolean value(KtDeclaration jetDeclaration) {
                return jetDeclaration instanceof KtClassOrObject;
            }
        });
        if (classes2.size() == 1 && StringUtil.getPackageName((String)file.getName()).equals(((KtDeclaration)classes2.get(0)).getName())) {
            return (KtClassOrObject)classes2.get(0);
        }
        return null;
    }

    public Icon getIcon(@NotNull PsiElement psiElement, int flags) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "org/jetbrains/kotlin/idea/KotlinIconProvider", "getIcon"));
        }
        if (psiElement instanceof KtFile) {
            KtFile file = (KtFile)psiElement;
            KtClassOrObject mainClass = KotlinIconProvider.getMainClass(file);
            return mainClass != null && file.getDeclarations().size() == 1 ? this.getIcon(mainClass, flags) : KotlinIcons.FILE;
        }
        Icon result2 = KotlinIconProvider.getBaseIcon(psiElement);
        if ((flags & 1) > 0 && psiElement instanceof KtModifierListOwner) {
            KtModifierList list2 = ((KtModifierListOwner)psiElement).getModifierList();
            result2 = KotlinIconProvider.createRowIcon(result2, KotlinIconProvider.getVisibilityIcon(list2));
        }
        return result2;
    }

    private static RowIcon createRowIcon(Icon baseIcon, Icon visibilityIcon) {
        RowIcon rowIcon = new RowIcon(2);
        rowIcon.setIcon(baseIcon, 0);
        rowIcon.setIcon(visibilityIcon, 1);
        return rowIcon;
    }

    public static Icon getVisibilityIcon(@Nullable KtModifierList list2) {
        if (list2 != null) {
            if (list2.hasModifier(KtTokens.PRIVATE_KEYWORD)) {
                return PlatformIcons.PRIVATE_ICON;
            }
            if (list2.hasModifier(KtTokens.PROTECTED_KEYWORD)) {
                return PlatformIcons.PROTECTED_ICON;
            }
            if (list2.hasModifier(KtTokens.INTERNAL_KEYWORD)) {
                return PlatformIcons.PACKAGE_LOCAL_ICON;
            }
        }
        return PlatformIcons.PUBLIC_ICON;
    }

    public static Icon getBaseIcon(PsiElement psiElement) {
        if (psiElement instanceof KtPackageDirective) {
            return PlatformIcons.PACKAGE_ICON;
        }
        if (psiElement instanceof KtLightClassForFacade) {
            return KotlinIcons.FILE;
        }
        if (psiElement instanceof KtLightClassForDecompiledDeclaration) {
            KtClassOrObject origin = ((KtLightClassForDecompiledDeclaration)psiElement).getOrigin();
            if (origin != null) {
                psiElement = origin;
            } else {
                return KotlinIcons.CLASS;
            }
        }
        if (psiElement instanceof KtLightClassForExplicitDeclaration) {
            psiElement = psiElement.getNavigationElement();
        }
        if (psiElement instanceof KtNamedFunction) {
            if (((KtFunction)psiElement).getReceiverTypeReference() != null) {
                return KotlinIcons.EXTENSION_FUNCTION;
            }
            if (PsiTreeUtil.getParentOfType((PsiElement)psiElement, KtNamedDeclaration.class) instanceof KtClass) {
                if (KtPsiUtil.isAbstract((KtFunction)psiElement)) {
                    return PlatformIcons.ABSTRACT_METHOD_ICON;
                }
                return PlatformIcons.METHOD_ICON;
            }
            return KotlinIcons.FUNCTION;
        }
        if (psiElement instanceof KtFunctionLiteral) {
            return KotlinIcons.LAMBDA;
        }
        if (psiElement instanceof KtClass) {
            KtEnumEntry enumEntry;
            Icon icon;
            KtClass ktClass = (KtClass)psiElement;
            if (ktClass.isInterface()) {
                return KotlinIcons.TRAIT;
            }
            Icon icon2 = icon = ktClass.isEnum() ? KotlinIcons.ENUM : KotlinIcons.CLASS;
            if (ktClass instanceof KtEnumEntry && (enumEntry = (KtEnumEntry)ktClass).getPrimaryConstructorParameterList() == null) {
                icon = KotlinIcons.ENUM;
            }
            return icon;
        }
        if (psiElement instanceof KtObjectDeclaration) {
            return KotlinIcons.OBJECT;
        }
        if (psiElement instanceof KtParameter) {
            KtParameter parameter = (KtParameter)psiElement;
            if (KtPsiUtil.getClassIfParameterIsProperty(parameter) != null) {
                return parameter.isMutable() ? KotlinIcons.FIELD_VAR : KotlinIcons.FIELD_VAL;
            }
            return KotlinIcons.PARAMETER;
        }
        if (psiElement instanceof KtProperty) {
            KtProperty property2 = (KtProperty)psiElement;
            return property2.isVar() ? KotlinIcons.FIELD_VAR : KotlinIcons.FIELD_VAL;
        }
        return null;
    }
}

