/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.container;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.container.CacheKt;
import org.jetbrains.kotlin.container.ClassInfo;
import org.jetbrains.kotlin.container.ClassTraversalCache;
import org.jetbrains.kotlin.container.ConstructorInfo;
import org.jetbrains.kotlin.container.SetterInfo;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u00006\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u0002\u001a\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tH\u0002\u001a\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\tH\u0002\u001a\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000b2\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tH\u0002\u001a\u0014\u0010\u000f\u001a\u00020\u00102\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tH\u0002\u001a\u000e\u0010\u0011\u001a\u00020\u0010*\u0006\u0012\u0002\b\u00030\t\u00a8\u0006\u0012"}, d2={"collectInterfacesRecursive", "", "type", "Ljava/lang/reflect/Type;", "result", "", "getConstructorInfo", "Lorg/jetbrains/kotlin/container/ConstructorInfo;", "c", "Ljava/lang/Class;", "getRegistrations", "", "klass", "getSetterInfos", "Lorg/jetbrains/kotlin/container/SetterInfo;", "traverseClass", "Lorg/jetbrains/kotlin/container/ClassInfo;", "getInfo", "container"})
public final class CacheKt {
    @NotNull
    public static final ClassInfo getInfo(Class<?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        return ClassTraversalCache.INSTANCE.getClassInfo($receiver);
    }

    private static final ClassInfo traverseClass(Class<?> c) {
        return new ClassInfo(CacheKt.getConstructorInfo(c), CacheKt.getSetterInfos(c), CacheKt.getRegistrations(c));
    }

    private static final List<SetterInfo> getSetterInfos(Class<?> c) {
        ArrayList<SetterInfo> setterInfos = new ArrayList<SetterInfo>();
        Method[] methodArray = c.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            Annotation[] annotationArray = method.getDeclaredAnnotations();
            for (int j = 0; j < annotationArray.length; ++j) {
                Annotation annotation2 = annotationArray[j];
                if (!StringsKt.endsWith$default((String)JvmClassMappingKt.getJavaClass((KClass)JvmClassMappingKt.getAnnotationClass((Annotation)annotation2)).getName(), (String)".Inject", (boolean)false, (int)2, null)) continue;
                Method method2 = method;
                Intrinsics.checkExpressionValueIsNotNull((Object)method2, (String)"method");
                setterInfos.add(new SetterInfo(method2, ArraysKt.toList((Object[])method.getGenericParameterTypes())));
            }
        }
        return setterInfos;
    }

    private static final ConstructorInfo getConstructorInfo(Class<?> c) {
        Constructor constructor;
        boolean hasSinglePublicConstructor;
        boolean bl;
        if (Modifier.isAbstract(c.getModifiers()) || c.isPrimitive()) {
            return null;
        }
        Constructor<?>[] constructors2 = c.getConstructors();
        Constructor constructor2 = (Constructor)ArraysKt.singleOrNull((Object[])constructors2);
        if (constructor2 != null) {
            Constructor $receiver$iv = constructor2;
            Constructor it = $receiver$iv;
            bl = Modifier.isPublic(it.getModifiers());
        } else {
            bl = hasSinglePublicConstructor = false;
        }
        if (!hasSinglePublicConstructor) {
            return null;
        }
        Constructor constructor3 = constructor = (Constructor)ArraysKt.single((Object[])constructors2);
        Intrinsics.checkExpressionValueIsNotNull((Object)constructor3, (String)"constructor");
        return new ConstructorInfo(constructor3, ArraysKt.toList((Object[])constructor.getGenericParameterTypes()));
    }

    private static final void collectInterfacesRecursive(Type type2, Set<Type> result2) {
        Unit unit;
        Type[] klass;
        Object object;
        Type type3 = type2;
        if (type3 instanceof Class) {
            object = (Type[])type2;
        } else if (type3 instanceof ParameterizedType) {
            Type type4 = ((ParameterizedType)type2).getRawType();
            if (!(type4 instanceof Class)) {
                type4 = null;
            }
            object = (Class)type4;
        } else {
            object = null;
        }
        Type[] typeArray = klass = object;
        if (klass != null && (typeArray = typeArray.getGenericInterfaces()) != null) {
            Object[] $receiver$iv = typeArray;
            for (int i = 0; i < $receiver$iv.length; ++i) {
                Type it;
                Object element$iv = $receiver$iv[i];
                Type type5 = it = (Type)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)type5, (String)"it");
                if (!result2.add(type5)) continue;
                Type type6 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)type6, (String)"it");
                CacheKt.collectInterfacesRecursive(type6, result2);
            }
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final List<Type> getRegistrations(Class<?> klass) {
        void $receiver$iv;
        ArrayList registrations = new ArrayList();
        Sequence superClasses2 = SequencesKt.generateSequence(klass, (Function1)getRegistrations.superClasses.1.INSTANCE);
        CollectionsKt.addAll((Collection)registrations, (Sequence)superClasses2);
        LinkedHashSet interfaces = new LinkedHashSet();
        Sequence sequence2 = superClasses2;
        for (Object element$iv : $receiver$iv) {
            Type it = (Type)element$iv;
            CacheKt.collectInterfacesRecursive(it, interfaces);
        }
        registrations.addAll(interfaces);
        registrations.remove(Object.class);
        return registrations;
    }

    @NotNull
    public static final /* synthetic */ ClassInfo access$traverseClass(@NotNull Class c) {
        return CacheKt.traverseClass(c);
    }
}

