/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cfg.Label;
import org.jetbrains.kotlin.cfg.pseudocode.PseudoValue;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.Instruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.InstructionImpl;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.InstructionVisitor;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.InstructionVisitorWithResult;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.KtElementInstructionImpl;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.LexicalScope;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.JumpInstruction;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\f\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016J!\u0010%\u001a\u0002H)\"\u0004\b\u0000\u0010)2\f\u0010'\u001a\b\u0012\u0004\u0012\u0002H)0*H\u0016\u00a2\u0006\u0002\u0010+J\u0014\u0010,\u001a\u00020\u000e2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00070.J\b\u0010/\u001a\u000200H\u0014J\u0016\u0010/\u001a\u0002002\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J\u0016\u00101\u001a\u00020&2\u0006\u00102\u001a\u00020\u00072\u0006\u00103\u001a\u00020\u000eJ\b\u00104\u001a\u000205H\u0016R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000e0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R$\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u000e8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u001d\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000e0!8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0015\u00a8\u00066"}, d2={"Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/jumps/NondeterministicJumpInstruction;", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/KtElementInstructionImpl;", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/jumps/JumpInstruction;", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "targetLabels", "", "Lorg/jetbrains/kotlin/cfg/Label;", "lexicalScope", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/LexicalScope;", "inputValue", "Lorg/jetbrains/kotlin/cfg/pseudocode/PseudoValue;", "(Lorg/jetbrains/kotlin/psi/KtElement;Ljava/util/List;Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/LexicalScope;Lorg/jetbrains/kotlin/cfg/pseudocode/PseudoValue;)V", "_next", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/Instruction;", "_resolvedTargets", "", "getInputValue", "()Lorg/jetbrains/kotlin/cfg/pseudocode/PseudoValue;", "inputValues", "getInputValues", "()Ljava/util/List;", "value", "next", "getNext", "()Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/Instruction;", "setNext", "(Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/Instruction;)V", "nextInstructions", "", "getNextInstructions", "()Ljava/util/Collection;", "resolvedTargets", "", "getResolvedTargets", "()Ljava/util/Map;", "getTargetLabels", "accept", "", "visitor", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/InstructionVisitor;", "R", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/InstructionVisitorWithResult;", "(Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/InstructionVisitorWithResult;)Ljava/lang/Object;", "copy", "newTargetLabels", "", "createCopy", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/InstructionImpl;", "setResolvedTarget", "label", "resolvedTarget", "toString", "", "frontend"})
public final class NondeterministicJumpInstruction
extends KtElementInstructionImpl
implements JumpInstruction {
    private Instruction _next;
    private final Map<Label, Instruction> _resolvedTargets;
    @NotNull
    private final List<Label> targetLabels;
    @Nullable
    private final PseudoValue inputValue;

    @NotNull
    public final List<Label> getTargetLabels() {
        return this.targetLabels;
    }

    @NotNull
    public final Map<Label, Instruction> getResolvedTargets() {
        return this._resolvedTargets;
    }

    /*
     * WARNING - void declaration
     */
    public final void setResolvedTarget(@NotNull Label label, @NotNull Instruction resolvedTarget) {
        void value$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)label, (String)"label");
        Intrinsics.checkParameterIsNotNull((Object)resolvedTarget, (String)"resolvedTarget");
        Map<Label, Instruction> map2 = this._resolvedTargets;
        Instruction instruction = this.outgoingEdgeTo(resolvedTarget);
        if (instruction == null) {
            Intrinsics.throwNpe();
        }
        Instruction instruction2 = instruction;
        $receiver$iv.put(label, value$iv);
    }

    @NotNull
    public final Instruction getNext() {
        Instruction instruction = this._next;
        if (instruction == null) {
            Intrinsics.throwNpe();
        }
        return instruction;
    }

    public final void setNext(@NotNull Instruction value2) {
        Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
        this._next = this.outgoingEdgeTo(value2);
    }

    @Override
    @NotNull
    public Collection<Instruction> getNextInstructions() {
        ArrayList targetInstructions = Lists.newArrayList((Iterable)this.getResolvedTargets().values());
        targetInstructions.add(this.getNext());
        Collection collection = targetInstructions;
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"targetInstructions");
        return collection;
    }

    @Override
    @NotNull
    public List<PseudoValue> getInputValues() {
        return CollectionsKt.emptyOrSingletonList(this.inputValue);
    }

    @Override
    public void accept(@NotNull InstructionVisitor visitor2) {
        Intrinsics.checkParameterIsNotNull((Object)visitor2, (String)"visitor");
        visitor2.visitNondeterministicJump(this);
    }

    @Override
    public <R> R accept(@NotNull InstructionVisitorWithResult<R> visitor2) {
        Intrinsics.checkParameterIsNotNull(visitor2, (String)"visitor");
        return visitor2.visitNondeterministicJump(this);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String toString() {
        void destination$iv$iv;
        void $receiver$iv$iv;
        String inVal = this.inputValue != null ? "|" + this.inputValue : "";
        Iterable $receiver$iv = this.targetLabels;
        Iterable iterable = $receiver$iv;
        Collection collection = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            Label label = (Label)item$iv$iv;
            void var12_8 = destination$iv$iv;
            String string = it.getName();
            var12_8.add(string);
        }
        String labels = kotlin.collections.CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
        return "jmp?(" + labels + inVal + ")";
    }

    @Override
    @NotNull
    protected InstructionImpl createCopy() {
        return this.createCopy(this.targetLabels);
    }

    @NotNull
    public final Instruction copy(@NotNull List<Label> newTargetLabels) {
        Intrinsics.checkParameterIsNotNull(newTargetLabels, (String)"newTargetLabels");
        return this.updateCopyInfo(this.createCopy(newTargetLabels));
    }

    private final InstructionImpl createCopy(List<? extends Label> newTargetLabels) {
        return new NondeterministicJumpInstruction(this.getElement(), newTargetLabels, this.getLexicalScope(), this.inputValue);
    }

    @Nullable
    public final PseudoValue getInputValue() {
        return this.inputValue;
    }

    public NondeterministicJumpInstruction(@NotNull KtElement element2, @NotNull List<? extends Label> targetLabels, @NotNull LexicalScope lexicalScope, @Nullable PseudoValue inputValue) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        Intrinsics.checkParameterIsNotNull(targetLabels, (String)"targetLabels");
        Intrinsics.checkParameterIsNotNull((Object)lexicalScope, (String)"lexicalScope");
        super(element2, lexicalScope);
        this.inputValue = inputValue;
        LinkedHashMap linkedHashMap = Maps.newLinkedHashMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)linkedHashMap, (String)"Maps.newLinkedHashMap()");
        this._resolvedTargets = linkedHashMap;
        ArrayList arrayList = Lists.newArrayList((Iterable)targetLabels);
        Intrinsics.checkExpressionValueIsNotNull((Object)arrayList, (String)"Lists.newArrayList(targetLabels)");
        this.targetLabels = arrayList;
    }
}

