/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.builtins;

import com.google.protobuf.ExtensionRegistryLite;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.serialization.SerializedResourcePaths;
import org.jetbrains.kotlin.serialization.builtins.BuiltInsProtoBuf;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/builtins/BuiltInsSerializedResourcePaths;", "Lorg/jetbrains/kotlin/serialization/SerializedResourcePaths;", "()V", "BUILTINS_FILE_EXTENSION", "", "getBUILTINS_FILE_EXTENSION", "()Ljava/lang/String;", "CLASS_METADATA_FILE_EXTENSION", "getCLASS_METADATA_FILE_EXTENSION", "PACKAGE_FILE_EXTENSION", "getPACKAGE_FILE_EXTENSION", "STRING_TABLE_FILE_EXTENSION", "getSTRING_TABLE_FILE_EXTENSION", "extensionRegistry", "Lcom/google/protobuf/ExtensionRegistryLite;", "getExtensionRegistry", "()Lcom/google/protobuf/ExtensionRegistryLite;", "getBuiltInsFilePath", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "getClassMetadataPath", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "getPackageFilePath", "getStringTableFilePath", "packageFqNameToPath", "shortName", "descriptors"})
public final class BuiltInsSerializedResourcePaths
implements SerializedResourcePaths {
    @NotNull
    private static final ExtensionRegistryLite extensionRegistry;
    @NotNull
    private static final String CLASS_METADATA_FILE_EXTENSION = "kotlin_class";
    @NotNull
    private static final String PACKAGE_FILE_EXTENSION = "kotlin_package";
    @NotNull
    private static final String STRING_TABLE_FILE_EXTENSION = "kotlin_string_table";
    @NotNull
    private static final String BUILTINS_FILE_EXTENSION = "kotlin_builtins";
    public static final BuiltInsSerializedResourcePaths INSTANCE;

    @Override
    @NotNull
    public ExtensionRegistryLite getExtensionRegistry() {
        return extensionRegistry;
    }

    @NotNull
    public final String getCLASS_METADATA_FILE_EXTENSION() {
        return CLASS_METADATA_FILE_EXTENSION;
    }

    @NotNull
    public final String getPACKAGE_FILE_EXTENSION() {
        return PACKAGE_FILE_EXTENSION;
    }

    @NotNull
    public final String getSTRING_TABLE_FILE_EXTENSION() {
        return STRING_TABLE_FILE_EXTENSION;
    }

    @NotNull
    public final String getBUILTINS_FILE_EXTENSION() {
        return BUILTINS_FILE_EXTENSION;
    }

    @Override
    @NotNull
    public String getClassMetadataPath(@NotNull ClassId classId) {
        Intrinsics.checkParameterIsNotNull((Object)classId, (String)"classId");
        StringBuilder stringBuilder = new StringBuilder();
        FqName fqName2 = classId.getPackageFqName();
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"classId.packageFqName");
        return stringBuilder.append(this.packageFqNameToPath(fqName2)).append("/").append(classId.getRelativeClassName().asString()).append(".").append(CLASS_METADATA_FILE_EXTENSION).toString();
    }

    @Override
    @NotNull
    public String getPackageFilePath(@NotNull FqName fqName2) {
        Intrinsics.checkParameterIsNotNull((Object)fqName2, (String)"fqName");
        return this.packageFqNameToPath(fqName2) + "/" + this.shortName(fqName2) + "." + PACKAGE_FILE_EXTENSION;
    }

    @Override
    @NotNull
    public String getStringTableFilePath(@NotNull FqName fqName2) {
        Intrinsics.checkParameterIsNotNull((Object)fqName2, (String)"fqName");
        return this.packageFqNameToPath(fqName2) + "/" + this.shortName(fqName2) + "." + STRING_TABLE_FILE_EXTENSION;
    }

    @NotNull
    public final String getBuiltInsFilePath(@NotNull FqName fqName2) {
        Intrinsics.checkParameterIsNotNull((Object)fqName2, (String)"fqName");
        return this.packageFqNameToPath(fqName2) + "/" + this.shortName(fqName2) + "." + BUILTINS_FILE_EXTENSION;
    }

    private final String packageFqNameToPath(FqName fqName2) {
        return StringsKt.replace$default((String)fqName2.asString(), (char)'.', (char)'/', (boolean)false, (int)4, null);
    }

    private final String shortName(FqName fqName2) {
        String string;
        if (fqName2.isRoot()) {
            string = "default-package";
        } else {
            String string2 = fqName2.shortName().asString();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"fqName.shortName().asString()");
        }
        return string;
    }

    private BuiltInsSerializedResourcePaths() {
        INSTANCE = this;
        ExtensionRegistryLite extensionRegistryLite = ExtensionRegistryLite.newInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)extensionRegistryLite, (String)"ExtensionRegistryLite.newInstance()");
        extensionRegistry = extensionRegistryLite;
        BuiltInsProtoBuf.registerAllExtensions(this.getExtensionRegistry());
        CLASS_METADATA_FILE_EXTENSION = CLASS_METADATA_FILE_EXTENSION;
        PACKAGE_FILE_EXTENSION = PACKAGE_FILE_EXTENSION;
        STRING_TABLE_FILE_EXTENSION = STRING_TABLE_FILE_EXTENSION;
        BUILTINS_FILE_EXTENSION = BUILTINS_FILE_EXTENSION;
    }

    static {
        new BuiltInsSerializedResourcePaths();
    }
}

