/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.js.rhino;

import com.google.gwt.dev.js.rhino.Context;
import com.google.gwt.dev.js.rhino.TokenStream;
import com.google.gwt.dev.js.rhino.UintMap;

public class Node
implements Cloneable {
    public static final int TARGET_PROP = 1;
    public static final int BREAK_PROP = 2;
    public static final int CONTINUE_PROP = 3;
    public static final int ENUM_PROP = 4;
    public static final int FUNCTION_PROP = 5;
    public static final int TEMP_PROP = 6;
    public static final int LOCAL_PROP = 7;
    public static final int CODEOFFSET_PROP = 8;
    public static final int FIXUPS_PROP = 9;
    public static final int VARS_PROP = 10;
    public static final int USES_PROP = 11;
    public static final int REGEXP_PROP = 12;
    public static final int CASES_PROP = 13;
    public static final int DEFAULT_PROP = 14;
    public static final int CASEARRAY_PROP = 15;
    public static final int SOURCENAME_PROP = 16;
    public static final int SOURCE_PROP = 17;
    public static final int TYPE_PROP = 18;
    public static final int SPECIAL_PROP_PROP = 19;
    public static final int LABEL_PROP = 20;
    public static final int FINALLY_PROP = 21;
    public static final int LOCALCOUNT_PROP = 22;
    public static final int TARGETBLOCK_PROP = 23;
    public static final int VARIABLE_PROP = 24;
    public static final int LASTUSE_PROP = 25;
    public static final int ISNUMBER_PROP = 26;
    public static final int DIRECTCALL_PROP = 27;
    public static final int BASE_LINENO_PROP = 28;
    public static final int END_LINENO_PROP = 29;
    public static final int SPECIALCALL_PROP = 30;
    public static final int DEBUGSOURCE_PROP = 31;
    public static final int BOTH = 0;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    int type;
    Node next;
    private Node first;
    private Node last;
    private int intDatum = -1;
    private UintMap props;
    private boolean isSyntheticBlock = false;

    public Node(int nodeType) {
        this.type = nodeType;
    }

    public Node(int nodeType, Node child) {
        this.type = nodeType;
        this.first = this.last = child;
        child.next = null;
    }

    public Node(int nodeType, Node left, Node right) {
        this.type = nodeType;
        this.first = left;
        this.last = right;
        left.next = right;
        right.next = null;
    }

    public Node(int nodeType, Node left, Node mid, Node right) {
        this.type = nodeType;
        this.first = left;
        this.last = right;
        left.next = mid;
        mid.next = right;
        right.next = null;
    }

    public Node(int nodeType, Node left, Node mid, Node mid2, Node right) {
        this.type = nodeType;
        this.first = left;
        this.last = right;
        left.next = mid;
        mid.next = mid2;
        mid2.next = right;
        right.next = null;
    }

    public Node(int nodeType, Node[] children2) {
        this.type = nodeType;
        if (children2.length != 0) {
            this.first = children2[0];
            this.last = children2[children2.length - 1];
            for (int i = 1; i < children2.length; ++i) {
                if (null != children2[i - 1].next) {
                    throw new IllegalArgumentException("duplicate child");
                }
                children2[i - 1].next = children2[i];
            }
            if (null != this.last.next) {
                throw new IllegalArgumentException("duplicate child");
            }
        }
    }

    public Node(int nodeType, int value2) {
        this.type = nodeType;
        this.intDatum = value2;
    }

    public Node(int nodeType, Node child, int value2) {
        this(nodeType, child);
        this.intDatum = value2;
    }

    public Node(int nodeType, Node left, Node right, int value2) {
        this(nodeType, left, right);
        this.intDatum = value2;
    }

    public Node(int nodeType, Node left, Node mid, Node right, int value2) {
        this(nodeType, left, mid, right);
        this.intDatum = value2;
    }

    public static Node newNumber(int number) {
        return new NumberNode(number);
    }

    public static Node newNumber(double number) {
        return new NumberNode(number);
    }

    public static Node newString(String str) {
        return new StringNode(46, str);
    }

    public static Node newString(int type2, String str) {
        return new StringNode(type2, str);
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type2) {
        this.type = type2;
    }

    public int getIntDatum() {
        return this.intDatum;
    }

    public Node getFirstChild() {
        return this.first;
    }

    public Node getNext() {
        return this.next;
    }

    public int getChildCount() {
        int c = 0;
        Node n = this.first;
        while (n != null) {
            ++c;
            n = n.next;
        }
        return c;
    }

    public Node getLastSibling() {
        Node n = this;
        while (n.next != null) {
            n = n.next;
        }
        return n;
    }

    public void addChildToBack(Node child) {
        child.next = null;
        if (this.last == null) {
            this.first = this.last = child;
            return;
        }
        this.last.next = child;
        this.last = child;
    }

    public void addChildrenToBack(Node children2) {
        if (this.last != null) {
            this.last.next = children2;
        }
        this.last = children2.getLastSibling();
        if (this.first == null) {
            this.first = children2;
        }
    }

    private static final String propToString(int propType) {
        switch (propType) {
            case 1: {
                return "target";
            }
            case 2: {
                return "break";
            }
            case 3: {
                return "continue";
            }
            case 4: {
                return "enum";
            }
            case 5: {
                return "function";
            }
            case 6: {
                return "temp";
            }
            case 7: {
                return "local";
            }
            case 8: {
                return "codeoffset";
            }
            case 9: {
                return "fixups";
            }
            case 10: {
                return "vars";
            }
            case 11: {
                return "uses";
            }
            case 12: {
                return "regexp";
            }
            case 13: {
                return "cases";
            }
            case 14: {
                return "default";
            }
            case 15: {
                return "casearray";
            }
            case 16: {
                return "sourcename";
            }
            case 17: {
                return "source";
            }
            case 18: {
                return "type";
            }
            case 19: {
                return "special_prop";
            }
            case 20: {
                return "label";
            }
            case 21: {
                return "finally";
            }
            case 22: {
                return "localcount";
            }
            case 23: {
                return "targetblock";
            }
            case 24: {
                return "variable";
            }
            case 25: {
                return "lastuse";
            }
            case 26: {
                return "isnumber";
            }
            case 27: {
                return "directcall";
            }
            case 28: {
                return "base_lineno";
            }
            case 29: {
                return "end_lineno";
            }
            case 30: {
                return "specialcall";
            }
            case 31: {
                return "debugsource";
            }
        }
        Context.codeBug();
        return null;
    }

    public Object getProp(int propType) {
        if (this.props == null) {
            return null;
        }
        return this.props.getObject(propType);
    }

    public void putProp(int propType, Object prop) {
        if (prop == null) {
            this.removeProp(propType);
        } else {
            if (this.props == null) {
                this.props = new UintMap(2);
            }
            this.props.put(propType, prop);
        }
    }

    public void putIntProp(int propType, int prop) {
        if (this.props == null) {
            this.props = new UintMap(2);
        }
        this.props.put(propType, prop);
    }

    public void removeProp(int propType) {
        if (this.props != null) {
            this.props.remove(propType);
        }
    }

    public int getOperation() {
        switch (this.type) {
            case 102: 
            case 103: 
            case 105: 
            case 109: {
                return this.intDatum;
            }
        }
        Context.codeBug();
        return 0;
    }

    public int getLineno() {
        if (this.hasLineno()) {
            return this.intDatum;
        }
        return -1;
    }

    private boolean hasLineno() {
        switch (this.type) {
            case 5: 
            case 62: 
            case 115: 
            case 118: 
            case 119: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 133: 
            case 140: {
                return true;
            }
        }
        return false;
    }

    public double getDouble() throws UnsupportedOperationException {
        throw new UnsupportedOperationException(this + " is not a number node");
    }

    public String getString() throws UnsupportedOperationException {
        throw new UnsupportedOperationException(this + " is not a string node");
    }

    public void setString(String s) throws UnsupportedOperationException {
        throw new UnsupportedOperationException(this + " is not a string node");
    }

    public final int hashCode() {
        assert (false) : "hashCode not designed";
        return 42;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Node)) {
            return false;
        }
        return this.hasLineno() || this.getIntDatum() == ((Node)o).getIntDatum();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(TokenStream.tokenToName(this.type));
        if (this instanceof StringNode) {
            sb.append(' ');
            sb.append(this.getString());
        } else {
            switch (this.type) {
                case 137: {
                    sb.append(' ');
                    sb.append(this.hashCode());
                    break;
                }
                case 148: {
                    sb.append(' ');
                    sb.append((int)this.getDouble());
                    break;
                }
                case 45: {
                    sb.append(' ');
                    sb.append(this.getDouble());
                    break;
                }
                case 110: {
                    sb.append(' ');
                    sb.append(this.first.getString());
                }
            }
        }
        if (this.intDatum != -1) {
            sb.append(' ');
            sb.append(this.intDatum);
        }
        if (this.props == null) {
            return sb.toString();
        }
        int[] keys = this.props.getKeys();
        for (int i = 0; i != keys.length; ++i) {
            int key = keys[i];
            sb.append(" [");
            sb.append(Node.propToString(key));
            sb.append(": ");
            switch (key) {
                case 9: {
                    sb.append("fixups property");
                    break;
                }
                case 17: {
                    sb.append("source property");
                    break;
                }
                case 23: {
                    sb.append("target block property");
                    break;
                }
                case 25: {
                    sb.append("last use property");
                    break;
                }
                default: {
                    Object obj = this.props.getObject(key);
                    if (obj != null) {
                        sb.append(obj.toString());
                        break;
                    }
                    sb.append(this.props.getExistingInt(key));
                }
            }
            sb.append(']');
        }
        return sb.toString();
    }

    public void setIsSyntheticBlock(boolean val) {
        this.isSyntheticBlock = val;
    }

    private static class StringNode
    extends Node {
        private String str;

        StringNode(int type2, String str) {
            super(type2);
            if (null == str) {
                throw new IllegalArgumentException("StringNode: str is null");
            }
            this.str = str;
        }

        @Override
        public String getString() {
            return this.str;
        }

        @Override
        public void setString(String str) {
            if (null == str) {
                throw new IllegalArgumentException("StringNode: str is null");
            }
            this.str = str;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof StringNode)) {
                return false;
            }
            return o instanceof StringNode && this.str.equals(((StringNode)o).str);
        }
    }

    private static class NumberNode
    extends Node {
        private double number;

        NumberNode(int number) {
            super(148);
            this.number = number;
        }

        NumberNode(double number) {
            super(45);
            this.number = number;
        }

        @Override
        public double getDouble() {
            return this.number;
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof NumberNode && this.getDouble() == ((NumberNode)o).getDouble();
        }
    }
}

