/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.backend.js.ast;

import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsContext;
import com.google.dart.compiler.backend.js.ast.JsEmptyExpression;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsNumberLiteral;
import com.google.dart.compiler.backend.js.ast.JsObjectScope;
import com.google.dart.compiler.backend.js.ast.JsProgramFragment;
import com.google.dart.compiler.backend.js.ast.JsRootScope;
import com.google.dart.compiler.backend.js.ast.JsStringLiteral;
import com.google.dart.compiler.backend.js.ast.JsVisitor;
import com.google.dart.compiler.backend.js.ast.JsVisitorWithContext;
import com.google.dart.compiler.backend.js.ast.SourceInfoAwareJsNode;
import gnu.trove.TDoubleObjectHashMap;
import gnu.trove.THashMap;
import gnu.trove.TIntObjectHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class JsProgram
extends SourceInfoAwareJsNode {
    @NotNull
    final JsExpression emptyExpression;
    private JsProgramFragment[] fragments;
    private final TDoubleObjectHashMap<JsNumberLiteral.JsDoubleLiteral> doubleLiteralMap = new TDoubleObjectHashMap();
    private final TIntObjectHashMap<JsNumberLiteral.JsIntLiteral> intLiteralMap = new TIntObjectHashMap();
    private final JsRootScope rootScope;
    private final Map<String, JsStringLiteral> stringLiteralMap = new THashMap();
    private final JsObjectScope topScope;

    public JsProgram(String unitId) {
        this.rootScope = new JsRootScope(this);
        this.topScope = new JsObjectScope(this.rootScope, "Global", unitId);
        this.setFragmentCount(1);
        this.emptyExpression = new JsEmptyExpression();
    }

    @NotNull
    public JsExpression getEmptyExpression() {
        JsExpression jsExpression = this.emptyExpression;
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/dart/compiler/backend/js/ast/JsProgram", "getEmptyExpression"));
        }
        return jsExpression;
    }

    public JsBlock getFragmentBlock(int fragment) {
        if (fragment < 0 || fragment >= this.fragments.length) {
            throw new IllegalArgumentException("Invalid fragment: " + fragment);
        }
        return this.fragments[fragment].getGlobalBlock();
    }

    public JsBlock getGlobalBlock() {
        return this.getFragmentBlock(0);
    }

    public JsNumberLiteral getNumberLiteral(double value2) {
        JsNumberLiteral.JsDoubleLiteral literal = (JsNumberLiteral.JsDoubleLiteral)this.doubleLiteralMap.get(value2);
        if (literal == null) {
            literal = new JsNumberLiteral.JsDoubleLiteral(value2);
            this.doubleLiteralMap.put(value2, (Object)literal);
        }
        return literal;
    }

    public JsNumberLiteral getNumberLiteral(int value2) {
        JsNumberLiteral.JsIntLiteral literal = (JsNumberLiteral.JsIntLiteral)this.intLiteralMap.get(value2);
        if (literal == null) {
            literal = new JsNumberLiteral.JsIntLiteral(value2);
            this.intLiteralMap.put(value2, (Object)literal);
        }
        return literal;
    }

    public JsRootScope getRootScope() {
        return this.rootScope;
    }

    public JsObjectScope getScope() {
        return this.topScope;
    }

    @NotNull
    public JsStringLiteral getStringLiteral(String value2) {
        JsStringLiteral literal = this.stringLiteralMap.get(value2);
        if (literal == null) {
            literal = new JsStringLiteral(value2);
            this.stringLiteralMap.put(value2, literal);
        }
        JsStringLiteral jsStringLiteral = literal;
        if (jsStringLiteral == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/dart/compiler/backend/js/ast/JsProgram", "getStringLiteral"));
        }
        return jsStringLiteral;
    }

    public void setFragmentCount(int fragments2) {
        this.fragments = new JsProgramFragment[fragments2];
        for (int i = 0; i < fragments2; ++i) {
            this.fragments[i] = new JsProgramFragment();
        }
    }

    @Override
    public void accept(JsVisitor v) {
        v.visitProgram(this);
    }

    @Override
    public void acceptChildren(JsVisitor visitor2) {
        for (JsProgramFragment fragment : this.fragments) {
            visitor2.accept(fragment);
        }
    }

    @Override
    public void traverse(JsVisitorWithContext v, JsContext ctx) {
        if (v.visit(this, ctx)) {
            for (JsProgramFragment fragment : this.fragments) {
                v.accept(fragment);
            }
        }
        v.endVisit(this, ctx);
    }

    @Override
    @NotNull
    public JsProgram deepCopy() {
        throw new UnsupportedOperationException();
    }
}

