/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner;

import com.intellij.execution.console.DuplexConsoleView;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.GradleRunnerUtil;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleUrlProvider;

public class GradleTestsExecutionConsole
extends SMTRunnerConsoleView {
    private Map<String, SMTestProxy> testsMap = ContainerUtil.newHashMap();
    private StringBuilder myBuffer = new StringBuilder();
    private DuplexConsoleView myConsoleView;

    public GradleTestsExecutionConsole(TestConsoleProperties consoleProperties, @Nullable String splitterProperty) {
        super(consoleProperties, splitterProperty);
    }

    public void initTaskExecutionView(Project project, ProcessHandler processHandler, ExternalSystemTaskId taskId) {
        this.myConsoleView = GradleRunnerUtil.attachTaskExecutionView(project, super.getConsole(), false, "gradle.test.runner.text.console", processHandler, taskId);
    }

    @NotNull
    public ConsoleView getConsole() {
        Object object = this.myConsoleView != null ? this.myConsoleView : super.getConsole();
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/execution/test/runner/GradleTestsExecutionConsole", "getConsole"));
        }
        return object;
    }

    public Map<String, SMTestProxy> getTestsMap() {
        return this.testsMap;
    }

    public StringBuilder getBuffer() {
        return this.myBuffer;
    }

    public void dispose() {
        super.dispose();
        Disposer.dispose((Disposable)this.myConsoleView);
    }

    public SMTestLocator getUrlProvider() {
        return GradleUrlProvider.INSTANCE;
    }
}

