/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.gradle.model.impl;

import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.gradle.model.JpsGradleExtensionService;
import org.jetbrains.jps.model.java.impl.JpsJavaDependenciesEnumerationHandler;
import org.jetbrains.jps.model.module.JpsDependencyElement;
import org.jetbrains.jps.model.module.JpsModule;

public class JpsGradleDependenciesEnumerationHandler
extends JpsJavaDependenciesEnumerationHandler {
    private static final JpsGradleDependenciesEnumerationHandler INSTANCE = new JpsGradleDependenciesEnumerationHandler();

    public boolean shouldAddRuntimeDependenciesToTestCompilationClasspath() {
        return true;
    }

    public boolean isProductionOnTestsDependency(JpsDependencyElement element) {
        return JpsGradleExtensionService.getInstance().isProductionOnTestDependency(element);
    }

    public boolean shouldIncludeTestsFromDependentModulesToTestClasspath() {
        return false;
    }

    public boolean shouldProcessDependenciesRecursively() {
        return false;
    }

    public static class GradleFactory
    extends JpsJavaDependenciesEnumerationHandler.Factory {
        @Nullable
        public JpsJavaDependenciesEnumerationHandler createHandler(@NotNull Collection<JpsModule> modules) {
            if (modules == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "org/jetbrains/jps/gradle/model/impl/JpsGradleDependenciesEnumerationHandler$GradleFactory", "createHandler"));
            }
            JpsGradleExtensionService service = JpsGradleExtensionService.getInstance();
            for (JpsModule module : modules) {
                if (service.getExtension(module) == null) continue;
                return INSTANCE;
            }
            return null;
        }
    }
}

