/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.ide.IconProvider;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.PsiElement;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiIconUtil {
    @Nullable
    public static Icon getProvidersIcon(@NotNull PsiElement element, @Iconable.IconFlags int flags) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/PsiIconUtil", "getProvidersIcon"));
        }
        boolean dumb = DumbService.getInstance(element.getProject()).isDumb();
        for (IconProvider iconProvider : PsiIconUtil.getIconProviders()) {
            Icon icon;
            if (dumb && !DumbService.isDumbAware(iconProvider) || (icon = iconProvider.getIcon(element, flags)) == null) continue;
            return icon;
        }
        return null;
    }

    private static IconProvider[] getIconProviders() {
        return IconProviderHolder.ourIconProviders;
    }

    private static class IconProviderHolder {
        private static final IconProvider[] ourIconProviders = (IconProvider[])Extensions.getExtensions(IconProvider.EXTENSION_POINT_NAME);

        private IconProviderHolder() {
        }
    }
}

