/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.openapi.ui.TypingTarget;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.Magnificator;
import com.intellij.ui.components.ZoomableViewport;
import com.intellij.ui.components.ZoomingDelegate;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.ComponentWithEmptyText;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.ViewportLayout;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTreeUI;
import org.jetbrains.annotations.Nullable;

public class JBViewport
extends JViewport
implements ZoomableViewport {
    private static final ViewportLayout ourLayoutManager = new ViewportLayout(){

        @Override
        public void layoutContainer(Container parent) {
            if (parent instanceof JViewport && Registry.is((String)"ide.scroll.new.layout")) {
                JViewport viewport = (JViewport)parent;
                Component view = viewport.getView();
                if (view != null) {
                    Container grand = viewport.getParent();
                    if (grand instanceof JScrollPane) {
                        JBViewport.doLayout((JScrollPane)grand, viewport, view);
                    } else {
                        super.layoutContainer(parent);
                    }
                }
                return;
            }
            JBViewport viewport = (JBViewport)parent;
            Component view = viewport.getView();
            JBScrollPane scrollPane = (JBScrollPane)UIUtil.getParentOfType(JBScrollPane.class, (Component)parent);
            if (view == null || scrollPane == null || view instanceof TypingTarget) {
                super.layoutContainer(parent);
                return;
            }
            Dimension size = this.doSuperLayoutContainer(viewport);
            Dimension visible = viewport.getExtentSize();
            if (scrollPane.getHorizontalScrollBarPolicy() == 31) {
                size.width = visible.width;
            }
            if (scrollPane.getVerticalScrollBarPolicy() == 21) {
                size.height = visible.height;
            }
            viewport.setViewSize(size);
        }

        private Dimension doSuperLayoutContainer(JBViewport viewport) {
            try {
                viewport.mySaveTempViewSize = true;
                super.layoutContainer(viewport);
            }
            finally {
                viewport.mySaveTempViewSize = false;
            }
            return viewport.myTempViewSize;
        }
    };
    private StatusText myEmptyText;
    private boolean myPaintingNow;
    private ZoomingDelegate myZoomer;
    private Dimension myTempViewSize;
    private boolean mySaveTempViewSize;
    private volatile boolean myBackgroundRequested;

    public JBViewport() {
        this.addContainerListener(new ContainerListener(){

            @Override
            public void componentAdded(ContainerEvent e) {
                Component child = e.getChild();
                if (child instanceof JBTable) {
                    JBViewport.this.myEmptyText = ((ComponentWithEmptyText)((Object)child)).getEmptyText();
                    JBViewport.this.myEmptyText.attachTo(JBViewport.this, child);
                }
            }

            @Override
            public void componentRemoved(ContainerEvent e) {
                Component child = e.getChild();
                if (child instanceof JBTable) {
                    ((ComponentWithEmptyText)((Object)child)).getEmptyText().attachTo(child);
                    JBViewport.this.myEmptyText = null;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Color getBackground() {
        Component child;
        Color color = super.getBackground();
        if (!this.myBackgroundRequested && EventQueue.isDispatchThread() && Registry.is((String)"ide.scroll.background.auto") && (!this.isBackgroundSet() || color instanceof UIResource) && (child = this.getView()) != null) {
            try {
                this.myBackgroundRequested = true;
                Color color2 = child.getBackground();
                return color2;
            }
            finally {
                this.myBackgroundRequested = false;
            }
        }
        return color;
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return ourLayoutManager;
    }

    @Override
    public void setViewSize(Dimension newSize) {
        if (this.mySaveTempViewSize) {
            this.myTempViewSize = newSize;
        } else {
            super.setViewSize(newSize);
        }
    }

    @Override
    public void paint(Graphics g) {
        this.myPaintingNow = true;
        if (this.myZoomer != null && this.myZoomer.isActive()) {
            this.myZoomer.paint(g);
        } else {
            super.paint(g);
            if (this.myEmptyText != null) {
                this.myEmptyText.paint(this, g);
            }
        }
        this.myPaintingNow = false;
    }

    @Override
    @Nullable
    public Magnificator getMagnificator() {
        return (Magnificator)UIUtil.getClientProperty((Object)this.getView(), Magnificator.CLIENT_PROPERTY_KEY);
    }

    @Override
    public void magnificationStarted(Point at) {
        this.myZoomer = new ZoomingDelegate((JComponent)this.getView(), this);
        this.myZoomer.magnificationStarted(at);
    }

    @Override
    public void magnificationFinished(double magnification) {
        this.myZoomer.magnificationFinished(magnification);
        this.myZoomer = null;
    }

    @Override
    public void magnify(double magnification) {
        this.myZoomer.magnify(magnification);
    }

    public boolean isPaintingNow() {
        return this.myPaintingNow;
    }

    private static JBScrollPane.Alignment getAlignment(JScrollBar bar) {
        if (bar != null && bar.isVisible() && !bar.isOpaque()) {
            return (JBScrollPane.Alignment)((Object)UIUtil.getClientProperty((Object)bar, JBScrollPane.Alignment.class));
        }
        return null;
    }

    private static void doLayout(JScrollPane pane, JViewport viewport, Component view) {
        int maxY;
        JBViewport.updateBorder(view);
        Dimension actualSize = viewport.getSize();
        Dimension extentSize = viewport.toViewCoordinates(actualSize);
        Dimension viewPreferredSize = view.getPreferredSize();
        Dimension viewSize = new Dimension(viewPreferredSize);
        Point viewPosition = viewport.getViewPosition();
        Scrollable scrollable = null;
        if (view instanceof Scrollable) {
            scrollable = (Scrollable)((Object)view);
            if (scrollable.getScrollableTracksViewportWidth()) {
                viewSize.width = actualSize.width;
            }
            if (scrollable.getScrollableTracksViewportHeight()) {
                viewSize.height = actualSize.height;
            }
        }
        int maxX = viewSize.width - extentSize.width;
        if (scrollable == null || pane.getComponentOrientation().isLeftToRight()) {
            if (viewPosition.x > maxX) {
                viewPosition.x = Math.max(0, maxX);
            }
        } else {
            int n = viewPosition.x = maxX < 0 ? maxX : Math.max(0, Math.min(maxX, viewPosition.x));
        }
        if (viewPosition.y > (maxY = viewSize.height - extentSize.height)) {
            viewPosition.y = Math.max(0, maxY);
        }
        if (scrollable == null) {
            if (viewPosition.x == 0 && actualSize.width > viewPreferredSize.width) {
                viewSize.width = actualSize.width;
            }
            if (viewPosition.y == 0 && actualSize.height > viewPreferredSize.height) {
                viewSize.height = actualSize.height;
            }
        }
        if (!(view instanceof TypingTarget)) {
            if (31 == pane.getHorizontalScrollBarPolicy()) {
                viewPosition.x = 0;
                viewSize.width = extentSize.width;
            }
            if (21 == pane.getVerticalScrollBarPolicy()) {
                viewPosition.y = 0;
                viewSize.height = extentSize.height;
            }
        }
        viewport.setViewPosition(viewPosition);
        viewport.setViewSize(viewSize);
    }

    private static void updateBorder(Component view) {
        if (view instanceof JTable) {
            return;
        }
        if (view instanceof JComponent) {
            JComponent component = (JComponent)view;
            Border border = component.getBorder();
            if (border instanceof ViewBorder) {
                return;
            }
            component.setBorder(border == null || border instanceof UIResource ? new ResourceViewBorder(border) : new ViewBorder(border));
        }
    }

    private static class ViewBorder
    extends AbstractBorder {
        private final Insets myInsets = new Insets(0, 0, 0, 0);
        private final Border myBorder;

        ViewBorder(Border border) {
            this.myBorder = border;
        }

        @Override
        public Insets getBorderInsets(Component view, Insets insets) {
            Insets inner;
            if (insets == null) {
                insets = new Insets(0, 0, 0, 0);
            } else {
                insets.set(0, 0, 0, 0);
            }
            if (this.myBorder != null && (inner = this.myBorder.getBorderInsets(view)) != null) {
                insets.set(inner.top, inner.left, inner.bottom, inner.right);
            }
            if (view instanceof JComponent) {
                this.addViewInsets((JComponent)view, insets);
            }
            if (!this.myInsets.equals(insets)) {
                this.myInsets.set(insets.top, insets.left, insets.bottom, insets.right);
                if (view instanceof JComponent) {
                    JTree tree;
                    TreeUI ui;
                    JComponent component = (JComponent)view;
                    if (component instanceof JTree && (ui = (tree = (JTree)component).getUI()) instanceof BasicTreeUI) {
                        BasicTreeUI basic = (BasicTreeUI)ui;
                        basic.setLeftChildIndent(basic.getLeftChildIndent());
                    }
                    component.revalidate();
                } else {
                    view.invalidate();
                    view.repaint();
                }
            }
            return insets;
        }

        @Override
        public void paintBorder(Component view, Graphics g, int x, int y, int width, int height) {
            if (this.myBorder != null) {
                this.myBorder.paintBorder(view, g, x, y, width, height);
            }
        }

        private void addViewInsets(JComponent view, Insets insets) {
            JViewport viewport;
            Container grand;
            Container parent;
            if (this == view.getBorder() && (parent = view.getParent()) instanceof JViewport && (grand = (viewport = (JViewport)parent).getParent()) instanceof JScrollPane) {
                JScrollPane pane = (JScrollPane)grand;
                if (viewport == pane.getViewport() || viewport == pane.getColumnHeader()) {
                    JScrollBar vsb = pane.getVerticalScrollBar();
                    JBScrollPane.Alignment va = JBViewport.getAlignment(vsb);
                    if (va == JBScrollPane.Alignment.LEFT) {
                        insets.left += vsb.getWidth();
                    } else if (va == JBScrollPane.Alignment.RIGHT && this.isAlignmentNeeded(view)) {
                        insets.right += vsb.getWidth();
                    }
                }
                if (viewport == pane.getViewport() || viewport == pane.getRowHeader()) {
                    JScrollBar hsb = pane.getHorizontalScrollBar();
                    JBScrollPane.Alignment ha = JBViewport.getAlignment(hsb);
                    if (ha == JBScrollPane.Alignment.TOP) {
                        insets.top += hsb.getHeight();
                    } else if (ha == JBScrollPane.Alignment.BOTTOM && this.isAlignmentNeeded(view)) {
                        insets.bottom += hsb.getHeight();
                    }
                }
            }
        }

        private boolean isAlignmentNeeded(JComponent view) {
            return !SystemInfo.isMac && (view instanceof JList || view instanceof JTree || Registry.is((String)"ide.scroll.align.component"));
        }
    }

    private static class ResourceViewBorder
    extends ViewBorder
    implements UIResource {
        ResourceViewBorder(Border border) {
            super(border);
        }
    }
}

