/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.OSProcessManager;
import com.intellij.execution.process.SelfKiller;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import java.nio.charset.Charset;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OSProcessHandler
extends BaseOSProcessHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.process.OSProcessHandler");
    private boolean myHasPty;
    private boolean myDestroyRecursively;

    public OSProcessHandler(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/execution/process/OSProcessHandler", "<init>"));
        }
        this(commandLine.createProcess(), commandLine.getCommandLineString(), commandLine.getCharset());
        this.setHasPty(commandLine instanceof PtyCommandLine);
    }

    @Deprecated
    public OSProcessHandler(@NotNull Process process) {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/execution/process/OSProcessHandler", "<init>"));
        }
        this(process, null);
    }

    public OSProcessHandler(@NotNull Process process, String commandLine) {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/execution/process/OSProcessHandler", "<init>"));
        }
        this(process, commandLine, EncodingManager.getInstance().getDefaultCharset());
    }

    public OSProcessHandler(@NotNull Process process, String commandLine, @Nullable Charset charset) {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/execution/process/OSProcessHandler", "<init>"));
        }
        super(process, commandLine, charset);
        this.myDestroyRecursively = true;
    }

    @NotNull
    protected Future<?> executeOnPooledThread(@NotNull Runnable task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/execution/process/OSProcessHandler", "executeOnPooledThread"));
        }
        Future future = super.executeOnPooledThread(task);
        if (future == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/OSProcessHandler", "executeOnPooledThread"));
        }
        return future;
    }

    protected boolean shouldDestroyProcessRecursively() {
        return this.myDestroyRecursively;
    }

    public void setShouldDestroyProcessRecursively(boolean destroyRecursively) {
        this.myDestroyRecursively = destroyRecursively;
    }

    protected void doDestroyProcess() {
        Process process = this.getProcess();
        if (this.shouldDestroyProcessRecursively() && OSProcessHandler.processCanBeKilledByOS(process)) {
            this.killProcessTree(process);
        } else {
            process.destroy();
        }
    }

    public static boolean processCanBeKilledByOS(Process process) {
        return !(process instanceof SelfKiller);
    }

    protected void killProcessTree(final @NotNull Process process) {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/execution/process/OSProcessHandler", "killProcessTree"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.killProcessTreeSync(process);
        } else {
            this.executeOnPooledThread(new Runnable(){

                @Override
                public void run() {
                    OSProcessHandler.this.killProcessTreeSync(process);
                }
            });
        }
    }

    private void killProcessTreeSync(@NotNull Process process) {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/execution/process/OSProcessHandler", "killProcessTreeSync"));
        }
        LOG.debug("killing process tree");
        boolean destroyed = OSProcessManager.getInstance().killProcessTree(process);
        if (!destroyed) {
            if (OSProcessHandler.isTerminated(process)) {
                LOG.warn("Process has been already terminated: " + this.myCommandLine);
            } else {
                LOG.warn("Cannot kill process tree. Trying to destroy process using Java API. Cmdline:\n" + this.myCommandLine);
                process.destroy();
            }
        }
    }

    private static boolean isTerminated(@NotNull Process process) {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/execution/process/OSProcessHandler", "isTerminated"));
        }
        try {
            process.exitValue();
            return true;
        }
        catch (IllegalThreadStateException e) {
            return false;
        }
    }

    public void setHasPty(boolean hasPty) {
        this.myHasPty = hasPty;
    }

    protected boolean useNonBlockingRead() {
        if (this.myHasPty) {
            return false;
        }
        return super.useNonBlockingRead();
    }
}

