/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.debugger.DebuggerTestCase;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.impl.watch.DebuggerTree;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.LocalVariableDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.treeStructure.Tree;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.tree.TreeNode;

public abstract class DescriptorTestCase
extends DebuggerTestCase {
    private final List<Pair<NodeDescriptorImpl, List<String>>> myDescriptorLog = new ArrayList<Pair<NodeDescriptorImpl, List<String>>>();

    protected NodeRenderer getToStringRenderer() {
        return NodeRendererSettings.getInstance().getToStringRenderer();
    }

    protected NodeRenderer getMapRenderer() {
        return DescriptorTestCase.getAlternateCollectionRenderer("Map");
    }

    private static NodeRenderer getAlternateCollectionRenderer(String name) {
        NodeRenderer[] renderers;
        for (NodeRenderer renderer : renderers = NodeRendererSettings.getInstance().getAlternateCollectionRenderers()) {
            if (!name.equals(renderer.getName())) continue;
            return renderer;
        }
        return null;
    }

    protected NodeRenderer getMapEntryRenderer() {
        return DescriptorTestCase.getAlternateCollectionRenderer("Map.Entry");
    }

    protected NodeRenderer getHexRenderer() {
        return NodeRendererSettings.getInstance().getHexRenderer();
    }

    protected NodeRenderer getCollectionRenderer() {
        return DescriptorTestCase.getAlternateCollectionRenderer("Collection");
    }

    @Override
    protected void resume(final SuspendContextImpl suspendContext) {
        final DebugProcessImpl localProcess = suspendContext.getDebugProcess();
        this.invokeRatherLater((DebuggerCommandImpl)new SuspendContextCommandImpl(suspendContext){

            public void contextAction() throws Exception {
                DescriptorTestCase.this.flushDescriptors();
                localProcess.getManagerThread().schedule((DebuggerCommandImpl)localProcess.createResumeCommand(suspendContext, PrioritizedTask.Priority.LOW));
            }
        });
    }

    protected void logDescriptor(NodeDescriptorImpl descriptor, String text) {
        Pair descriptorText = this.findDescriptorLog(descriptor);
        if (descriptorText == null) {
            ArrayList<String> allText = new ArrayList<String>();
            allText.add(text);
            descriptorText = new Pair((Object)descriptor, allText);
            this.myDescriptorLog.add((Pair<NodeDescriptorImpl, List<String>>)descriptorText);
        } else {
            List allText = (List)descriptorText.getSecond();
            if (!((String)allText.get(allText.size() - 1)).equals(text)) {
                allText.add(text);
            }
        }
    }

    private Pair<NodeDescriptorImpl, List<String>> findDescriptorLog(NodeDescriptorImpl descriptor) {
        Pair<NodeDescriptorImpl, List<String>> descriptorText = null;
        for (Pair<NodeDescriptorImpl, List<String>> pair : this.myDescriptorLog) {
            if (pair.getFirst() != descriptor) continue;
            descriptorText = pair;
            break;
        }
        return descriptorText;
    }

    protected void flushDescriptors() {
        for (Pair<NodeDescriptorImpl, List<String>> aMyDescriptorLog : this.myDescriptorLog) {
            this.printDescriptorLog(aMyDescriptorLog);
        }
        this.myDescriptorLog.clear();
    }

    private void printDescriptorLog(Pair<NodeDescriptorImpl, List<String>> pair) {
        for (String text : (List)pair.getSecond()) {
            this.print(text, ProcessOutputTypes.SYSTEM);
        }
    }

    protected void disableRenderer(NodeRenderer renderer) {
        renderer.setEnabled(false);
    }

    protected void enableRenderer(NodeRenderer renderer) {
        renderer.setEnabled(true);
    }

    protected LocalVariableDescriptorImpl localVar(DebuggerTree frameTree, EvaluationContextImpl evaluationContext, String name) {
        try {
            StackFrameProxyImpl frameProxy = evaluationContext.getFrameProxy();
            assert (frameProxy != null);
            LocalVariableDescriptorImpl local = frameTree.getNodeFactory().getLocalVariableDescriptor(null, frameProxy.visibleVariableByName(name));
            local.setContext(evaluationContext);
            return local;
        }
        catch (EvaluateException e) {
            this.error(e);
            return null;
        }
    }

    @Override
    protected void tearDown() throws Exception {
        try {
            this.flushDescriptors();
        }
        finally {
            super.tearDown();
        }
    }

    protected void expandAll(DebuggerTree tree, Runnable runnable) {
        this.expandAll(tree, runnable, new HashSet<Value>(), null);
    }

    protected void expandAll(DebuggerTree tree, Runnable runnable, Set<Value> alreadyExpanded, NodeFilter filter) {
        this.expandAll((Tree)tree, runnable, alreadyExpanded, filter, tree.getDebuggerContext().getSuspendContext());
    }

    protected void expandAll(final Tree tree, final Runnable runnable, final Set<Value> alreadyExpanded, final NodeFilter filter, final SuspendContextImpl context) {
        this.invokeRatherLater(context, new Runnable(){

            @Override
            public void run() {
                boolean anyCollapsed = false;
                for (int i = 0; i < tree.getRowCount(); ++i) {
                    boolean shouldExpand;
                    TreeNode treeNode = (TreeNode)tree.getPathForRow(i).getLastPathComponent();
                    if (!tree.isCollapsed(i) || treeNode.isLeaf()) continue;
                    NodeDescriptorImpl nodeDescriptor = null;
                    if (treeNode instanceof DebuggerTreeNodeImpl) {
                        nodeDescriptor = ((DebuggerTreeNodeImpl)treeNode).getDescriptor();
                    }
                    boolean bl = shouldExpand = filter == null || filter.shouldExpand(treeNode);
                    if (shouldExpand && nodeDescriptor instanceof ValueDescriptor) {
                        Value value = ((ValueDescriptor)nodeDescriptor).getValue();
                        boolean bl2 = shouldExpand = !alreadyExpanded.contains(value);
                        if (shouldExpand) {
                            alreadyExpanded.add(value);
                        }
                    }
                    if (!shouldExpand) continue;
                    anyCollapsed = true;
                    tree.expandRow(i);
                }
                if (anyCollapsed) {
                    DescriptorTestCase.this.expandAll(tree, runnable, alreadyExpanded, filter, context);
                } else {
                    runnable.run();
                }
            }
        });
    }

    protected static interface NodeFilter {
        public boolean shouldExpand(TreeNode var1);
    }
}

