/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizableStringList;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NullableNotNullManager
implements PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance((String)("#" + NullableNotNullManager.class.getName()));
    public String myDefaultNullable = "org.jetbrains.annotations.Nullable";
    public String myDefaultNotNull = "org.jetbrains.annotations.NotNull";
    public final JDOMExternalizableStringList myNullables = new JDOMExternalizableStringList();
    public final JDOMExternalizableStringList myNotNulls = new JDOMExternalizableStringList();
    private static final String JAVAX_ANNOTATION_NULLABLE = "javax.annotation.Nullable";
    private static final String JAVAX_ANNOTATION_NONNULL = "javax.annotation.Nonnull";
    public static final String[] DEFAULT_NULLABLES = new String[]{"org.jetbrains.annotations.Nullable", "javax.annotation.Nullable", "edu.umd.cs.findbugs.annotations.Nullable", "android.support.annotation.Nullable"};
    public static final String[] DEFAULT_NOT_NULLS = new String[]{"org.jetbrains.annotations.NotNull", "javax.annotation.Nonnull", "edu.umd.cs.findbugs.annotations.NonNull", "android.support.annotation.NonNull"};

    public NullableNotNullManager() {
        Collections.addAll(this.myNotNulls, DEFAULT_NOT_NULLS);
        Collections.addAll(this.myNullables, DEFAULT_NULLABLES);
    }

    public static NullableNotNullManager getInstance(Project project) {
        return ServiceManager.getService(project, NullableNotNullManager.class);
    }

    public boolean hasNullability(@NotNull PsiModifierListOwner owner) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/codeInsight/NullableNotNullManager", "hasNullability"));
        }
        return this.isNullable(owner, false) || this.isNotNull(owner, false);
    }

    private static void addAllIfNotPresent(@NotNull Collection<String> collection, String ... annotations) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/codeInsight/NullableNotNullManager", "addAllIfNotPresent"));
        }
        if (annotations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "com/intellij/codeInsight/NullableNotNullManager", "addAllIfNotPresent"));
        }
        for (String annotation : annotations) {
            LOG.assertTrue(annotation != null);
            if (collection.contains(annotation)) continue;
            collection.add(annotation);
        }
    }

    public void setNotNulls(String ... annotations) {
        if (annotations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "com/intellij/codeInsight/NullableNotNullManager", "setNotNulls"));
        }
        this.myNotNulls.clear();
        NullableNotNullManager.addAllIfNotPresent((Collection<String>)this.myNotNulls, DEFAULT_NOT_NULLS);
        NullableNotNullManager.addAllIfNotPresent((Collection<String>)this.myNotNulls, annotations);
    }

    public void setNullables(String ... annotations) {
        if (annotations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "com/intellij/codeInsight/NullableNotNullManager", "setNullables"));
        }
        this.myNullables.clear();
        NullableNotNullManager.addAllIfNotPresent((Collection<String>)this.myNullables, DEFAULT_NULLABLES);
        NullableNotNullManager.addAllIfNotPresent((Collection<String>)this.myNullables, annotations);
    }

    @NotNull
    public String getDefaultNullable() {
        String string = this.myDefaultNullable;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/NullableNotNullManager", "getDefaultNullable"));
        }
        return string;
    }

    @Nullable
    public String getNullable(@NotNull PsiModifierListOwner owner) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/codeInsight/NullableNotNullManager", "getNullable"));
        }
        PsiAnnotation annotation = this.getNullableAnnotation(owner, false);
        return annotation == null ? null : annotation.getQualifiedName();
    }

    private String checkContainer(PsiAnnotation annotation, boolean acceptContainer) {
        if (annotation == null) {
            return null;
        }
        if (!acceptContainer && this.isContainerAnnotation(annotation)) {
            return null;
        }
        return annotation.getQualifiedName();
    }

    @Nullable
    public PsiAnnotation getNullableAnnotation(@NotNull PsiModifierListOwner owner, boolean checkBases) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/codeInsight/NullableNotNullManager", "getNullableAnnotation"));
        }
        return this.findNullabilityAnnotationWithDefault(owner, checkBases, true);
    }

    public boolean isContainerAnnotation(@NotNull PsiAnnotation anno) {
        if (anno == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anno", "com/intellij/codeInsight/NullableNotNullManager", "isContainerAnnotation"));
        }
        PsiAnnotation.TargetType[] acceptAnyTarget = PsiAnnotation.TargetType.values();
        return NullableNotNullManager.isNullabilityDefault(anno, true, acceptAnyTarget) || NullableNotNullManager.isNullabilityDefault(anno, false, acceptAnyTarget);
    }

    public void setDefaultNullable(@NotNull String defaultNullable) {
        if (defaultNullable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultNullable", "com/intellij/codeInsight/NullableNotNullManager", "setDefaultNullable"));
        }
        LOG.assertTrue(this.getNullables().contains(defaultNullable));
        this.myDefaultNullable = defaultNullable;
    }

    @NotNull
    public String getDefaultNotNull() {
        String string = this.myDefaultNotNull;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/NullableNotNullManager", "getDefaultNotNull"));
        }
        return string;
    }

    @Nullable
    public PsiAnnotation getNotNullAnnotation(@NotNull PsiModifierListOwner owner, boolean checkBases) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/codeInsight/NullableNotNullManager", "getNotNullAnnotation"));
        }
        return this.findNullabilityAnnotationWithDefault(owner, checkBases, false);
    }

    @Nullable
    public PsiAnnotation copyNotNullAnnotation(@NotNull PsiModifierListOwner original, @NotNull PsiModifierListOwner generated) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/intellij/codeInsight/NullableNotNullManager", "copyNotNullAnnotation"));
        }
        if (generated == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generated", "com/intellij/codeInsight/NullableNotNullManager", "copyNotNullAnnotation"));
        }
        return this.copyAnnotation(this.getNotNullAnnotation(original, false), generated);
    }

    @Nullable
    public PsiAnnotation copyNullableAnnotation(@NotNull PsiModifierListOwner original, @NotNull PsiModifierListOwner generated) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/intellij/codeInsight/NullableNotNullManager", "copyNullableAnnotation"));
        }
        if (generated == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generated", "com/intellij/codeInsight/NullableNotNullManager", "copyNullableAnnotation"));
        }
        return this.copyAnnotation(this.getNullableAnnotation(original, false), generated);
    }

    @Nullable
    public PsiAnnotation copyNullableOrNotNullAnnotation(@NotNull PsiModifierListOwner original, @NotNull PsiModifierListOwner generated) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/intellij/codeInsight/NullableNotNullManager", "copyNullableOrNotNullAnnotation"));
        }
        if (generated == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generated", "com/intellij/codeInsight/NullableNotNullManager", "copyNullableOrNotNullAnnotation"));
        }
        PsiAnnotation annotation = this.getNullableAnnotation(original, false);
        if (annotation == null) {
            annotation = this.getNotNullAnnotation(original, false);
        }
        return this.copyAnnotation(annotation, generated);
    }

    @Nullable
    private PsiAnnotation copyAnnotation(PsiAnnotation annotation, PsiModifierListOwner target) {
        PsiModifierList modifierList;
        String qualifiedName;
        if (annotation != null && !AnnotationTargetUtil.isTypeAnnotation(annotation) && (qualifiedName = this.checkContainer(annotation, false)) != null && (modifierList = target.getModifierList()) != null && modifierList.findAnnotation(qualifiedName) == null) {
            return modifierList.addAnnotation(qualifiedName);
        }
        return null;
    }

    public PsiAnnotation copyNotNullAnnotation(PsiModifierListOwner owner) {
        return this.copyAnnotation(owner, this.getNotNullAnnotation(owner, false));
    }

    public PsiAnnotation copyNullableAnnotation(PsiModifierListOwner owner) {
        return this.copyAnnotation(owner, this.getNullableAnnotation(owner, false));
    }

    private PsiAnnotation copyAnnotation(PsiModifierListOwner owner, PsiAnnotation annotation) {
        String notNull = this.checkContainer(annotation, false);
        return notNull != null ? JavaPsiFacade.getElementFactory(owner.getProject()).createAnnotationFromText("@" + notNull, owner) : null;
    }

    @Nullable
    public String getNotNull(@NotNull PsiModifierListOwner owner) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/codeInsight/NullableNotNullManager", "getNotNull"));
        }
        PsiAnnotation annotation = this.getNotNullAnnotation(owner, false);
        return annotation == null ? null : annotation.getQualifiedName();
    }

    public void setDefaultNotNull(@NotNull String defaultNotNull) {
        if (defaultNotNull == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultNotNull", "com/intellij/codeInsight/NullableNotNullManager", "setDefaultNotNull"));
        }
        LOG.assertTrue(this.getNotNulls().contains(defaultNotNull));
        this.myDefaultNotNull = defaultNotNull;
    }

    @Nullable
    private PsiAnnotation findNullabilityAnnotationWithDefault(@NotNull PsiModifierListOwner owner, boolean checkBases, boolean nullable) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/codeInsight/NullableNotNullManager", "findNullabilityAnnotationWithDefault"));
        }
        PsiAnnotation annotation = this.findPlainNullabilityAnnotation(owner, checkBases);
        if (annotation != null) {
            List<String> contradictory;
            String qName = annotation.getQualifiedName();
            if (qName == null) {
                return null;
            }
            List<String> list = contradictory = nullable ? this.getNotNulls() : this.getNullables();
            if (contradictory.contains(qName)) {
                return null;
            }
            return annotation;
        }
        PsiType type = NullableNotNullManager.getOwnerType(owner);
        if (type == null || TypeConversionUtil.isPrimitiveAndNotNull(type)) {
            return null;
        }
        if (AnnotationUtil.isAnnotated(owner, nullable ? Arrays.asList(DEFAULT_NOT_NULLS) : Arrays.asList(DEFAULT_NULLABLES), checkBases, false)) {
            return null;
        }
        if (!nullable && this.hasHardcodedContracts(owner)) {
            return null;
        }
        return NullableNotNullManager.findNullabilityDefaultInHierarchy(owner, nullable);
    }

    private PsiAnnotation findPlainNullabilityAnnotation(@NotNull PsiModifierListOwner owner, boolean checkBases) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/codeInsight/NullableNotNullManager", "findPlainNullabilityAnnotation"));
        }
        HashSet qNames = ContainerUtil.newHashSet(this.getNullables());
        qNames.addAll(this.getNotNulls());
        return checkBases && owner instanceof PsiMethod ? AnnotationUtil.findAnnotationInHierarchy(owner, qNames) : AnnotationUtil.findAnnotation(owner, qNames);
    }

    protected boolean hasHardcodedContracts(PsiElement element) {
        return false;
    }

    @Nullable
    private static PsiType getOwnerType(PsiModifierListOwner owner) {
        if (owner instanceof PsiVariable) {
            return ((PsiVariable)owner).getType();
        }
        if (owner instanceof PsiMethod) {
            return ((PsiMethod)owner).getReturnType();
        }
        return null;
    }

    public boolean isNullable(@NotNull PsiModifierListOwner owner, boolean checkBases) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/codeInsight/NullableNotNullManager", "isNullable"));
        }
        return this.findNullabilityAnnotationWithDefault(owner, checkBases, true) != null;
    }

    public boolean isNotNull(@NotNull PsiModifierListOwner owner, boolean checkBases) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/codeInsight/NullableNotNullManager", "isNotNull"));
        }
        return this.findNullabilityAnnotationWithDefault(owner, checkBases, false) != null;
    }

    @Nullable
    private static PsiAnnotation findNullabilityDefaultInHierarchy(PsiModifierListOwner owner, boolean nullable) {
        PsiAnnotation.TargetType[] placeTargetTypes = AnnotationTargetUtil.getTargetsForLocation(owner.getModifierList());
        for (PsiElement element = owner.getParent(); element != null; element = element.getContext()) {
            PsiAnnotation annotation;
            if (element instanceof PsiModifierListOwner && (annotation = NullableNotNullManager.getNullabilityDefault((PsiModifierListOwner)element, nullable, placeTargetTypes)) != null) {
                return annotation;
            }
            if (!(element instanceof PsiClassOwner)) continue;
            String packageName = ((PsiClassOwner)element).getPackageName();
            PsiPackage psiPackage = JavaPsiFacade.getInstance(element.getProject()).findPackage(packageName);
            return psiPackage == null ? null : NullableNotNullManager.getNullabilityDefault(psiPackage, nullable, placeTargetTypes);
        }
        return null;
    }

    private static PsiAnnotation getNullabilityDefault(@NotNull PsiModifierListOwner container, boolean nullable, PsiAnnotation.TargetType[] placeTargetTypes) {
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/codeInsight/NullableNotNullManager", "getNullabilityDefault"));
        }
        PsiModifierList modifierList = container.getModifierList();
        if (modifierList == null) {
            return null;
        }
        for (PsiAnnotation annotation : modifierList.getAnnotations()) {
            if (!NullableNotNullManager.isNullabilityDefault(annotation, nullable, placeTargetTypes)) continue;
            return annotation;
        }
        return null;
    }

    private static boolean isNullabilityDefault(@NotNull PsiAnnotation annotation, boolean nullable, PsiAnnotation.TargetType[] placeTargetTypes) {
        String fqn;
        PsiElement declaration;
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/intellij/codeInsight/NullableNotNullManager", "isNullabilityDefault"));
        }
        PsiJavaCodeReferenceElement element = annotation.getNameReferenceElement();
        PsiElement psiElement = declaration = element == null ? null : element.resolve();
        if (!(declaration instanceof PsiClass)) {
            return false;
        }
        String string = fqn = nullable ? JAVAX_ANNOTATION_NULLABLE : JAVAX_ANNOTATION_NONNULL;
        if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiClass)declaration), fqn, false, true)) {
            return false;
        }
        PsiAnnotation tqDefault = AnnotationUtil.findAnnotation((PsiModifierListOwner)((PsiClass)declaration), true, "javax.annotation.meta.TypeQualifierDefault");
        if (tqDefault == null) {
            return false;
        }
        Set<PsiAnnotation.TargetType> required = AnnotationTargetUtil.extractRequiredAnnotationTargets(tqDefault.findAttributeValue(null));
        return required != null && (required.isEmpty() || ContainerUtil.intersects(required, Arrays.asList(placeTargetTypes)));
    }

    @NotNull
    public List<String> getNullables() {
        JDOMExternalizableStringList jDOMExternalizableStringList = this.myNullables;
        if (jDOMExternalizableStringList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/NullableNotNullManager", "getNullables"));
        }
        return jDOMExternalizableStringList;
    }

    @NotNull
    public List<String> getNotNulls() {
        JDOMExternalizableStringList jDOMExternalizableStringList = this.myNotNulls;
        if (jDOMExternalizableStringList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/NullableNotNullManager", "getNotNulls"));
        }
        return jDOMExternalizableStringList;
    }

    public boolean hasDefaultValues() {
        int i;
        if (DEFAULT_NULLABLES.length != this.getNullables().size() || DEFAULT_NOT_NULLS.length != this.getNotNulls().size()) {
            return false;
        }
        if (!this.myDefaultNotNull.equals("org.jetbrains.annotations.NotNull") || !this.myDefaultNullable.equals("org.jetbrains.annotations.Nullable")) {
            return false;
        }
        for (i = 0; i < DEFAULT_NULLABLES.length; ++i) {
            if (this.getNullables().get(i).equals(DEFAULT_NULLABLES[i])) continue;
            return false;
        }
        for (i = 0; i < DEFAULT_NOT_NULLS.length; ++i) {
            if (this.getNotNulls().get(i).equals(DEFAULT_NOT_NULLS[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public Element getState() {
        Element component = new Element("component");
        if (this.hasDefaultValues()) {
            return component;
        }
        try {
            DefaultJDOMExternalizer.writeExternal((Object)this, (Element)component);
        }
        catch (WriteExternalException e) {
            LOG.error((Throwable)e);
        }
        return component;
    }

    @Override
    public void loadState(Element state) {
        try {
            DefaultJDOMExternalizer.readExternal((Object)this, (Element)state);
            if (this.myNullables.isEmpty()) {
                Collections.addAll(this.myNullables, DEFAULT_NULLABLES);
            }
            if (this.myNotNulls.isEmpty()) {
                Collections.addAll(this.myNotNulls, DEFAULT_NOT_NULLS);
            }
        }
        catch (InvalidDataException e) {
            LOG.error((Throwable)e);
        }
    }

    public static boolean isNullable(@NotNull PsiModifierListOwner owner) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/codeInsight/NullableNotNullManager", "isNullable"));
        }
        return NullableNotNullManager.getInstance(owner.getProject()).isNullable(owner, true);
    }

    public static boolean isNotNull(@NotNull PsiModifierListOwner owner) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/codeInsight/NullableNotNullManager", "isNotNull"));
        }
        return NullableNotNullManager.getInstance(owner.getProject()).isNotNull(owner, true);
    }
}

