/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants.evaluate;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstUtilKt;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptorImpl;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClassLiteralExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEscapeStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntryWithExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.CompileTimeConstantUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.constants.AnnotationValue;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstantChecker;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValueFactory;
import org.jetbrains.kotlin.resolve.constants.EnumValue;
import org.jetbrains.kotlin.resolve.constants.ErrorValue;
import org.jetbrains.kotlin.resolve.constants.IntegerValueConstant;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstant;
import org.jetbrains.kotlin.resolve.constants.KClassValue;
import org.jetbrains.kotlin.resolve.constants.NullValue;
import org.jetbrains.kotlin.resolve.constants.TypedCompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.BinaryOperationKey;
import org.jetbrains.kotlin.resolve.constants.evaluate.CompileTimeType;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluatorKt;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluatorVisitor;
import org.jetbrains.kotlin.resolve.constants.evaluate.OperationsMapGeneratedKt;
import org.jetbrains.kotlin.resolve.constants.evaluate.UnaryOperationKey;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u00eb\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001\f\b\u0002\u0018\u00002\u0014\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\\B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J(\u0010\u0012\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0003H\u0002J*\u0010\u0018\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0017\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J&\u0010\u0019\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0013\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0003H\u0002J&\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u00032\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001fH\u0002J\u001a\u0010 \u001a\u0004\u0018\u00010\u001c2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002J\u001e\u0010%\u001a\u0004\u0018\u00010\u001c2\n\u0010&\u001a\u0006\u0012\u0002\b\u00030'2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001e\u0010(\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0017\u001a\u0004\u0018\u00010\u0003J*\u0010)\u001a\u0004\u0018\u00010\u00142\u0006\u0010*\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\u001c2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u0011H\u0002J(\u0010.\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010-\u001a\u00020\u00112\u0006\u0010/\u001a\u00020\u00112\b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u0002J\"\u00100\u001a\u0004\u0018\u00010\u00142\u0006\u0010*\u001a\u00020\u001c2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u0011H\u0002J\u001a\u00101\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0014\u0018\u00010\u001f2\u0006\u00102\u001a\u00020\u0003H\u0002J\u001a\u00103\u001a\u00020\u000f2\u0006\u0010+\u001a\u00020,2\b\u0010#\u001a\u0004\u0018\u00010\u0014H\u0002J\u0010\u00104\u001a\u00020\u000f2\u0006\u00105\u001a\u000206H\u0002J\u0010\u00107\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J(\u00108\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0002092\f\u0010:\u001a\b\u0012\u0004\u0012\u00020;092\u0006\u0010\u0017\u001a\u00020\u0003H\u0002J\u0010\u0010<\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010=\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J \u0010>\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0010\u001a\u00020?2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u0016J \u0010@\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0010\u001a\u00020A2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u0016J \u0010B\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0010\u001a\u00020C2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u0016J \u0010D\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0010\u001a\u00020E2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u0016J \u0010F\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0010\u001a\u00020G2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u0016J \u0010H\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010I\u001a\u00020J2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u0016J \u0010K\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0010\u001a\u00020L2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u0016J \u0010M\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0010\u001a\u00020N2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u0016J \u0010O\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0010\u001a\u00020P2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u0016J \u0010Q\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0010\u001a\u00020R2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u0016J \u0010S\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0010\u001a\u00020T2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u0016J \u0010U\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0010\u001a\u00020V2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u0016JF\u0010W\u001a\b\u0012\u0004\u0012\u0002HY0X\"\u0004\b\u0000\u0010Y*\b\u0012\u0004\u0012\u0002HY0Z2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010[\u001a\u00020\u000f2\b\b\u0002\u0010=\u001a\u00020\u000f2\b\b\u0002\u0010<\u001a\u00020\u000fH\u0002J&\u0010W\u001a\b\u0012\u0004\u0012\u0002HY0X\"\u0004\b\u0000\u0010Y*\b\u0012\u0004\u0012\u0002HY0Z2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006]"}, d2={"Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluatorVisitor;", "Lorg/jetbrains/kotlin/psi/KtVisitor;", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "Lorg/jetbrains/kotlin/types/KotlinType;", "constantExpressionEvaluator", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "(Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;Lorg/jetbrains/kotlin/resolve/BindingTrace;)V", "factory", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValueFactory;", "stringExpressionEvaluator", "org/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluatorVisitor$stringExpressionEvaluator$1", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluatorVisitor$stringExpressionEvaluator$1;", "canBeUsedInAnnotation", "", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "createCompileTimeConstant", "value", "", "parameters", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant$Parameters;", "expectedType", "createConstant", "createIntegerCompileTimeConstant", "", "createOperationArgument", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluatorVisitor$OperationArgument;", "expressionType", "compileTimeType", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/CompileTimeType;", "createOperationArgumentForFirstParameter", "argument", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedValueArgument;", "parameter", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "createOperationArgumentForReceiver", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "evaluate", "evaluateBinaryAndCheck", "receiver", "name", "", "callExpression", "evaluateCall", "receiverExpression", "evaluateUnaryAndCheck", "getCompileTimeType", "c", "isDivisionByZero", "isPropertyCompileTimeConstant", "descriptor", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "isPureConstant", "resolveArguments", "", "valueArguments", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "usesNonConstValAsConstant", "usesVariableAsConstant", "visitBinaryExpression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "visitBinaryWithTypeRHSExpression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpressionWithTypeRHS;", "visitCallExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "visitClassLiteralExpression", "Lorg/jetbrains/kotlin/psi/KtClassLiteralExpression;", "visitConstantExpression", "Lorg/jetbrains/kotlin/psi/KtConstantExpression;", "visitKtElement", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "visitLabeledExpression", "Lorg/jetbrains/kotlin/psi/KtLabeledExpression;", "visitParenthesizedExpression", "Lorg/jetbrains/kotlin/psi/KtParenthesizedExpression;", "visitQualifiedExpression", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "visitSimpleNameExpression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "visitStringTemplateExpression", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "visitUnaryExpression", "Lorg/jetbrains/kotlin/psi/KtUnaryExpression;", "wrap", "Lorg/jetbrains/kotlin/resolve/constants/TypedCompileTimeConstant;", "T", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "isPure", "OperationArgument", "kotlin-compiler"})
final class ConstantExpressionEvaluatorVisitor
extends KtVisitor<CompileTimeConstant<?>, KotlinType> {
    private final ConstantValueFactory factory;
    private final stringExpressionEvaluator.1 stringExpressionEvaluator;
    private final ConstantExpressionEvaluator constantExpressionEvaluator;
    private final BindingTrace trace;

    @Nullable
    public final CompileTimeConstant<?> evaluate(@NotNull KtExpression expression, @Nullable KotlinType expectedType) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        BindingContext bindingContext = this.trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull(bindingContext, "trace.bindingContext");
        CompileTimeConstant<?> recordedCompileTimeConstant = ConstantExpressionEvaluator.Companion.getPossiblyErrorConstant(expression, bindingContext);
        if (recordedCompileTimeConstant != null) {
            return recordedCompileTimeConstant;
        }
        KtVisitor ktVisitor = this;
        KotlinType kotlinType = expectedType;
        if (kotlinType == null) {
            kotlinType = TypeUtils.NO_EXPECTED_TYPE;
        }
        CompileTimeConstant compileTimeConstant = (CompileTimeConstant)expression.accept(ktVisitor, kotlinType);
        if (compileTimeConstant != null) {
            this.trace.record(BindingContext.COMPILE_TIME_VALUE, expression, compileTimeConstant);
            return compileTimeConstant;
        }
        return null;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitConstantExpression(@NotNull KtConstantExpression expression, @Nullable KotlinType expectedType) {
        Object object;
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        String string = expression.getText();
        if (string == null) {
            return null;
        }
        String text = string;
        IElementType nodeElementType = expression.getNode().getElementType();
        if (Intrinsics.areEqual(nodeElementType, KtNodeTypes.NULL)) {
            return ConstantExpressionEvaluatorVisitor.wrap$default(this, this.factory.createNullValue(), false, false, false, false, 15, null);
        }
        IElementType iElementType = nodeElementType;
        if (Intrinsics.areEqual(iElementType, KtNodeTypes.INTEGER_CONSTANT)) {
            object = ConstantExpressionEvaluatorKt.parseLong(text);
        } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.FLOAT_CONSTANT)) {
            object = ConstantExpressionEvaluatorKt.access$parseFloatingLiteral(text);
        } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.BOOLEAN_CONSTANT)) {
            object = ConstantExpressionEvaluatorKt.access$parseBoolean(text);
        } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.CHARACTER_CONSTANT)) {
            object = CompileTimeConstantChecker.parseChar(expression);
        } else {
            throw (Throwable)new IllegalArgumentException("Unsupported constant: " + expression);
        }
        if (object == null) {
            return null;
        }
        Long result2 = object;
        Function0<Boolean> isLongWithSuffix$ = new Function0<Boolean>(nodeElementType, text){
            final /* synthetic */ IElementType $nodeElementType;
            final /* synthetic */ String $text;

            public final boolean invoke() {
                return Intrinsics.areEqual(this.$nodeElementType, KtNodeTypes.INTEGER_CONSTANT) && ConstantExpressionEvaluatorKt.access$hasLongSuffix(this.$text);
            }
            {
                this.$nodeElementType = iElementType;
                this.$text = string;
                super(0);
            }
        };
        return this.createConstant(result2, expectedType, new CompileTimeConstant.Parameters(true, !isLongWithSuffix$.invoke(), false, false));
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitParenthesizedExpression(@NotNull KtParenthesizedExpression expression, @Nullable KotlinType expectedType) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        KtExpression deparenthesizedExpression = KtPsiUtil.deparenthesize(expression);
        if (deparenthesizedExpression != null && Intrinsics.areEqual(deparenthesizedExpression, expression) ^ true) {
            return this.evaluate(deparenthesizedExpression, expectedType);
        }
        return null;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitLabeledExpression(@NotNull KtLabeledExpression expression, @Nullable KotlinType expectedType) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        KtExpression baseExpression = expression.getBaseExpression();
        if (baseExpression != null) {
            return this.evaluate(baseExpression, expectedType);
        }
        return null;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitStringTemplateExpression(@NotNull KtStringTemplateExpression expression, @Nullable KotlinType expectedType) {
        CompileTimeConstant<?> compileTimeConstant;
        int n;
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        StringBuilder sb = new StringBuilder();
        boolean interupted = false;
        boolean canBeUsedInAnnotation = true;
        int usesVariableAsConstant = 0;
        boolean usesNonConstantVariableAsConstant = false;
        KtStringTemplateEntry[] ktStringTemplateEntryArray = expression.getEntries();
        for (n = 0; n < ktStringTemplateEntryArray.length; ++n) {
            KtStringTemplateEntry entry;
            KtStringTemplateEntry ktStringTemplateEntry = entry = ktStringTemplateEntryArray[n];
            Intrinsics.checkExpressionValueIsNotNull(ktStringTemplateEntry, "entry");
            TypedCompileTimeConstant<String> constant = this.stringExpressionEvaluator.evaluate(ktStringTemplateEntry);
            if (constant == null) {
                interupted = true;
                break;
            }
            if (!constant.getCanBeUsedInAnnotations()) {
                canBeUsedInAnnotation = false;
            }
            if (constant.getUsesVariableAsConstant()) {
                usesVariableAsConstant = 1;
            }
            if (constant.getUsesNonConstValAsConstant()) {
                usesNonConstantVariableAsConstant = true;
            }
            sb.append(constant.getConstantValue().getValue());
        }
        if (!interupted) {
            boolean bl = usesNonConstantVariableAsConstant;
            n = usesVariableAsConstant;
            boolean bl2 = canBeUsedInAnnotation;
            boolean bl3 = false;
            compileTimeConstant = this.createConstant(sb.toString(), expectedType, new CompileTimeConstant.Parameters(bl2, bl3, n != 0, bl));
        } else {
            compileTimeConstant = null;
        }
        return compileTimeConstant;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitBinaryWithTypeRHSExpression(@NotNull KtBinaryExpressionWithTypeRHS expression, @Nullable KotlinType expectedType) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        KtExpression ktExpression = expression.getLeft();
        Intrinsics.checkExpressionValueIsNotNull(ktExpression, "expression.left");
        CompileTimeConstant<?> compileTimeConstant = this.evaluate(ktExpression, expectedType);
        if (compileTimeConstant != null && expectedType != null && !TypeUtils.noExpectedType(expectedType)) {
            KotlinType kotlinType;
            CompileTimeConstant<?> compileTimeConstant2 = compileTimeConstant;
            if (compileTimeConstant2 instanceof TypedCompileTimeConstant) {
                kotlinType = ((TypedCompileTimeConstant)compileTimeConstant).getType();
            } else if (compileTimeConstant2 instanceof IntegerValueTypeConstant) {
                kotlinType = ((IntegerValueTypeConstant)compileTimeConstant).getType(expectedType);
            } else {
                throw (Throwable)new IllegalStateException("Unexpected compileTimeConstant class: " + compileTimeConstant.getClass().getCanonicalName());
            }
            KotlinType constantType = kotlinType;
            if (!TypeUtilsKt.isSubtypeOf(constantType, expectedType)) {
                return null;
            }
        }
        return compileTimeConstant;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public CompileTimeConstant<?> visitBinaryExpression(@NotNull KtBinaryExpression expression, @Nullable KotlinType expectedType) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        KtExpression ktExpression = expression.getLeft();
        if (ktExpression == null) {
            return null;
        }
        KtExpression leftExpression = ktExpression;
        IElementType operationToken = expression.getOperationToken();
        Map map2 = OperatorConventions.BOOLEAN_OPERATIONS;
        void v1 = $receiver$iv;
        if (v1 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, *>");
        }
        if (((Map)v1).containsKey(operationToken)) {
            boolean bl;
            KtExpression rightExpression;
            KotlinType booleanType = this.constantExpressionEvaluator.getBuiltIns$kotlin_compiler().getBooleanType();
            KtExpression ktExpression2 = leftExpression;
            Intrinsics.checkExpressionValueIsNotNull(ktExpression2, "leftExpression");
            CompileTimeConstant<?> compileTimeConstant = this.evaluate(ktExpression2, booleanType);
            if (compileTimeConstant == null) {
                return null;
            }
            CompileTimeConstant<?> leftConstant = compileTimeConstant;
            KtExpression ktExpression3 = expression.getRight();
            if (ktExpression3 == null) {
                return null;
            }
            KtExpression ktExpression4 = rightExpression = ktExpression3;
            Intrinsics.checkExpressionValueIsNotNull(ktExpression4, "rightExpression");
            CompileTimeConstant<?> compileTimeConstant2 = this.evaluate(ktExpression4, booleanType);
            if (compileTimeConstant2 == null) {
                return null;
            }
            CompileTimeConstant<?> rightConstant = compileTimeConstant2;
            KotlinType kotlinType = booleanType;
            Intrinsics.checkExpressionValueIsNotNull(kotlinType, "booleanType");
            Object leftValue = leftConstant.getValue(kotlinType);
            KotlinType kotlinType2 = booleanType;
            Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "booleanType");
            Object rightValue = rightConstant.getValue(kotlinType2);
            if (!(leftValue instanceof Boolean) || !(rightValue instanceof Boolean)) {
                return null;
            }
            IElementType iElementType = operationToken;
            if (Intrinsics.areEqual(iElementType, KtTokens.ANDAND)) {
                bl = ((Boolean)leftValue).booleanValue() && ((Boolean)rightValue).booleanValue();
            } else if (Intrinsics.areEqual(iElementType, KtTokens.OROR)) {
                bl = ((Boolean)leftValue).booleanValue() || ((Boolean)rightValue).booleanValue();
            } else {
                throw (Throwable)new IllegalArgumentException("Unknown boolean operation token " + operationToken);
            }
            boolean result2 = bl;
            return this.createConstant(result2, expectedType, new CompileTimeConstant.Parameters(true, false, leftConstant.getUsesVariableAsConstant() || rightConstant.getUsesVariableAsConstant(), leftConstant.getUsesNonConstValAsConstant() || rightConstant.getUsesNonConstValAsConstant()));
        }
        KtExpression ktExpression5 = expression.getOperationReference();
        Intrinsics.checkExpressionValueIsNotNull(ktExpression5, "expression.operationReference");
        KtExpression ktExpression6 = leftExpression;
        Intrinsics.checkExpressionValueIsNotNull(ktExpression6, "leftExpression");
        return this.evaluateCall(ktExpression5, ktExpression6, expectedType);
    }

    /*
     * WARNING - void declaration
     */
    private final CompileTimeConstant<?> evaluateCall(KtExpression callExpression, KtExpression receiverExpression, KotlinType expectedType) {
        KtElement ktElement = callExpression;
        BindingContext bindingContext = this.trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull(bindingContext, "trace.bindingContext");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(ktElement, bindingContext);
        if (resolvedCall2 == null) {
            return null;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        Name resultingDescriptorName = resolvedCall3.getResultingDescriptor().getName();
        OperationArgument operationArgument = this.createOperationArgumentForReceiver(resolvedCall3, receiverExpression);
        if (operationArgument == null) {
            return null;
        }
        OperationArgument argumentForReceiver = operationArgument;
        Set<Map.Entry<ValueParameterDescriptor, ResolvedValueArgument>> argumentsEntrySet = resolvedCall3.getValueArguments().entrySet();
        if (argumentsEntrySet.isEmpty()) {
            String string = resultingDescriptorName.asString();
            Intrinsics.checkExpressionValueIsNotNull(string, "resultingDescriptorName.asString()");
            Object object = this.evaluateUnaryAndCheck(argumentForReceiver, string, callExpression);
            if (object == null) {
                return null;
            }
            Object result2 = object;
            boolean isArgumentPure = this.isPureConstant(argumentForReceiver.getExpression());
            boolean canBeUsedInAnnotation = this.canBeUsedInAnnotation(argumentForReceiver.getExpression());
            boolean usesVariableAsConstant = this.usesVariableAsConstant(argumentForReceiver.getExpression());
            boolean usesNonConstValAsConstant = this.usesNonConstValAsConstant(argumentForReceiver.getExpression());
            boolean isNumberConversionMethod = OperatorConventions.NUMBER_CONVERSIONS.contains(resultingDescriptorName);
            return this.createConstant(result2, expectedType, new CompileTimeConstant.Parameters(canBeUsedInAnnotation, !isNumberConversionMethod && isArgumentPure, usesVariableAsConstant, usesNonConstValAsConstant));
        }
        if (argumentsEntrySet.size() == 1) {
            CompileTimeConstant compileTimeConstant;
            void parameter;
            void argument;
            Map.Entry $receiver$iv;
            Map.Entry canBeUsedInAnnotation;
            Map.Entry usesVariableAsConstant = canBeUsedInAnnotation = (Map.Entry)CollectionsKt.first((Iterable)argumentsEntrySet);
            ValueParameterDescriptor result2 = (ValueParameterDescriptor)$receiver$iv.getKey();
            $receiver$iv = canBeUsedInAnnotation;
            ResolvedValueArgument isArgumentPure = (ResolvedValueArgument)$receiver$iv.getValue();
            canBeUsedInAnnotation = null;
            void v6 = argument;
            Intrinsics.checkExpressionValueIsNotNull(v6, "argument");
            void v7 = parameter;
            Intrinsics.checkExpressionValueIsNotNull(v7, "parameter");
            OperationArgument operationArgument2 = this.createOperationArgumentForFirstParameter((ResolvedValueArgument)v6, (ValueParameterDescriptor)v7);
            if (operationArgument2 == null) {
                return null;
            }
            OperationArgument argumentForParameter = operationArgument2;
            String string = resultingDescriptorName.asString();
            Intrinsics.checkExpressionValueIsNotNull(string, "resultingDescriptorName.asString()");
            if (this.isDivisionByZero(string, argumentForParameter.getValue())) {
                KtExpression ktExpression = PsiTreeUtil.getParentOfType((PsiElement)receiverExpression, KtExpression.class);
                if (ktExpression == null) {
                    Intrinsics.throwNpe();
                }
                KtExpression parentExpression = ktExpression;
                this.trace.report(Errors.DIVISION_BY_ZERO.on((KtExpression)((PsiElement)parentExpression)));
                return ConstantExpressionEvaluatorVisitor.wrap$default(this, this.factory.createErrorValue("Division by zero"), false, false, false, false, 15, null);
            }
            String string2 = resultingDescriptorName.asString();
            Intrinsics.checkExpressionValueIsNotNull(string2, "resultingDescriptorName.asString()");
            Object object = this.evaluateBinaryAndCheck(argumentForReceiver, argumentForParameter, string2, callExpression);
            if (object == null) {
                return null;
            }
            Object result3 = object;
            boolean areArgumentsPure = this.isPureConstant(argumentForReceiver.getExpression()) && this.isPureConstant(argumentForParameter.getExpression());
            boolean canBeUsedInAnnotation2 = this.canBeUsedInAnnotation(argumentForReceiver.getExpression()) && this.canBeUsedInAnnotation(argumentForParameter.getExpression());
            boolean usesVariableAsConstant2 = this.usesVariableAsConstant(argumentForReceiver.getExpression()) || this.usesVariableAsConstant(argumentForParameter.getExpression());
            boolean usesNonConstValAsConstant = this.usesNonConstValAsConstant(argumentForReceiver.getExpression()) || this.usesNonConstValAsConstant(argumentForParameter.getExpression());
            CompileTimeConstant.Parameters parameters2 = new CompileTimeConstant.Parameters(canBeUsedInAnnotation2, areArgumentsPure, usesVariableAsConstant2, usesNonConstValAsConstant);
            Name name = resultingDescriptorName;
            if (Intrinsics.areEqual(name, OperatorNameConventions.COMPARE_TO)) {
                ConstantValue constantValue = ConstantExpressionEvaluatorKt.access$createCompileTimeConstantForCompareTo(result3, callExpression, this.factory);
                compileTimeConstant = constantValue != null ? this.wrap(constantValue, parameters2) : null;
            } else if (Intrinsics.areEqual(name, OperatorNameConventions.EQUALS)) {
                ConstantValue constantValue = ConstantExpressionEvaluatorKt.access$createCompileTimeConstantForEquals(result3, callExpression, this.factory);
                compileTimeConstant = constantValue != null ? this.wrap(constantValue, parameters2) : null;
            } else {
                compileTimeConstant = this.createConstant(result3, expectedType, parameters2);
            }
            return compileTimeConstant;
        }
        return null;
    }

    private final boolean usesVariableAsConstant(KtExpression expression) {
        BindingContext bindingContext = this.trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull(bindingContext, "trace.bindingContext");
        CompileTimeConstant<?> compileTimeConstant = ConstantExpressionEvaluator.Companion.getConstant(expression, bindingContext);
        return compileTimeConstant != null ? compileTimeConstant.getUsesVariableAsConstant() : false;
    }

    private final boolean usesNonConstValAsConstant(KtExpression expression) {
        BindingContext bindingContext = this.trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull(bindingContext, "trace.bindingContext");
        CompileTimeConstant<?> compileTimeConstant = ConstantExpressionEvaluator.Companion.getConstant(expression, bindingContext);
        return compileTimeConstant != null ? compileTimeConstant.getUsesNonConstValAsConstant() : false;
    }

    private final boolean canBeUsedInAnnotation(KtExpression expression) {
        BindingContext bindingContext = this.trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull(bindingContext, "trace.bindingContext");
        CompileTimeConstant<?> compileTimeConstant = ConstantExpressionEvaluator.Companion.getConstant(expression, bindingContext);
        return compileTimeConstant != null ? compileTimeConstant.getCanBeUsedInAnnotations() : false;
    }

    private final boolean isPureConstant(KtExpression expression) {
        BindingContext bindingContext = this.trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull(bindingContext, "trace.bindingContext");
        CompileTimeConstant<?> compileTimeConstant = ConstantExpressionEvaluator.Companion.getConstant(expression, bindingContext);
        return compileTimeConstant != null ? compileTimeConstant.isPure() : false;
    }

    /*
     * WARNING - void declaration
     */
    private final Object evaluateUnaryAndCheck(OperationArgument receiver, String name, KtExpression callExpression) {
        Unit unit;
        Unit unit2;
        boolean value$iv;
        void check;
        void function;
        Pair<Function1<Object, Object>, Function1<Long, Long>> functions2;
        Pair<Function1<Object, Object>, Function1<Long, Long>> pair = OperationsMapGeneratedKt.getUnaryOperations().get(new UnaryOperationKey(receiver.getCtcType(), name));
        if (pair == null) {
            return null;
        }
        Pair<Function1<Object, Object>, Function1<Long, Long>> pair2 = functions2 = pair;
        Function1<Object, Object> function1 = pair2.component1();
        Function1<Long, Long> function12 = pair2.component2();
        pair2 = null;
        Object result2 = function.invoke(receiver.getValue());
        if (Intrinsics.areEqual(check, OperationsMapGeneratedKt.getEmptyUnaryFun())) {
            return result2;
        }
        boolean bl = ConstantExpressionEvaluatorKt.isIntegerType(receiver.getValue());
        if (_Assertions.ENABLED) {
            if (!value$iv) {
                String message$iv = "Only integer constants should be checked for overflow";
                throw (Throwable)((Object)new AssertionError((Object)message$iv));
            }
            unit2 = Unit.INSTANCE;
        } else {
            unit2 = Unit.INSTANCE;
        }
        value$iv = Intrinsics.areEqual(name, "minus") || Intrinsics.areEqual(name, "unaryMinus");
        if (_Assertions.ENABLED) {
            if (!value$iv) {
                String message$iv = "Only negation should be checked for overflow";
                throw (Throwable)((Object)new AssertionError((Object)message$iv));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        if (Intrinsics.areEqual(receiver.getValue(), result2)) {
            void $receiver$iv;
            PsiElement value$iv2 = callExpression;
            DiagnosticFactory0<KtExpression> diagnosticFactory0 = Errors.INTEGER_OVERFLOW;
            BindingTrace bindingTrace = this.trace;
            KtExpression ktExpression = PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtExpression.class, true);
            KtExpression ktExpression2 = ktExpression;
            if (ktExpression2 == null) {
                ktExpression2 = callExpression;
            }
            bindingTrace.report(diagnosticFactory0.on((KtExpression)((PsiElement)ktExpression2)));
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final Object evaluateBinaryAndCheck(OperationArgument receiver, OperationArgument parameter, String name, KtExpression callExpression) {
        Unit unit;
        void checker;
        Object var9_9;
        Pair<Function2<Object, Object, Object>, Function2<BigInteger, BigInteger, BigInteger>> functions2;
        Pair<Function2<Object, Object, Object>, Function2<BigInteger, BigInteger, BigInteger>> pair = OperationsMapGeneratedKt.getBinaryOperations().get(new BinaryOperationKey(receiver.getCtcType(), parameter.getCtcType(), name));
        if (pair == null) {
            return null;
        }
        Pair<Function2<Object, Object, Object>, Function2<BigInteger, BigInteger, BigInteger>> pair2 = functions2 = pair;
        Function2<Object, Object, Object> function2 = pair2.component1();
        Function2<BigInteger, BigInteger, BigInteger> function22 = pair2.component2();
        pair2 = null;
        try {
            void function;
            var9_9 = function.invoke(receiver.getValue(), parameter.getValue());
        }
        catch (Exception e) {
            var9_9 = null;
        }
        Object actualResult = var9_9;
        if (Intrinsics.areEqual(checker, OperationsMapGeneratedKt.getEmptyBinaryFun())) {
            return actualResult;
        }
        boolean bl = ConstantExpressionEvaluatorKt.isIntegerType(receiver.getValue()) && ConstantExpressionEvaluatorKt.isIntegerType(parameter.getValue());
        if (_Assertions.ENABLED) {
            void value$iv;
            if (value$iv == false) {
                String message$iv = "Only integer constants should be checked for overflow";
                throw (Throwable)((Object)new AssertionError((Object)message$iv));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        evaluateBinaryAndCheck.2 toBigInteger$ = evaluateBinaryAndCheck.2.INSTANCE;
        Object object = toBigInteger$.invoke(receiver.getValue());
        Intrinsics.checkExpressionValueIsNotNull(object, "toBigInteger(receiver.value)");
        Object object2 = toBigInteger$.invoke(parameter.getValue());
        Intrinsics.checkExpressionValueIsNotNull(object2, "toBigInteger(parameter.value)");
        BigInteger resultInBigIntegers = (BigInteger)checker.invoke(object, object2);
        if (Intrinsics.areEqual(toBigInteger$.invoke((Object)actualResult), resultInBigIntegers) ^ true) {
            void $receiver$iv;
            PsiElement $i$f$assert = callExpression;
            DiagnosticFactory0<KtExpression> diagnosticFactory0 = Errors.INTEGER_OVERFLOW;
            BindingTrace bindingTrace = this.trace;
            KtExpression ktExpression = PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtExpression.class, true);
            KtExpression ktExpression2 = ktExpression;
            if (ktExpression2 == null) {
                ktExpression2 = callExpression;
            }
            bindingTrace.report(diagnosticFactory0.on((KtExpression)((PsiElement)ktExpression2)));
        }
        return actualResult;
    }

    private final boolean isDivisionByZero(String name, Object parameter) {
        Object v = OperatorConventions.BINARY_OPERATION_NAMES.get(KtTokens.DIV);
        if (v == null) {
            Intrinsics.throwNpe();
        }
        if (Intrinsics.areEqual(name, ((Name)v).asString())) {
            if (ConstantExpressionEvaluatorKt.isIntegerType(parameter)) {
                Object object = parameter;
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Number");
                }
                return ((Number)object).longValue() == (long)0;
            }
            if (parameter instanceof Float || parameter instanceof Double) {
                Object object = parameter;
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Number");
                }
                return ((Number)object).doubleValue() == 0.0;
            }
        }
        return false;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitUnaryExpression(@NotNull KtUnaryExpression expression, @Nullable KotlinType expectedType) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        KtExpression ktExpression = expression.getBaseExpression();
        if (ktExpression == null) {
            return null;
        }
        KtExpression leftExpression = ktExpression;
        KtExpression ktExpression2 = expression.getOperationReference();
        Intrinsics.checkExpressionValueIsNotNull(ktExpression2, "expression.operationReference");
        KtExpression ktExpression3 = leftExpression;
        Intrinsics.checkExpressionValueIsNotNull(ktExpression3, "leftExpression");
        return this.evaluateCall(ktExpression2, ktExpression3, expectedType);
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression, @Nullable KotlinType expectedType) {
        CallableDescriptor callableDescriptor;
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        DeclarationDescriptor enumDescriptor = (DeclarationDescriptor)this.trace.getBindingContext().get(BindingContext.REFERENCE_TARGET, expression);
        if (enumDescriptor != null && DescriptorUtils.isEnumEntry(enumDescriptor)) {
            DeclarationDescriptor declarationDescriptor = enumDescriptor;
            if (declarationDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
            }
            return ConstantExpressionEvaluatorVisitor.wrap$default(this, this.factory.createEnumValue((ClassDescriptor)declarationDescriptor), false, false, false, false, 15, null);
        }
        KtElement ktElement = expression;
        BindingContext bindingContext = this.trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull(bindingContext, "trace.bindingContext");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(ktElement, bindingContext);
        if (resolvedCall2 != null && (callableDescriptor = resolvedCall2.getResultingDescriptor()) instanceof VariableDescriptor) {
            if (callableDescriptor instanceof PropertyDescriptor && Intrinsics.areEqual((Object)((PropertyDescriptor)callableDescriptor).getModality(), (Object)Modality.FINAL) ^ true) {
                return null;
            }
            ConstantValue<?> constantValue = ((VariableDescriptor)callableDescriptor).getCompileTimeInitializer();
            if (constantValue == null) {
                return null;
            }
            ConstantValue<?> variableInitializer = constantValue;
            return this.createConstant(variableInitializer.getValue(), expectedType, new CompileTimeConstant.Parameters(this.isPropertyCompileTimeConstant((VariableDescriptor)callableDescriptor), false, true, !((VariableDescriptor)callableDescriptor).isConst()));
        }
        return null;
    }

    private final boolean isPropertyCompileTimeConstant(VariableDescriptor descriptor2) {
        if (descriptor2.isVar()) {
            return false;
        }
        if (DescriptorUtils.isObject(descriptor2.getContainingDeclaration()) || DescriptorUtils.isStaticDeclaration(descriptor2)) {
            return ConstUtilKt.canBeUsedForConstVal(descriptor2.getType());
        }
        return false;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitQualifiedExpression(@NotNull KtQualifiedExpression expression, @Nullable KotlinType expectedType) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        KtExpression selectorExpression = expression.getSelectorExpression();
        if (selectorExpression instanceof KtCallExpression) {
            KtExpression receiverExpression;
            CompileTimeConstant<?> qualifiedCallValue = this.evaluate(selectorExpression, expectedType);
            if (qualifiedCallValue != null) {
                return qualifiedCallValue;
            }
            KtExpression calleeExpression = ((KtCallExpression)selectorExpression).getCalleeExpression();
            if (!(calleeExpression instanceof KtSimpleNameExpression)) {
                return null;
            }
            KtExpression ktExpression = receiverExpression = expression.getReceiverExpression();
            Intrinsics.checkExpressionValueIsNotNull(ktExpression, "receiverExpression");
            return this.evaluateCall(calleeExpression, ktExpression, expectedType);
        }
        if (selectorExpression instanceof KtSimpleNameExpression) {
            KtExpression ktExpression = expression.getReceiverExpression();
            Intrinsics.checkExpressionValueIsNotNull(ktExpression, "expression.receiverExpression");
            CompileTimeConstant<?> result2 = this.evaluateCall(selectorExpression, ktExpression, expectedType);
            if (result2 != null) {
                return result2;
            }
        }
        if (selectorExpression != null) {
            return this.evaluate(selectorExpression, expectedType);
        }
        return null;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitCallExpression(@NotNull KtCallExpression expression, @Nullable KotlinType expectedType) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        KtElement ktElement = expression;
        BindingContext bindingContext = this.trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull(bindingContext, "trace.bindingContext");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(ktElement, bindingContext);
        if (resolvedCall2 == null) {
            return null;
        }
        ResolvedCall<? extends CallableDescriptor> call = resolvedCall2;
        CallableDescriptor resultingDescriptor = call.getResultingDescriptor();
        if (CompileTimeConstantUtils.isArrayMethodCall(call)) {
            boolean bl;
            boolean bl2;
            boolean bl3;
            boolean bl4;
            ConstantExpressionEvaluatorVisitor constantExpressionEvaluatorVisitor;
            Object object;
            block11: {
                boolean bl5;
                CompileTimeConstant it;
                List arguments2;
                Iterable $receiver$iv;
                block10: {
                    Collection collection;
                    Collection destination$iv$iv;
                    Object it2;
                    Iterable $receiver$iv$iv;
                    KotlinType kotlinType = CollectionsKt.first(resultingDescriptor.getValueParameters()).getVarargElementType();
                    if (kotlinType == null) {
                        Intrinsics.throwNpe();
                    }
                    KotlinType varargType = kotlinType;
                    Iterable iterable = call.getValueArguments().values();
                    Iterator iterator2 = $receiver$iv;
                    Collection collection2 = new ArrayList();
                    for (Object element$iv$iv : $receiver$iv$iv) {
                        it2 = (ResolvedValueArgument)element$iv$iv;
                        List<ValueArgument> list2 = it2.getArguments();
                        Intrinsics.checkExpressionValueIsNotNull(list2, "it.arguments");
                        Iterable list$iv$iv = this.resolveArguments(list2, varargType);
                        CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
                    }
                    arguments2 = (List)destination$iv$iv;
                    $receiver$iv = arguments2;
                    object = this.factory;
                    constantExpressionEvaluatorVisitor = this;
                    $receiver$iv$iv = $receiver$iv;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
                    for (Object item$iv$iv : $receiver$iv$iv) {
                        it2 = (CompileTimeConstant)item$iv$iv;
                        collection = destination$iv$iv;
                        ConstantValue constantValue = it2.toConstantValue(varargType);
                        collection.add(constantValue);
                    }
                    collection = (List)destination$iv$iv;
                    KotlinType kotlinType2 = resultingDescriptor.getReturnType();
                    if (kotlinType2 == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "resultingDescriptor.returnType!!");
                    $receiver$iv = arguments2;
                    bl4 = false;
                    bl3 = false;
                    object = ((ConstantValueFactory)object).createArrayValue((List<? extends ConstantValue<?>>)collection, kotlinType2);
                    for (Object element$iv : $receiver$iv) {
                        it = (CompileTimeConstant)element$iv;
                        if (!it.getUsesVariableAsConstant()) continue;
                        bl5 = true;
                        break block10;
                    }
                    bl5 = false;
                }
                bl2 = bl5;
                $receiver$iv = arguments2;
                for (Object element$iv : $receiver$iv) {
                    it = (CompileTimeConstant)element$iv;
                    if (!it.getUsesNonConstValAsConstant()) continue;
                    bl = true;
                    break block11;
                }
                bl = false;
            }
            boolean bl6 = bl;
            return ConstantExpressionEvaluatorVisitor.wrap$default(constantExpressionEvaluatorVisitor, (ConstantValue)object, bl3, bl4, bl2, bl6, 3, null);
        }
        if (resultingDescriptor instanceof ConstructorDescriptor) {
            ClassDescriptor classDescriptor = ((ConstructorDescriptor)resultingDescriptor).getContainingDeclaration();
            Intrinsics.checkExpressionValueIsNotNull(classDescriptor, "resultingDescriptor.containingDeclaration");
            ClassDescriptor classDescriptor2 = classDescriptor;
            if (DescriptorUtils.isAnnotationClass(classDescriptor2)) {
                AnnotationDescriptorImpl descriptor2 = new AnnotationDescriptorImpl(classDescriptor2.getDefaultType(), this.constantExpressionEvaluator.resolveAnnotationArguments$kotlin_compiler(call, this.trace), SourceElement.NO_SOURCE);
                return ConstantExpressionEvaluatorVisitor.wrap$default(this, new AnnotationValue(descriptor2), false, false, false, false, 15, null);
            }
        }
        return null;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitClassLiteralExpression(@NotNull KtClassLiteralExpression expression, @Nullable KotlinType expectedType) {
        KotlinType jetType;
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        KotlinType kotlinType = this.trace.getType(expression);
        if (kotlinType == null) {
            Intrinsics.throwNpe();
        }
        if ((jetType = kotlinType).isError()) {
            return null;
        }
        KotlinType kotlinType2 = jetType;
        Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "jetType");
        return ConstantExpressionEvaluatorVisitor.wrap$default(this, new KClassValue(kotlinType2), false, false, false, false, 15, null);
    }

    private final List<CompileTimeConstant<?>> resolveArguments(List<? extends ValueArgument> valueArguments2, KotlinType expectedType) {
        ArrayList<CompileTimeConstant> constants = CollectionsKt.arrayListOf(new CompileTimeConstant[0]);
        for (ValueArgument valueArgument : valueArguments2) {
            CompileTimeConstant<?> compileTimeConstant;
            KtExpression argumentExpression = valueArgument.getArgumentExpression();
            if (argumentExpression == null || (compileTimeConstant = this.evaluate(argumentExpression, expectedType)) == null) continue;
            constants.add(compileTimeConstant);
        }
        return constants;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitKtElement(@NotNull KtElement element, @Nullable KotlinType expectedType) {
        Intrinsics.checkParameterIsNotNull(element, "element");
        return null;
    }

    private final OperationArgument createOperationArgumentForReceiver(ResolvedCall<?> resolvedCall2, KtExpression expression) {
        KotlinType kotlinType = ConstantExpressionEvaluatorKt.access$getReceiverExpressionType(resolvedCall2);
        if (kotlinType == null) {
            return null;
        }
        KotlinType receiverExpressionType = kotlinType;
        CompileTimeType<? extends Object> compileTimeType = this.getCompileTimeType(receiverExpressionType);
        if (compileTimeType == null) {
            return null;
        }
        CompileTimeType<? extends Object> receiverCompileTimeType = compileTimeType;
        return this.createOperationArgument(expression, receiverExpressionType, receiverCompileTimeType);
    }

    private final OperationArgument createOperationArgumentForFirstParameter(ResolvedValueArgument argument, ValueParameterDescriptor parameter) {
        KotlinType kotlinType = parameter.getType();
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "parameter.type");
        CompileTimeType<? extends Object> compileTimeType = this.getCompileTimeType(kotlinType);
        if (compileTimeType == null) {
            return null;
        }
        CompileTimeType<? extends Object> argumentCompileTimeType = compileTimeType;
        List<ValueArgument> arguments2 = argument.getArguments();
        if (arguments2.size() != 1) {
            return null;
        }
        KtExpression ktExpression = CollectionsKt.first(arguments2).getArgumentExpression();
        if (ktExpression == null) {
            return null;
        }
        KtExpression argumentExpression = ktExpression;
        KotlinType kotlinType2 = parameter.getType();
        Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "parameter.type");
        return this.createOperationArgument(argumentExpression, kotlinType2, argumentCompileTimeType);
    }

    private final CompileTimeType<? extends Object> getCompileTimeType(KotlinType c) {
        KotlinBuiltIns builtIns = this.constantExpressionEvaluator.getBuiltIns$kotlin_compiler();
        KotlinType kotlinType = TypeUtils.makeNotNullable(c);
        return Intrinsics.areEqual(kotlinType, builtIns.getIntType()) ? ConstantExpressionEvaluatorKt.getINT() : (Intrinsics.areEqual(kotlinType, builtIns.getByteType()) ? ConstantExpressionEvaluatorKt.getBYTE() : (Intrinsics.areEqual(kotlinType, builtIns.getShortType()) ? ConstantExpressionEvaluatorKt.getSHORT() : (Intrinsics.areEqual(kotlinType, builtIns.getLongType()) ? ConstantExpressionEvaluatorKt.getLONG() : (Intrinsics.areEqual(kotlinType, builtIns.getDoubleType()) ? ConstantExpressionEvaluatorKt.getDOUBLE() : (Intrinsics.areEqual(kotlinType, builtIns.getFloatType()) ? ConstantExpressionEvaluatorKt.getFLOAT() : (Intrinsics.areEqual(kotlinType, builtIns.getCharType()) ? ConstantExpressionEvaluatorKt.getCHAR() : (Intrinsics.areEqual(kotlinType, builtIns.getBooleanType()) ? ConstantExpressionEvaluatorKt.getBOOLEAN() : (Intrinsics.areEqual(kotlinType, builtIns.getStringType()) ? ConstantExpressionEvaluatorKt.getSTRING() : (Intrinsics.areEqual(kotlinType, builtIns.getAnyType()) ? ConstantExpressionEvaluatorKt.getANY() : (CompileTimeType)null)))))))));
    }

    private final OperationArgument createOperationArgument(KtExpression expression, KotlinType expressionType, CompileTimeType<?> compileTimeType) {
        CompileTimeConstant<?> compileTimeConstant = this.constantExpressionEvaluator.evaluateExpression(expression, this.trace, expressionType);
        if (compileTimeConstant == null) {
            return null;
        }
        CompileTimeConstant<?> compileTimeConstant2 = compileTimeConstant;
        Object obj = compileTimeConstant2.getValue(expressionType);
        if (obj == null) {
            return null;
        }
        Object evaluationResult = obj;
        return new OperationArgument(evaluationResult, compileTimeType, expression);
    }

    private final CompileTimeConstant<?> createConstant(Object value, KotlinType expectedType, CompileTimeConstant.Parameters parameters2) {
        if (parameters2.isPure()) {
            KotlinType kotlinType = expectedType;
            if (kotlinType == null) {
                KotlinType kotlinType2 = TypeUtils.NO_EXPECTED_TYPE;
                kotlinType = kotlinType2;
                Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "TypeUtils.NO_EXPECTED_TYPE");
            }
            return this.createCompileTimeConstant(value, parameters2, kotlinType);
        }
        ConstantValue<?> constantValue = this.factory.createConstantValue(value);
        return constantValue != null ? this.wrap(constantValue, parameters2) : null;
    }

    private final CompileTimeConstant<?> createCompileTimeConstant(Object value, CompileTimeConstant.Parameters parameters2, KotlinType expectedType) {
        CompileTimeConstant compileTimeConstant;
        Object object = value;
        if (object instanceof Byte || object instanceof Short || object instanceof Integer || object instanceof Long) {
            Object object2 = value;
            if (object2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Number");
            }
            compileTimeConstant = this.createIntegerCompileTimeConstant(((Number)object2).longValue(), parameters2, expectedType);
        } else {
            ConstantValue<?> constantValue = this.factory.createConstantValue(value);
            compileTimeConstant = constantValue != null ? this.wrap(constantValue, parameters2) : null;
        }
        return compileTimeConstant;
    }

    private final CompileTimeConstant<?> createIntegerCompileTimeConstant(long value, CompileTimeConstant.Parameters parameters2, KotlinType expectedType) {
        if (TypeUtils.noExpectedType(expectedType) || expectedType.isError()) {
            return new IntegerValueTypeConstant(value, this.constantExpressionEvaluator.getBuiltIns$kotlin_compiler(), parameters2);
        }
        ConstantValue<?> integerValue = this.factory.createIntegerConstantValue(value, expectedType);
        if (integerValue != null) {
            return this.wrap(integerValue, parameters2);
        }
        long l = value;
        return this.wrap(l == (long)((int)value) ? (IntegerValueConstant)this.factory.createIntValue((int)value) : (IntegerValueConstant)this.factory.createLongValue(value), parameters2);
    }

    private final <T> TypedCompileTimeConstant<T> wrap(ConstantValue<? extends T> $receiver, CompileTimeConstant.Parameters parameters2) {
        return new TypedCompileTimeConstant<T>($receiver, parameters2);
    }

    private final <T> TypedCompileTimeConstant<T> wrap(ConstantValue<? extends T> $receiver, boolean canBeUsedInAnnotation, boolean isPure, boolean usesVariableAsConstant, boolean usesNonConstValAsConstant) {
        return this.wrap($receiver, new CompileTimeConstant.Parameters(canBeUsedInAnnotation, isPure, usesVariableAsConstant, usesNonConstValAsConstant));
    }

    static /* bridge */ /* synthetic */ TypedCompileTimeConstant wrap$default(ConstantExpressionEvaluatorVisitor constantExpressionEvaluatorVisitor, ConstantValue constantValue, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: wrap");
        }
        if ((n & 1) != 0) {
            boolean bl5 = bl = !(constantValue instanceof NullValue);
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        if ((n & 4) != 0) {
            bl3 = false;
        }
        if ((n & 8) != 0) {
            bl4 = false;
        }
        return constantExpressionEvaluatorVisitor.wrap(constantValue, bl, bl2, bl3, bl4);
    }

    public ConstantExpressionEvaluatorVisitor(@NotNull ConstantExpressionEvaluator constantExpressionEvaluator, @NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull(constantExpressionEvaluator, "constantExpressionEvaluator");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        this.constantExpressionEvaluator = constantExpressionEvaluator;
        this.trace = trace;
        this.factory = this.constantExpressionEvaluator.getConstantValueFactory$kotlin_compiler();
        this.stringExpressionEvaluator = new KtVisitor(this){
            final /* synthetic */ ConstantExpressionEvaluatorVisitor this$0;

            private final TypedCompileTimeConstant<String> createStringConstant(CompileTimeConstant<?> compileTimeConstant) {
                ConstantValue<?> constantValue;
                KotlinType kotlinType = TypeUtils.NO_EXPECTED_TYPE;
                Intrinsics.checkExpressionValueIsNotNull(kotlinType, "TypeUtils.NO_EXPECTED_TYPE");
                ConstantValue<?> constantValue2 = constantValue = compileTimeConstant.toConstantValue(kotlinType);
                if (constantValue2 instanceof ErrorValue || constantValue2 instanceof EnumValue) {
                    return null;
                }
                return ConstantExpressionEvaluatorVisitor.access$wrap(this.this$0, constantValue2 instanceof NullValue ? ConstantExpressionEvaluatorVisitor.access$getFactory$p(this.this$0).createStringValue("null") : ConstantExpressionEvaluatorVisitor.access$getFactory$p(this.this$0).createStringValue(String.valueOf(constantValue.getValue())), compileTimeConstant.getParameters());
            }

            @Nullable
            public final TypedCompileTimeConstant<String> evaluate(@NotNull KtStringTemplateEntry entry) {
                Intrinsics.checkParameterIsNotNull(entry, "entry");
                return (TypedCompileTimeConstant)entry.accept(this, null);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public TypedCompileTimeConstant<String> visitStringTemplateEntryWithExpression(@NotNull KtStringTemplateEntryWithExpression entry, @Nullable Void data) {
                TypedCompileTimeConstant<String> typedCompileTimeConstant;
                KtExpression expression;
                Intrinsics.checkParameterIsNotNull(entry, "entry");
                KtExpression ktExpression = entry.getExpression();
                if (ktExpression == null) {
                    return null;
                }
                KtExpression ktExpression2 = expression = ktExpression;
                Intrinsics.checkExpressionValueIsNotNull(ktExpression2, "expression");
                CompileTimeConstant<?> compileTimeConstant = this.this$0.evaluate(ktExpression2, ConstantExpressionEvaluatorVisitor.access$getConstantExpressionEvaluator$p(this.this$0).getBuiltIns$kotlin_compiler().getStringType());
                if (compileTimeConstant != null) {
                    void $receiver$iv;
                    CompileTimeConstant<?> compileTimeConstant2 = compileTimeConstant;
                    CompileTimeConstant it = (CompileTimeConstant)$receiver$iv;
                    typedCompileTimeConstant = this.createStringConstant(it);
                } else {
                    typedCompileTimeConstant = null;
                }
                return typedCompileTimeConstant;
            }

            @NotNull
            public TypedCompileTimeConstant<String> visitLiteralStringTemplateEntry(@NotNull KtLiteralStringTemplateEntry entry, @Nullable Void data) {
                Intrinsics.checkParameterIsNotNull(entry, "entry");
                ConstantValueFactory constantValueFactory = ConstantExpressionEvaluatorVisitor.access$getFactory$p(this.this$0);
                String string = entry.getText();
                Intrinsics.checkExpressionValueIsNotNull(string, "entry.text");
                return ConstantExpressionEvaluatorVisitor.wrap$default(this.this$0, constantValueFactory.createStringValue(string), false, false, false, false, 15, null);
            }

            @NotNull
            public TypedCompileTimeConstant<String> visitEscapeStringTemplateEntry(@NotNull KtEscapeStringTemplateEntry entry, @Nullable Void data) {
                Intrinsics.checkParameterIsNotNull(entry, "entry");
                ConstantValueFactory constantValueFactory = ConstantExpressionEvaluatorVisitor.access$getFactory$p(this.this$0);
                String string = entry.getUnescapedValue();
                Intrinsics.checkExpressionValueIsNotNull(string, "entry.unescapedValue");
                return ConstantExpressionEvaluatorVisitor.wrap$default(this.this$0, constantValueFactory.createStringValue(string), false, false, false, false, 15, null);
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    @NotNull
    public static final /* synthetic */ TypedCompileTimeConstant access$wrap(ConstantExpressionEvaluatorVisitor $this, ConstantValue $receiver, @NotNull CompileTimeConstant.Parameters parameters2) {
        return $this.wrap($receiver, parameters2);
    }

    @NotNull
    public static final /* synthetic */ ConstantValueFactory access$getFactory$p(ConstantExpressionEvaluatorVisitor $this) {
        return $this.factory;
    }

    @NotNull
    public static final /* synthetic */ ConstantExpressionEvaluator access$getConstantExpressionEvaluator$p(ConstantExpressionEvaluatorVisitor $this) {
        return $this.constantExpressionEvaluator;
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0015\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluatorVisitor$OperationArgument;", "", "value", "ctcType", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/CompileTimeType;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "(Ljava/lang/Object;Lorg/jetbrains/kotlin/resolve/constants/evaluate/CompileTimeType;Lorg/jetbrains/kotlin/psi/KtExpression;)V", "getCtcType", "()Lorg/jetbrains/kotlin/resolve/constants/evaluate/CompileTimeType;", "getExpression", "()Lorg/jetbrains/kotlin/psi/KtExpression;", "getValue", "()Ljava/lang/Object;", "kotlin-compiler"})
    private static final class OperationArgument {
        @NotNull
        private final Object value;
        @NotNull
        private final CompileTimeType<?> ctcType;
        @NotNull
        private final KtExpression expression;

        @NotNull
        public final Object getValue() {
            return this.value;
        }

        @NotNull
        public final CompileTimeType<?> getCtcType() {
            return this.ctcType;
        }

        @NotNull
        public final KtExpression getExpression() {
            return this.expression;
        }

        public OperationArgument(@NotNull Object value, @NotNull CompileTimeType<?> ctcType, @NotNull KtExpression expression) {
            Intrinsics.checkParameterIsNotNull(value, "value");
            Intrinsics.checkParameterIsNotNull(ctcType, "ctcType");
            Intrinsics.checkParameterIsNotNull(expression, "expression");
            this.value = value;
            this.ctcType = ctcType;
            this.expression = expression;
        }
    }
}

