/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xsltDebugger.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.Alarm;
import com.intellij.util.ui.tree.TreeModelAdapter;
import com.intellij.util.ui.tree.TreeUtil;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class SmartStructureTracker
extends TreeModelAdapter {
    private final JTree myEventTree;
    private final Alarm myAlarm;

    public SmartStructureTracker(JTree eventTree, Disposable disposable) {
        this.myEventTree = eventTree;
        this.myAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, disposable);
    }

    public void treeNodesInserted(TreeModelEvent e) {
        final TreePath path = e.getTreePath();
        final Object child = e.getChildren()[0];
        if (path != null && child != null) {
            this.myAlarm.cancelAllRequests();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    SmartStructureTracker.this.myEventTree.expandPath(path);
                    TreeUtil.showRowCentered((JTree)SmartStructureTracker.this.myEventTree, (int)SmartStructureTracker.this.myEventTree.getRowForPath(TreeUtil.getPathFromRoot((TreeNode)((TreeNode)child))), (boolean)false);
                }
            };
            this.myAlarm.addRequest(runnable, 300);
        }
    }

    public void treeNodesRemoved(TreeModelEvent e) {
        final TreePath p = e.getTreePath();
        if (p != null && p.getPathCount() > 1) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    DefaultMutableTreeNode last = (DefaultMutableTreeNode)p.getLastPathComponent();
                    if (last.getChildCount() > 0) {
                        for (DefaultMutableTreeNode next = (DefaultMutableTreeNode)last.getFirstChild(); next != null; next = next.getNextSibling()) {
                            boolean collapse = true;
                            if (!collapse) continue;
                            SmartStructureTracker.this.myEventTree.collapsePath(TreeUtil.getPathFromRoot((TreeNode)next));
                        }
                    }
                }
            };
            ApplicationManager.getApplication().invokeLater(runnable);
        }
    }
}

