/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.schema.extract;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import org.gradle.api.Nullable;
import org.gradle.model.ModelMap;
import org.gradle.model.collection.internal.ChildNodeInitializerStrategyAccessors;
import org.gradle.model.collection.internal.ModelMapModelProjection;
import org.gradle.model.internal.core.ChildNodeInitializerStrategy;
import org.gradle.model.internal.core.ModelAction;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelProjection;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.ModelViews;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.NodeInitializer;
import org.gradle.model.internal.core.NodeInitializerRegistry;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.inspect.ManagedChildNodeCreatorStrategy;
import org.gradle.model.internal.manage.schema.ModelCollectionSchema;
import org.gradle.model.internal.manage.schema.extract.CollectionNodeInitializerExtractionSupport;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelMapNodeInitializerExtractionStrategy
extends CollectionNodeInitializerExtractionSupport {
    private static final ModelType<ModelMap<?>> MODEL_MAP_MODEL_TYPE = new ModelType<ModelMap<?>>(){};
    private final NodeInitializerRegistry nodeInitializerRegistry;

    public ModelMapNodeInitializerExtractionStrategy(NodeInitializerRegistry nodeInitializerRegistry) {
        this.nodeInitializerRegistry = nodeInitializerRegistry;
    }

    @Override
    protected <T, E> NodeInitializer extractNodeInitializer(ModelCollectionSchema<T, E> schema) {
        if (MODEL_MAP_MODEL_TYPE.isAssignableFrom(schema.getType())) {
            if (!this.nodeInitializerRegistry.hasNodeInitializer(schema.getElementType())) {
                return null;
            }
            return new ModelMapNodeInitializer<T, E>(schema);
        }
        return null;
    }

    @Override
    public Iterable<ModelType<?>> supportedTypes() {
        return ImmutableList.of(MODEL_MAP_MODEL_TYPE);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ModelMapNodeInitializer<T, E>
    implements NodeInitializer {
        private final ModelCollectionSchema<T, E> schema;

        public ModelMapNodeInitializer(ModelCollectionSchema<T, E> schema) {
            this.schema = schema;
        }

        @Override
        public List<? extends ModelReference<?>> getInputs() {
            return Collections.singletonList(ModelReference.of(NodeInitializerRegistry.class));
        }

        @Override
        public void execute(MutableModelNode modelNode, List<ModelView<?>> inputs) {
            NodeInitializerRegistry nodeInitializerRegistry = ModelViews.assertType(inputs.get(0), NodeInitializerRegistry.class).getInstance();
            ManagedChildNodeCreatorStrategy childCreator = new ManagedChildNodeCreatorStrategy(nodeInitializerRegistry);
            modelNode.setPrivateData(ChildNodeInitializerStrategy.class, childCreator);
        }

        @Override
        public List<? extends ModelProjection> getProjections() {
            return Collections.singletonList(ModelMapModelProjection.managed(this.schema.getElementType(), ChildNodeInitializerStrategyAccessors.fromPrivateData()));
        }

        @Override
        @Nullable
        public ModelAction getProjector(ModelPath path, ModelRuleDescriptor descriptor) {
            return null;
        }
    }
}

