/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils.library;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.intellij.CommonBundle;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.NewLibraryEditor;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.ProjectBundle;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryType;
import org.jetbrains.idea.maven.utils.library.remote.MavenDependenciesRemoteManager;
import org.jetbrains.idea.maven.utils.library.remote.MavenRemoteTask;
import org.jetbrains.idea.maven.utils.library.remote.MavenVersionsRemoteManager;

public class RepositoryUtils {
    @NotNull
    public static final String LatestVersionId = "LATEST";
    @NotNull
    public static final String LatestVersionDisplayName = "Latest";
    @NotNull
    public static final String ReleaseVersionId = "RELEASE";
    @NotNull
    public static final String ReleaseVersionDisplayName = "Release";
    @NotNull
    public static final String SnapshotVersionSuffix = "-SNAPSHOT";
    @NotNull
    public static final String DefaultVersionId = "RELEASE";

    public static boolean libraryHasSources(@Nullable Library library) {
        return library != null && library.getUrls(OrderRootType.SOURCES).length > 0;
    }

    public static boolean libraryHasSources(@Nullable LibraryEditor libraryEditor) {
        return libraryEditor != null && libraryEditor.getUrls(OrderRootType.SOURCES).length > 0;
    }

    public static boolean libraryHasJavaDocs(@Nullable Library library) {
        return library != null && library.getUrls(JavadocOrderRootType.getInstance()).length > 0;
    }

    public static boolean libraryHasJavaDocs(@Nullable LibraryEditor libraryEditor) {
        return libraryEditor != null && libraryEditor.getUrls(JavadocOrderRootType.getInstance()).length > 0;
    }

    public static String getStorageRoot(Library library, Project project) {
        return RepositoryUtils.getStorageRoot(library.getUrls(OrderRootType.CLASSES), project);
    }

    public static String getStorageRoot(String[] urls, Project project) {
        if (urls.length == 0) {
            return null;
        }
        final String localRepositoryPath = FileUtil.toSystemIndependentName((String)MavenProjectsManager.getInstance(project).getLocalRepository().getPath());
        List roots = JBIterable.of((Object[])urls).transform((Function)new Function<String, String>(){

            public String fun(String urlWithPrefix) {
                String url = StringUtil.trimStart((String)urlWithPrefix, (String)"jar://");
                return url.startsWith(localRepositoryPath) ? null : FileUtil.toSystemDependentName((String)PathUtil.getParentPath((String)url));
            }
        }).toList();
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        for (String root : roots) {
            int count = counts.get(root) != null ? (Integer)counts.get(root) : 0;
            counts.put(root, count + 1);
        }
        return Collections.max(counts.entrySet(), new Comparator<Map.Entry<String, Integer>>(){

            @Override
            public int compare(Map.Entry<String, Integer> o1, Map.Entry<String, Integer> o2) {
                return o1.getValue().compareTo(o2.getValue());
            }
        }).getKey();
    }

    public static String resolveEffectiveVersion(@NotNull Project project, @NotNull RepositoryLibraryProperties properties) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/utils/library/RepositoryUtils", "resolveEffectiveVersion"));
        }
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "org/jetbrains/idea/maven/utils/library/RepositoryUtils", "resolveEffectiveVersion"));
        }
        String version = properties.getVersion();
        boolean isLatest = LatestVersionId.equals(version);
        boolean isRelease = "RELEASE".equals(version);
        if (isLatest || isRelease) {
            Iterator iterator;
            Iterable<String> versions = MavenVersionsRemoteManager.getInstance(project).getMavenArtifactVersions(properties.getGroupId(), properties.getArtifactId());
            if (isRelease) {
                versions = Iterables.filter(versions, (Predicate)new Predicate<String>(){

                    public boolean apply(String input) {
                        return !input.endsWith(RepositoryUtils.SnapshotVersionSuffix);
                    }
                });
            }
            if ((iterator = versions.iterator()).hasNext()) {
                version = (String)iterator.next();
            }
        }
        return version;
    }

    public static void loadDependencies(final @NotNull Project project, final @NotNull LibraryEx library, boolean downloadSources, boolean downloadJavaDocs, @Nullable String copyTo) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/utils/library/RepositoryUtils", "loadDependencies"));
        }
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "org/jetbrains/idea/maven/utils/library/RepositoryUtils", "loadDependencies"));
        }
        if (library.getKind() != RepositoryLibraryType.REPOSITORY_LIBRARY_KIND) {
            return;
        }
        final RepositoryLibraryProperties properties = (RepositoryLibraryProperties)library.getProperties();
        MavenDependenciesRemoteManager.getInstance(project).downloadDependenciesAsync(properties, downloadSources, downloadJavaDocs, copyTo, new MavenRemoteTask.ResultProcessor<List<OrderRoot>>(){

            @Override
            public void process(final @Nullable List<OrderRoot> roots) {
                if (roots == null || roots.isEmpty()) {
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Messages.showErrorDialog((Project)project, (String)ProjectBundle.message("maven.downloading.failed", properties.getMavenId()), (String)CommonBundle.getErrorTitle());
                        }
                    });
                    return;
                }
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (library.isDisposed()) {
                            return;
                        }
                        AccessToken token = WriteAction.start();
                        try {
                            NewLibraryEditor editor = new NewLibraryEditor(null, (LibraryProperties)properties);
                            editor.removeAllRoots();
                            editor.addRoots((Collection)roots);
                            LibraryEx.ModifiableModelEx model = library.getModifiableModel();
                            editor.applyTo(model);
                            model.commit();
                        }
                        finally {
                            token.finish();
                        }
                    }
                });
            }
        });
    }

    public static void reloadDependencies(@NotNull Project project, @NotNull LibraryEx library) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/utils/library/RepositoryUtils", "reloadDependencies"));
        }
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "org/jetbrains/idea/maven/utils/library/RepositoryUtils", "reloadDependencies"));
        }
        RepositoryUtils.loadDependencies(project, library, RepositoryUtils.libraryHasSources((Library)library), RepositoryUtils.libraryHasJavaDocs((Library)library), RepositoryUtils.getStorageRoot((Library)library, project));
    }
}

