/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunCanceledByUserException;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.execution.MavenRunConfiguration;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

public class MavenResumeAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance(MavenResumeAction.class);
    private static final Set<String> PARAMS_DISABLING_RESUME = ContainerUtil.newHashSet((Object[])new String[]{"-rf", "-resume-from", "-pl", "-projects", "-am", "-also-make", "-amd", "-also-make-dependents"});
    public static final int STATE_INITIAL = 0;
    public static final int STATE_READING_PROJECT_LIST = 1;
    public static final int STATE_READING_PROJECT_LIST_OLD_MAVEN = 5;
    public static final int STATE_WAIT_FOR_BUILD = 2;
    public static final int STATE_WAIT_FOR______ = 3;
    public static final int STATE_WTF = -1;
    private final ProgramRunner myRunner;
    private final ExecutionEnvironment myEnvironment;
    private int myState = 0;
    private int myBuildingProjectIndex = 0;
    private final List<String> myMavenProjectNames = new ArrayList<String>();
    private String myResumeFromModuleName;
    private String myResumeModuleId;

    public MavenResumeAction(ProcessHandler processHandler, ProgramRunner runner, ExecutionEnvironment environment) {
        super("Resume build from specified module", null, AllIcons.RunConfigurations.RerunFailedTests);
        this.myRunner = runner;
        this.myEnvironment = environment;
        final MavenRunConfiguration runConfiguration = (MavenRunConfiguration)environment.getRunProfile();
        this.getTemplatePresentation().setEnabled(false);
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(ProcessEvent event) {
                if (MavenResumeAction.this.myState == -1) {
                    return;
                }
                if (event.getExitCode() == 0 && MavenResumeAction.this.myBuildingProjectIndex != MavenResumeAction.this.myMavenProjectNames.size()) {
                    MavenResumeAction.log(String.format("Build was success, but not all project was build. Project build order: %s, build index: %d", MavenResumeAction.this.myMavenProjectNames, MavenResumeAction.this.myBuildingProjectIndex));
                }
                if (event.getExitCode() == 1 && MavenResumeAction.this.myBuildingProjectIndex > 0) {
                    if (MavenResumeAction.this.myBuildingProjectIndex == 1 && !MavenResumeAction.hasResumeFromParameter(runConfiguration)) {
                        return;
                    }
                    MavenResumeAction.this.myResumeFromModuleName = (String)MavenResumeAction.this.myMavenProjectNames.get(MavenResumeAction.this.myBuildingProjectIndex - 1);
                    MavenProject mavenProject = MavenResumeAction.this.findProjectByName(MavenResumeAction.this.myResumeFromModuleName);
                    if (mavenProject != null) {
                        MavenResumeAction.this.myResumeModuleId = mavenProject.getMavenId().getGroupId() + ':' + mavenProject.getMavenId().getArtifactId();
                    }
                }
            }

            public void onTextAvailable(ProcessEvent event, Key outputType) {
                if (outputType != ProcessOutputTypes.STDOUT) {
                    return;
                }
                String text = event.getText().trim();
                if (text.isEmpty()) {
                    return;
                }
                String textWithoutInfo = "";
                if (text.startsWith("[INFO] ")) {
                    textWithoutInfo = text.substring("[INFO] ".length()).trim();
                }
                switch (MavenResumeAction.this.myState) {
                    case 0: {
                        if (textWithoutInfo.equals("Reactor build order:")) {
                            MavenResumeAction.this.myState = 5;
                            break;
                        }
                        if (!textWithoutInfo.equals("Reactor Build Order:")) break;
                        MavenResumeAction.this.myState = 1;
                        break;
                    }
                    case 1: {
                        if (textWithoutInfo.equals("------------------------------------------------------------------------")) {
                            MavenResumeAction.this.myState = 2;
                            break;
                        }
                        if (textWithoutInfo.length() > 0) {
                            MavenResumeAction.this.myMavenProjectNames.add(textWithoutInfo);
                            break;
                        }
                        if (MavenResumeAction.this.myMavenProjectNames.isEmpty()) break;
                        MavenResumeAction.this.myState = 3;
                        break;
                    }
                    case 5: {
                        if (textWithoutInfo.length() <= 0) break;
                        if (text.startsWith("[INFO]   ")) {
                            MavenResumeAction.this.myMavenProjectNames.add(textWithoutInfo);
                            break;
                        }
                        MavenResumeAction.this.myState = 2;
                        break;
                    }
                    case 2: {
                        if (textWithoutInfo.startsWith("Building ")) {
                            String projectName = textWithoutInfo.substring("Building ".length());
                            if (MavenResumeAction.this.myBuildingProjectIndex >= MavenResumeAction.this.myMavenProjectNames.size() || !projectName.startsWith((String)MavenResumeAction.this.myMavenProjectNames.get(MavenResumeAction.this.myBuildingProjectIndex))) {
                                MavenResumeAction.this.myState = -1;
                                MavenResumeAction.log(String.format("Invalid project building order. Defined order: %s, error index: %d, invalid line: %s", MavenResumeAction.this.myMavenProjectNames, MavenResumeAction.this.myBuildingProjectIndex, text));
                                break;
                            }
                            MavenResumeAction.this.myBuildingProjectIndex++;
                        }
                        MavenResumeAction.this.myState = 3;
                        break;
                    }
                    case 3: {
                        if (!textWithoutInfo.equals("------------------------------------------------------------------------")) break;
                        MavenResumeAction.this.myState = 2;
                        break;
                    }
                    case -1: {
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
        });
    }

    private static boolean hasResumeFromParameter(MavenRunConfiguration runConfiguration) {
        List<String> goals = runConfiguration.getRunnerParameters().getGoals();
        return goals.size() > 2 && "-rf".equals(goals.get(goals.size() - 2));
    }

    @Nullable
    private MavenProject findProjectByName(@NotNull String projectName) {
        if (projectName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectName", "org/jetbrains/idea/maven/execution/MavenResumeAction", "findProjectByName"));
        }
        List<MavenProject> projects = MavenProjectsManager.getInstance(this.myEnvironment.getProject()).getProjects();
        MavenProject candidate = null;
        for (MavenProject mavenProject : projects) {
            if (!projectName.equals(mavenProject.getName())) continue;
            if (candidate == null) {
                candidate = mavenProject;
                continue;
            }
            return null;
        }
        if (candidate != null) {
            return candidate;
        }
        for (MavenProject mavenProject : projects) {
            String id = mavenProject.getMavenId().getGroupId() + ':' + mavenProject.getMavenId().getArtifactId() + ':' + mavenProject.getPackaging();
            if (!projectName.contains(id)) continue;
            if (candidate == null) {
                candidate = mavenProject;
                continue;
            }
            return null;
        }
        if (candidate != null) {
            return candidate;
        }
        for (MavenProject mavenProject : projects) {
            if (!projectName.equals(mavenProject.getMavenId().getArtifactId())) continue;
            if (candidate == null) {
                candidate = mavenProject;
                continue;
            }
            return null;
        }
        return candidate;
    }

    public static boolean isApplicable(@Nullable Project project, JavaParameters javaParameters, MavenRunConfiguration runConfiguration) {
        if (MavenResumeAction.hasResumeFromParameter(runConfiguration)) {
            MavenRunConfiguration clonedRunConf = runConfiguration.clone();
            List<String> clonedGoals = clonedRunConf.getRunnerParameters().getGoals();
            clonedGoals.remove(clonedGoals.size() - 1);
            clonedGoals.remove(clonedGoals.size() - 1);
            try {
                javaParameters = clonedRunConf.createJavaParameters(project);
            }
            catch (ExecutionException e) {
                return false;
            }
        }
        for (String params : javaParameters.getProgramParametersList().getList()) {
            if (!PARAMS_DISABLING_RESUME.contains(params)) continue;
            return false;
        }
        return true;
    }

    private static void log(String message) {
        if (ApplicationManager.getApplication().isInternal()) {
            LOG.error(message, (Throwable)new Exception());
        } else {
            LOG.warn(message, (Throwable)new Exception());
        }
    }

    public void update(AnActionEvent e) {
        if (this.myResumeFromModuleName != null && this.myResumeModuleId != null) {
            e.getPresentation().setEnabled(true);
            e.getPresentation().setText("Resume build from \"" + this.myResumeFromModuleName + "\"");
        }
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = this.myEnvironment.getProject();
        try {
            MavenRunConfiguration runConfiguration = ((MavenRunConfiguration)this.myEnvironment.getRunProfile()).clone();
            List<String> goals = runConfiguration.getRunnerParameters().getGoals();
            if (goals.size() > 2 && "-rf".equals(goals.get(goals.size() - 2))) {
                goals.set(goals.size() - 1, this.myResumeModuleId);
            } else {
                goals.add("-rf");
                goals.add(this.myResumeModuleId);
            }
            runConfiguration.getRunnerParameters().setGoals(goals);
            this.myRunner.execute(new ExecutionEnvironmentBuilder(this.myEnvironment).contentToReuse(null).runProfile((RunProfile)runConfiguration).build());
        }
        catch (RunCanceledByUserException runConfiguration) {
        }
        catch (ExecutionException e1) {
            Messages.showErrorDialog((Project)project, (String)e1.getMessage(), (String)ExecutionBundle.message((String)"restart.error.message.title", (Object[])new Object[0]));
        }
    }
}

