/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.generate;

import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiFile;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.ui.actions.generate.GenerateDomElementAction;
import com.intellij.util.xml.ui.actions.generate.GenerateDomElementProvider;
import icons.MavenIcons;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.dom.MavenDomBundle;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.generate.MavenGenerateProvider;
import org.jetbrains.idea.maven.dom.model.MavenDomParent;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.navigator.SelectMavenProjectDialog;
import org.jetbrains.idea.maven.project.MavenProject;

public class GenerateParentAction
extends GenerateDomElementAction {
    public GenerateParentAction() {
        super((GenerateDomElementProvider)new MavenGenerateProvider<MavenDomParent>(MavenDomBundle.message("generate.parent", new Object[0]), MavenDomParent.class){

            @Override
            protected MavenDomParent doGenerate(final @NotNull MavenDomProjectModel mavenModel, Editor editor) {
                if (mavenModel == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mavenModel", "org/jetbrains/idea/maven/dom/generate/GenerateParentAction$1", "doGenerate"));
                }
                SelectMavenProjectDialog d = new SelectMavenProjectDialog(editor.getProject(), null);
                if (!d.showAndGet()) {
                    return null;
                }
                final MavenProject parentProject = d.getResult();
                if (parentProject == null) {
                    return null;
                }
                return (MavenDomParent)new WriteCommandAction<MavenDomParent>(editor.getProject(), this.getDescription(), new PsiFile[0]){

                    protected void run(@NotNull Result result) throws Throwable {
                        if (result == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/idea/maven/dom/generate/GenerateParentAction$1$1", "run"));
                        }
                        result.setResult((Object)MavenDomUtil.updateMavenParent(mavenModel, parentProject));
                    }
                }.execute().getResultObject();
            }

            @Override
            protected boolean isAvailableForModel(MavenDomProjectModel mavenModel) {
                return !DomUtil.hasXml((DomElement)mavenModel.getMavenParent());
            }
        }, MavenIcons.MavenProject);
    }

    protected boolean startInWriteAction() {
        return false;
    }
}

