/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.properties;

import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.properties.PropertyValue;
import org.tmatesoft.svn.core.wc.SVNPropertyData;

public class PropertyData {
    @Nullable
    private final PropertyValue myValue;
    @NotNull
    private final String myName;

    public PropertyData(@NotNull String name, @Nullable PropertyValue value) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/idea/svn/properties/PropertyData", "<init>"));
        }
        this.myName = name;
        this.myValue = value;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/properties/PropertyData", "getName"));
        }
        return string;
    }

    @Nullable
    public PropertyValue getValue() {
        return this.myValue;
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    public static PropertyData create(@Nullable SVNPropertyData data) {
        PropertyData result = null;
        if (data != null) {
            result = new PropertyData(data.getName(), PropertyValue.create(data.getValue()));
        }
        return result;
    }
}

