/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import gnu.classpath.ServiceFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServiceLoader<S>
implements Iterable<S> {
    private Class<S> spi;
    private ClassLoader loader;
    private List<S> cache;
    private Iterator<S> serviceIt;

    private ServiceLoader(Class<S> spi, ClassLoader loader) {
        this.spi = spi;
        this.loader = loader;
        this.cache = new ArrayList<S>();
    }

    @Override
    public Iterator<S> iterator() {
        return new Iterator<S>(){
            private Iterator<S> cacheIt;
            {
                this.cacheIt = ServiceLoader.this.cache.iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.cacheIt.hasNext()) {
                    return true;
                }
                if (ServiceLoader.this.serviceIt == null) {
                    ServiceLoader.this.serviceIt = ServiceFactory.lookupProviders(ServiceLoader.this.spi, ServiceLoader.this.loader, true);
                }
                return ServiceLoader.this.serviceIt.hasNext();
            }

            @Override
            public S next() {
                if (this.cacheIt.hasNext()) {
                    return this.cacheIt.next();
                }
                if (ServiceLoader.this.serviceIt == null) {
                    ServiceLoader.this.serviceIt = ServiceFactory.lookupProviders(ServiceLoader.this.spi, ServiceLoader.this.loader, true);
                }
                Object nextService = ServiceLoader.this.serviceIt.next();
                ServiceLoader.this.cache.add(nextService);
                return nextService;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <S> ServiceLoader<S> load(Class<S> service) {
        return ServiceLoader.load(service, Thread.currentThread().getContextClassLoader());
    }

    public static <S> ServiceLoader<S> load(Class<S> service, ClassLoader loader) {
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        return new ServiceLoader<S>(service, loader);
    }

    public static <S> ServiceLoader<S> loadInstalled(Class<S> service) {
        return ServiceLoader.load(service, ClassLoader.getSystemClassLoader().getParent());
    }

    public void reload() {
        this.cache.clear();
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[spi=" + this.spi + ",loader=" + this.loader + "]";
    }
}

