/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import gnu.java.awt.Buffers;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.math.BigInteger;

public class IndexColorModel
extends ColorModel {
    private int map_size;
    private boolean opaque;
    private int trans = -1;
    private int[] rgb;
    private BigInteger validBits = BigInteger.ZERO;

    public IndexColorModel(int bits, int size, byte[] reds, byte[] greens, byte[] blues) {
        this(bits, size, reds, greens, blues, null);
    }

    public IndexColorModel(int bits, int size, byte[] reds, byte[] greens, byte[] blues, int trans) {
        super(bits, IndexColorModel.nArray(8, trans >= 0 && trans < size ? 4 : 3), ColorSpace.getInstance(1000), trans >= 0 && trans < size, false, 1, Buffers.smallestAppropriateTransferType(bits));
        if (bits < 1) {
            throw new IllegalArgumentException("bits < 1");
        }
        if (bits > 16) {
            throw new IllegalArgumentException("bits > 16");
        }
        if (size < 1) {
            throw new IllegalArgumentException("size < 1");
        }
        this.map_size = size;
        this.rgb = this.createColorMap(bits, size);
        int i = 0;
        while (i < size) {
            this.rgb[i] = 0xFF000000 | (reds[i] & 0xFF) << 16 | (greens[i] & 0xFF) << 8 | blues[i] & 0xFF;
            ++i;
        }
        this.setTransparentPixel(trans);
        this.validBits = this.validBits.setBit(size).subtract(BigInteger.ONE);
    }

    public IndexColorModel(int bits, int size, byte[] reds, byte[] greens, byte[] blues, byte[] alphas) {
        super(bits, IndexColorModel.nArray(8, alphas == null ? 3 : 4), ColorSpace.getInstance(1000), alphas != null, false, 3, Buffers.smallestAppropriateTransferType(bits));
        if (bits < 1) {
            throw new IllegalArgumentException("bits < 1");
        }
        if (bits > 16) {
            throw new IllegalArgumentException("bits > 16");
        }
        if (size < 1) {
            throw new IllegalArgumentException("size < 1");
        }
        this.map_size = size;
        this.opaque = alphas == null;
        this.rgb = this.createColorMap(bits, size);
        if (alphas == null) {
            int i = 0;
            while (i < size) {
                this.rgb[i] = 0xFF000000 | (reds[i] & 0xFF) << 16 | (greens[i] & 0xFF) << 8 | blues[i] & 0xFF;
                ++i;
            }
            this.transparency = 1;
        } else {
            byte alphaZero = 0;
            int alphaOne = -1;
            int i = 0;
            while (i < size) {
                alphaZero = (byte)(alphaZero | alphas[i]);
                alphaOne = (byte)(alphaOne & alphas[i]);
                this.rgb[i] = (alphas[i] & 0xFF) << 24 | (reds[i] & 0xFF) << 16 | (greens[i] & 0xFF) << 8 | blues[i] & 0xFF;
                ++i;
            }
            this.transparency = alphaZero == 0 || alphaOne == -1 ? 2 : 3;
        }
        this.validBits = this.validBits.setBit(size).subtract(BigInteger.ONE);
    }

    public IndexColorModel(int bits, int size, byte[] cmap, int start, boolean hasAlpha) {
        this(bits, size, cmap, start, hasAlpha, -1);
    }

    public IndexColorModel(int bits, int size, byte[] cmap, int start, boolean hasAlpha, int trans) {
        super(bits, IndexColorModel.nArray(8, hasAlpha || trans >= 0 && trans < size ? 4 : 3), ColorSpace.getInstance(1000), hasAlpha || trans >= 0 && trans < size, false, 1, Buffers.smallestAppropriateTransferType(bits));
        if (bits < 1) {
            throw new IllegalArgumentException("bits < 1");
        }
        if (bits > 16) {
            throw new IllegalArgumentException("bits > 16");
        }
        if (size < 1) {
            throw new IllegalArgumentException("size < 1");
        }
        this.map_size = size;
        this.opaque = !hasAlpha;
        this.rgb = this.createColorMap(bits, size);
        if (hasAlpha) {
            int alphaZero = 0;
            int alphaOne = 255;
            int i = 0;
            while (i < size) {
                int alpha = cmap[4 * i + 3 + start] & 0xFF;
                alphaZero |= alpha;
                alphaOne &= alpha;
                this.rgb[i] = alpha << 24 | (cmap[4 * i + start] & 0xFF) << 16 | (cmap[4 * i + 1 + start] & 0xFF) << 8 | cmap[4 * i + 2 + start] & 0xFF;
                ++i;
            }
            this.transparency = alphaZero == 0 ? 2 : (alphaOne == 255 ? (trans != -1 ? 2 : 1) : 3);
        } else {
            int i = 0;
            while (i < size) {
                this.rgb[i] = 0xFF000000 | (cmap[3 * i + start] & 0xFF) << 16 | (cmap[3 * i + 1 + start] & 0xFF) << 8 | cmap[3 * i + 2 + start] & 0xFF;
                ++i;
            }
            if (trans != -1) {
                this.transparency = 2;
            }
        }
        this.setTransparentPixel(trans);
        this.validBits = this.validBits.setBit(size).subtract(BigInteger.ONE);
    }

    public IndexColorModel(int bits, int size, int[] cmap, int start, boolean hasAlpha, int trans, int transferType) {
        super(bits, IndexColorModel.nArray(8, 4), ColorSpace.getInstance(1000), true, false, 3, transferType);
        if (transferType != 0 && transferType != 1) {
            throw new IllegalArgumentException();
        }
        if (bits > 16) {
            throw new IllegalArgumentException("bits > 16");
        }
        if (size < 1) {
            throw new IllegalArgumentException("size < 1");
        }
        this.map_size = size;
        this.opaque = !hasAlpha;
        this.rgb = this.createColorMap(bits, size);
        if (!hasAlpha) {
            int i = 0;
            while (i < size) {
                this.rgb[i] = cmap[i + start] | 0xFF000000;
                ++i;
            }
        } else {
            System.arraycopy(cmap, start, this.rgb, 0, size);
        }
        this.setTransparentPixel(trans);
        this.validBits = this.validBits.setBit(size).subtract(BigInteger.ONE);
    }

    public IndexColorModel(int bits, int size, int[] cmap, int start, int transferType, BigInteger validBits) {
        super(bits, IndexColorModel.nArray(8, 4), ColorSpace.getInstance(1000), true, false, 3, transferType);
        if (transferType != 0 && transferType != 1) {
            throw new IllegalArgumentException();
        }
        if (bits > 16) {
            throw new IllegalArgumentException("bits > 16");
        }
        if (size < 1) {
            throw new IllegalArgumentException("size < 1");
        }
        this.map_size = size;
        this.opaque = false;
        this.trans = -1;
        this.validBits = validBits;
        this.rgb = this.createColorMap(bits, size);
        if (!this.hasAlpha) {
            int i = 0;
            while (i < size) {
                this.rgb[i] = cmap[i + start] | 0xFF000000;
                ++i;
            }
        } else {
            System.arraycopy(cmap, start, this.rgb, 0, size);
        }
    }

    public final int getMapSize() {
        return this.map_size;
    }

    public final int getTransparentPixel() {
        return this.trans;
    }

    public final void getReds(byte[] r) {
        int i = 0;
        while (i < this.map_size) {
            r[i] = (byte)((0xFF0000 & this.rgb[i]) >> 16);
            ++i;
        }
    }

    public final void getGreens(byte[] g) {
        int i = 0;
        while (i < this.map_size) {
            g[i] = (byte)((0xFF00 & this.rgb[i]) >> 8);
            ++i;
        }
    }

    public final void getBlues(byte[] b) {
        int i = 0;
        while (i < this.map_size) {
            b[i] = (byte)(0xFF & this.rgb[i]);
            ++i;
        }
    }

    public final void getAlphas(byte[] a) {
        int i = 0;
        while (i < this.map_size) {
            a[i] = i == this.trans ? (byte)0 : (byte)((0xFF000000 & this.rgb[i]) >> 24);
            ++i;
        }
    }

    public final int getRed(int pixel) {
        if (pixel < this.map_size) {
            return (0xFF0000 & this.rgb[pixel]) >> 16;
        }
        return 0;
    }

    public final int getGreen(int pixel) {
        if (pixel < this.map_size) {
            return (0xFF00 & this.rgb[pixel]) >> 8;
        }
        return 0;
    }

    public final int getBlue(int pixel) {
        if (pixel < this.map_size) {
            return 0xFF & this.rgb[pixel];
        }
        return 0;
    }

    public final int getAlpha(int pixel) {
        return this.rgb[pixel] >> 24 & 0xFF;
    }

    public final int getRGB(int pixel) {
        if (pixel >= 0 && pixel < this.map_size) {
            return this.rgb[pixel];
        }
        return 0;
    }

    public final void getRGBs(int[] rgb) {
        System.arraycopy(this.rgb, 0, rgb, 0, this.map_size);
    }

    public boolean isValid(int pixel) {
        if (pixel >= 0) {
            return this.validBits.testBit(pixel);
        }
        return false;
    }

    public boolean isValid() {
        BigInteger allbits = new BigInteger("0");
        allbits = allbits.setBit(this.map_size);
        allbits = allbits.subtract(new BigInteger("1"));
        return allbits.equals(this.validBits);
    }

    public BigInteger getValidPixels() {
        return this.validBits;
    }

    public BufferedImage convertToIntDiscrete(Raster raster, boolean forceARGB) {
        int type = forceARGB ? 2 : (this.opaque && this.trans == -1 ? 1 : 2);
        BufferedImage im = new BufferedImage(raster.width, raster.height, type);
        int x = raster.minX;
        while (x < raster.width + raster.minX) {
            int y = raster.minY;
            while (y < raster.height + raster.minY) {
                im.setRGB(x, y, this.rgb[raster.getSample(x, y, 0)]);
                ++y;
            }
            ++x;
        }
        return im;
    }

    public SampleModel createCompatibleSampleModel(int w, int h) {
        SampleModel sm = this.pixel_bits == 1 || this.pixel_bits == 2 || this.pixel_bits == 4 ? new MultiPixelPackedSampleModel(this.transferType, w, h, this.pixel_bits) : new ComponentSampleModel(this.transferType, w, h, 1, w, new int[1]);
        return sm;
    }

    private void setTransparentPixel(int t) {
        if (t >= 0 && t < this.map_size) {
            int n = t;
            this.rgb[n] = this.rgb[n] & 0xFFFFFF;
            this.trans = t;
            if (this.transparency == 1) {
                this.transparency = 2;
                this.hasAlpha = true;
            }
        }
    }

    private int[] createColorMap(int bits, int size) {
        int realSize = Math.max(256, Math.max(1 << bits, size));
        return new int[realSize];
    }
}

