/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.QueryBuilder;

public class GeoPolygonQueryBuilder
extends QueryBuilder {
    public static final String POINTS = "points";
    private final String name;
    private final List<GeoPoint> shell = new ArrayList<GeoPoint>();
    private String queryName;
    private Boolean coerce;
    private Boolean ignoreMalformed;

    public GeoPolygonQueryBuilder(String name) {
        this.name = name;
    }

    public GeoPolygonQueryBuilder addPoint(double lat, double lon) {
        return this.addPoint(new GeoPoint(lat, lon));
    }

    public GeoPolygonQueryBuilder addPoint(String geohash) {
        return this.addPoint(GeoPoint.fromGeohash(geohash));
    }

    public GeoPolygonQueryBuilder addPoint(GeoPoint point) {
        this.shell.add(point);
        return this;
    }

    public GeoPolygonQueryBuilder queryName(String queryName) {
        this.queryName = queryName;
        return this;
    }

    public GeoPolygonQueryBuilder coerce(boolean coerce) {
        this.coerce = coerce;
        return this;
    }

    public GeoPolygonQueryBuilder ignoreMalformed(boolean ignoreMalformed) {
        this.ignoreMalformed = ignoreMalformed;
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("geo_polygon");
        builder.startObject(this.name);
        builder.startArray(POINTS);
        for (GeoPoint point : this.shell) {
            builder.startArray().value(point.lon()).value(point.lat()).endArray();
        }
        builder.endArray();
        builder.endObject();
        if (this.queryName != null) {
            builder.field("_name", this.queryName);
        }
        if (this.coerce != null) {
            builder.field("coerce", (Object)this.coerce);
        }
        if (this.ignoreMalformed != null) {
            builder.field("ignore_malformed", (Object)this.ignoreMalformed);
        }
        builder.endObject();
    }
}

