/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing;

import java.io.IOException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class AllocationId
implements ToXContent {
    private final String id;
    private final String relocationId;

    AllocationId(StreamInput in) throws IOException {
        this.id = in.readString();
        this.relocationId = in.readOptionalString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        out.writeOptionalString(this.relocationId);
    }

    private AllocationId(String id, String relocationId) {
        this.id = id;
        this.relocationId = relocationId;
    }

    public static AllocationId newInitializing() {
        return new AllocationId(Strings.randomBase64UUID(), null);
    }

    public static AllocationId newTargetRelocation(AllocationId allocationId) {
        assert (allocationId.getRelocationId() != null);
        return new AllocationId(allocationId.getRelocationId(), allocationId.getId());
    }

    public static AllocationId newRelocation(AllocationId allocationId) {
        assert (allocationId.getRelocationId() == null);
        return new AllocationId(allocationId.getId(), Strings.randomBase64UUID());
    }

    public static AllocationId cancelRelocation(AllocationId allocationId) {
        assert (allocationId.getRelocationId() != null);
        return new AllocationId(allocationId.getId(), null);
    }

    public static AllocationId finishRelocation(AllocationId allocationId) {
        assert (allocationId.getRelocationId() != null);
        return new AllocationId(allocationId.getId(), null);
    }

    public String getId() {
        return this.id;
    }

    public String getRelocationId() {
        return this.relocationId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        AllocationId that = (AllocationId)o;
        if (!this.id.equals(that.id)) {
            return false;
        }
        return !(this.relocationId == null ? that.relocationId != null : !this.relocationId.equals(that.relocationId));
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + (this.relocationId != null ? this.relocationId.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "[id=" + this.id + (this.relocationId == null ? "" : ", rId=" + this.relocationId) + "]";
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("allocation_id");
        builder.field("id", this.id);
        if (this.relocationId != null) {
            builder.field("relocation_id", this.relocationId);
        }
        builder.endObject();
        return builder;
    }
}

