/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.filebuffers;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.IAnnotationModelFactory;
import org.eclipse.core.filebuffers.IDocumentFactory;
import org.eclipse.core.filebuffers.IDocumentSetupParticipant;
import org.eclipse.core.filebuffers.IFileBuffer;
import org.eclipse.core.filebuffers.IFileBufferListener;
import org.eclipse.core.filebuffers.IStateValidationSupport;
import org.eclipse.core.filebuffers.ISynchronizationContext;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.filebuffers.AbstractFileBuffer;
import org.eclipse.core.internal.filebuffers.ExtensionsRegistry;
import org.eclipse.core.internal.filebuffers.FileBuffersMessages;
import org.eclipse.core.internal.filebuffers.FileBuffersPlugin;
import org.eclipse.core.internal.filebuffers.JavaTextFileBuffer;
import org.eclipse.core.internal.filebuffers.NLSUtility;
import org.eclipse.core.internal.filebuffers.ResourceTextFileBuffer;
import org.eclipse.core.internal.filebuffers.SynchronizableDocument;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.source.IAnnotationModel;

public class TextFileBufferManager
implements ITextFileBufferManager {
    private Map fFilesBuffers = new HashMap();
    private List fFileBufferListeners = new ArrayList();
    private ExtensionsRegistry fRegistry = new ExtensionsRegistry();
    private ISynchronizationContext fSynchronizationContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(IPath location, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull((Object)location);
        location = FileBuffers.normalizeLocation(location);
        AbstractFileBuffer fileBuffer = null;
        Map map = this.fFilesBuffers;
        synchronized (map) {
            fileBuffer = (AbstractFileBuffer)this.fFilesBuffers.get(location);
            if (fileBuffer != null) {
                fileBuffer.connect();
                return;
            }
        }
        fileBuffer = this.createFileBuffer(location);
        if (fileBuffer == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.core.filebuffers", 2, FileBuffersMessages.FileBufferManager_error_canNotCreateFilebuffer, null));
        }
        fileBuffer.create(location, monitor);
        map = this.fFilesBuffers;
        synchronized (map) {
            AbstractFileBuffer oldFileBuffer = (AbstractFileBuffer)this.fFilesBuffers.get(location);
            if (oldFileBuffer != null) {
                fileBuffer.disconnect();
                fileBuffer.dispose();
                oldFileBuffer.connect();
                return;
            }
            fileBuffer.connect();
            this.fFilesBuffers.put(location, fileBuffer);
        }
        this.fireBufferCreated(fileBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(IPath location, IProgressMonitor monitor) throws CoreException {
        AbstractFileBuffer fileBuffer;
        Assert.isNotNull((Object)location);
        location = FileBuffers.normalizeLocation(location);
        Map map = this.fFilesBuffers;
        synchronized (map) {
            fileBuffer = (AbstractFileBuffer)this.fFilesBuffers.get(location);
            if (fileBuffer == null) {
                return;
            }
            fileBuffer.disconnect();
            if (!fileBuffer.isDisconnected()) {
                return;
            }
            this.fFilesBuffers.remove(location);
        }
        this.fireBufferDisposed(fileBuffer);
        fileBuffer.dispose();
    }

    public boolean isTextFileLocation(IPath location) {
        return this.isTextFileLocation(location, false);
    }

    /*
     * Loose catch block
     */
    public boolean isTextFileLocation(IPath location, boolean strict) {
        block32: {
            IFileStore externalFile;
            IContentType text;
            IContentTypeManager manager;
            block33: {
                block34: {
                    InputStream is;
                    block31: {
                        block29: {
                            boolean bl;
                            block30: {
                                IContentType type;
                                Assert.isNotNull((Object)location);
                                location = FileBuffers.normalizeLocation(location);
                                manager = Platform.getContentTypeManager();
                                text = manager.getContentType("org.eclipse.core.runtime.text");
                                IFile file = FileBuffers.getWorkspaceFileAtLocation(location);
                                if (file != null) {
                                    if (file.exists()) {
                                        try {
                                            IContentType type2;
                                            IContentDescription description = file.getContentDescription();
                                            if (description != null && (type2 = description.getContentType()) != null) {
                                                return type2.isKindOf(text);
                                            }
                                        }
                                        catch (CoreException coreException) {}
                                    } else {
                                        IContentType[] contentTypes = manager.findContentTypesFor(file.getName());
                                        if (contentTypes != null && contentTypes.length > 0) {
                                            int i = 0;
                                            while (i < contentTypes.length) {
                                                if (contentTypes[i].isKindOf(text)) {
                                                    return true;
                                                }
                                                ++i;
                                            }
                                            return false;
                                        }
                                    }
                                    return !strict;
                                }
                                externalFile = FileBuffers.getFileStoreAtLocation(location);
                                if (externalFile == null) break block32;
                                IFileInfo fileInfo = externalFile.fetchInfo();
                                if (!fileInfo.exists()) break block33;
                                is = null;
                                is = externalFile.openInputStream(0, null);
                                IContentDescription description = manager.getDescriptionFor(is, externalFile.getName(), IContentDescription.ALL);
                                if (description == null || (type = description.getContentType()) == null) break block29;
                                bl = type.isKindOf(text);
                                if (is == null) break block30;
                                try {
                                    is.close();
                                }
                                catch (IOException iOException) {}
                            }
                            return bl;
                            {
                                catch (CoreException coreException) {
                                    break block31;
                                }
                                catch (IOException iOException) {
                                    break block31;
                                }
                            }
                            catch (Throwable throwable) {
                                if (is != null) {
                                    try {
                                        is.close();
                                    }
                                    catch (IOException iOException) {}
                                }
                                throw throwable;
                            }
                        }
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block34;
                    }
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                return !strict;
            }
            IContentType[] contentTypes = manager.findContentTypesFor(externalFile.getName());
            if (contentTypes != null && contentTypes.length > 0) {
                int i = 0;
                while (i < contentTypes.length) {
                    if (contentTypes[i].isKindOf(text)) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
            return !strict;
        }
        return false;
    }

    public IFileBuffer getFileBuffer(IPath location) {
        location = FileBuffers.normalizeLocation(location);
        return this.internalGetFileBuffer(location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractFileBuffer internalGetFileBuffer(IPath location) {
        Map map = this.fFilesBuffers;
        synchronized (map) {
            return (AbstractFileBuffer)this.fFilesBuffers.get(location);
        }
    }

    public ITextFileBuffer getTextFileBuffer(IPath location) {
        return (ITextFileBuffer)this.getFileBuffer(location);
    }

    public String getDefaultEncoding() {
        return ResourcesPlugin.getEncoding();
    }

    public IDocument createEmptyDocument(IPath location) {
        IDocumentSetupParticipant[] participants;
        String initalLineDelimiter;
        IDocumentFactory factory;
        final IDocument[] runnableResult = new IDocument[1];
        if (location != null && (factory = this.fRegistry.getDocumentFactory(location = FileBuffers.normalizeLocation(location))) != null) {
            ISafeRunnable runnable = new ISafeRunnable(){

                public void run() throws Exception {
                    runnableResult[0] = factory.createDocument();
                }

                public void handleException(Throwable t) {
                    Status status = new Status(4, "org.eclipse.core.filebuffers", 0, FileBuffersMessages.TextFileBufferManager_error_documentFactoryFailed, t);
                    FileBuffersPlugin.getDefault().getLog().log((IStatus)status);
                    if (t instanceof VirtualMachineError) {
                        throw (VirtualMachineError)t;
                    }
                }
            };
            SafeRunner.run((ISafeRunnable)runnable);
        }
        Object document = runnableResult[0] != null ? runnableResult[0] : new SynchronizableDocument();
        if (location == null) {
            return document;
        }
        if (document instanceof IDocumentExtension4 && (initalLineDelimiter = this.getLineDelimiterPreference(location)) != null) {
            ((IDocumentExtension4)document).setInitialLineDelimiter(initalLineDelimiter);
        }
        if ((participants = this.fRegistry.getDocumentSetupParticipants(location)) != null) {
            int i = 0;
            while (i < participants.length) {
                final IDocumentSetupParticipant participant = participants[i];
                ISafeRunnable runnable = new ISafeRunnable((IDocument)document){
                    private final /* synthetic */ IDocument val$document;
                    {
                        this.val$document = iDocument;
                    }

                    public void run() throws Exception {
                        participant.setup(this.val$document);
                        if (this.val$document.getDocumentPartitioner() != null) {
                            String message = NLSUtility.format(FileBuffersMessages.TextFileBufferManager_warning_documentSetupInstallsDefaultPartitioner, participant.getClass());
                            Status status = new Status(2, "org.eclipse.core.filebuffers", 0, message, null);
                            FileBuffersPlugin.getDefault().getLog().log((IStatus)status);
                        }
                    }

                    public void handleException(Throwable t) {
                        Status status = new Status(4, "org.eclipse.core.filebuffers", 0, FileBuffersMessages.TextFileBufferManager_error_documentSetupFailed, t);
                        FileBuffersPlugin.getDefault().getLog().log((IStatus)status);
                        if (t instanceof VirtualMachineError) {
                            throw (VirtualMachineError)t;
                        }
                    }
                };
                SafeRunner.run((ISafeRunnable)runnable);
                ++i;
            }
        }
        return document;
    }

    public IAnnotationModel createAnnotationModel(IPath location) {
        Assert.isNotNull((Object)location);
        location = FileBuffers.normalizeLocation(location);
        IAnnotationModelFactory factory = this.fRegistry.getAnnotationModelFactory(location);
        if (factory != null) {
            return factory.createAnnotationModel(location);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFileBufferListener(IFileBufferListener listener) {
        Assert.isNotNull((Object)listener);
        List list = this.fFileBufferListeners;
        synchronized (list) {
            if (!this.fFileBufferListeners.contains(listener)) {
                this.fFileBufferListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFileBufferListener(IFileBufferListener listener) {
        Assert.isNotNull((Object)listener);
        List list = this.fFileBufferListeners;
        synchronized (list) {
            this.fFileBufferListeners.remove(listener);
        }
    }

    public void setSynchronizationContext(ISynchronizationContext context) {
        this.fSynchronizationContext = context;
    }

    public void requestSynchronizationContext(IPath location) {
        Assert.isNotNull((Object)location);
        location = FileBuffers.normalizeLocation(location);
        AbstractFileBuffer fileBuffer = this.internalGetFileBuffer(location);
        if (fileBuffer != null) {
            fileBuffer.requestSynchronizationContext();
        }
    }

    public void releaseSynchronizationContext(IPath location) {
        Assert.isNotNull((Object)location);
        location = FileBuffers.normalizeLocation(location);
        AbstractFileBuffer fileBuffer = this.internalGetFileBuffer(location);
        if (fileBuffer != null) {
            fileBuffer.releaseSynchronizationContext();
        }
    }

    public void execute(Runnable runnable, boolean requestSynchronizationContext) {
        if (requestSynchronizationContext && this.fSynchronizationContext != null) {
            this.fSynchronizationContext.run(runnable);
        } else {
            runnable.run();
        }
    }

    private AbstractFileBuffer createFileBuffer(IPath location) {
        if (this.isTextFileLocation(location, false)) {
            return this.createTextFileBuffer(location);
        }
        return this.createBinaryFileBuffer(location);
    }

    private AbstractFileBuffer createTextFileBuffer(IPath location) {
        if (FileBuffers.getWorkspaceFileAtLocation(location) != null) {
            return new ResourceTextFileBuffer(this);
        }
        return new JavaTextFileBuffer(this);
    }

    private AbstractFileBuffer createBinaryFileBuffer(IPath location) {
        return this.createTextFileBuffer(location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterator getFileBufferListenerIterator() {
        List list = this.fFileBufferListeners;
        synchronized (list) {
            return new ArrayList(this.fFileBufferListeners).iterator();
        }
    }

    protected void fireDirtyStateChanged(final IFileBuffer buffer, final boolean isDirty) {
        Iterator e = this.getFileBufferListenerIterator();
        while (e.hasNext()) {
            final IFileBufferListener l = (IFileBufferListener)e.next();
            SafeRunner.run((ISafeRunnable)new SafeNotifier(){

                public void run() {
                    l.dirtyStateChanged(buffer, isDirty);
                }
            });
        }
    }

    protected void fireBufferContentAboutToBeReplaced(final IFileBuffer buffer) {
        Iterator e = this.getFileBufferListenerIterator();
        while (e.hasNext()) {
            final IFileBufferListener l = (IFileBufferListener)e.next();
            SafeRunner.run((ISafeRunnable)new SafeNotifier(){

                public void run() {
                    l.bufferContentAboutToBeReplaced(buffer);
                }
            });
        }
    }

    protected void fireBufferContentReplaced(final IFileBuffer buffer) {
        Iterator e = this.getFileBufferListenerIterator();
        while (e.hasNext()) {
            final IFileBufferListener l = (IFileBufferListener)e.next();
            SafeRunner.run((ISafeRunnable)new SafeNotifier(){

                public void run() {
                    l.bufferContentReplaced(buffer);
                }
            });
        }
    }

    protected void fireUnderlyingFileMoved(final IFileBuffer buffer, final IPath target) {
        Iterator e = this.getFileBufferListenerIterator();
        while (e.hasNext()) {
            final IFileBufferListener l = (IFileBufferListener)e.next();
            SafeRunner.run((ISafeRunnable)new SafeNotifier(){

                public void run() {
                    l.underlyingFileMoved(buffer, target);
                }
            });
        }
    }

    protected void fireUnderlyingFileDeleted(final IFileBuffer buffer) {
        Iterator e = this.getFileBufferListenerIterator();
        while (e.hasNext()) {
            final IFileBufferListener l = (IFileBufferListener)e.next();
            SafeRunner.run((ISafeRunnable)new SafeNotifier(){

                public void run() {
                    l.underlyingFileDeleted(buffer);
                }
            });
        }
    }

    protected void fireStateValidationChanged(final IFileBuffer buffer, final boolean isStateValidated) {
        Iterator e = this.getFileBufferListenerIterator();
        while (e.hasNext()) {
            final IFileBufferListener l = (IFileBufferListener)e.next();
            SafeRunner.run((ISafeRunnable)new SafeNotifier(){

                public void run() {
                    l.stateValidationChanged(buffer, isStateValidated);
                }
            });
        }
    }

    protected void fireStateChanging(final IFileBuffer buffer) {
        Iterator e = this.getFileBufferListenerIterator();
        while (e.hasNext()) {
            final IFileBufferListener l = (IFileBufferListener)e.next();
            SafeRunner.run((ISafeRunnable)new SafeNotifier(){

                public void run() {
                    l.stateChanging(buffer);
                }
            });
        }
    }

    protected void fireStateChangeFailed(final IFileBuffer buffer) {
        Iterator e = this.getFileBufferListenerIterator();
        while (e.hasNext()) {
            final IFileBufferListener l = (IFileBufferListener)e.next();
            SafeRunner.run((ISafeRunnable)new SafeNotifier(){

                public void run() {
                    l.stateChangeFailed(buffer);
                }
            });
        }
    }

    protected void fireBufferCreated(final IFileBuffer buffer) {
        Iterator e = this.getFileBufferListenerIterator();
        while (e.hasNext()) {
            final IFileBufferListener l = (IFileBufferListener)e.next();
            SafeRunner.run((ISafeRunnable)new SafeNotifier(){

                public void run() {
                    l.bufferCreated(buffer);
                }
            });
        }
    }

    protected void fireBufferDisposed(final IFileBuffer buffer) {
        Iterator e = this.getFileBufferListenerIterator();
        while (e.hasNext()) {
            final IFileBufferListener l = (IFileBufferListener)e.next();
            SafeRunner.run((ISafeRunnable)new SafeNotifier(){

                public void run() {
                    l.bufferDisposed(buffer);
                }
            });
        }
    }

    public void validateState(final IFileBuffer[] fileBuffers, IProgressMonitor monitor, final Object computationContext) throws CoreException {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor progressMonitor) throws CoreException {
                IFileBuffer[] toValidate = TextFileBufferManager.this.findFileBuffersToValidate(fileBuffers);
                TextFileBufferManager.this.validationStateAboutToBeChanged(toValidate);
                try {
                    IStatus status = TextFileBufferManager.this.validateEdit(toValidate, computationContext);
                    TextFileBufferManager.this.validationStateChanged(toValidate, true, status);
                }
                catch (RuntimeException runtimeException) {
                    TextFileBufferManager.this.validationStateChangedFailed(toValidate);
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, this.computeValidateStateRule(fileBuffers), 1, monitor);
    }

    private IFileBuffer[] findFileBuffersToValidate(IFileBuffer[] fileBuffers) {
        ArrayList<IFileBuffer> list = new ArrayList<IFileBuffer>();
        int i = 0;
        while (i < fileBuffers.length) {
            if (!fileBuffers[i].isStateValidated()) {
                list.add(fileBuffers[i]);
            }
            ++i;
        }
        return list.toArray(new IFileBuffer[list.size()]);
    }

    private void validationStateAboutToBeChanged(IFileBuffer[] fileBuffers) {
        int i = 0;
        while (i < fileBuffers.length) {
            if (fileBuffers[i] instanceof IStateValidationSupport) {
                IStateValidationSupport support = (IStateValidationSupport)((Object)fileBuffers[i]);
                support.validationStateAboutToBeChanged();
            }
            ++i;
        }
    }

    private void validationStateChanged(IFileBuffer[] fileBuffers, boolean validationState, IStatus status) {
        int i = 0;
        while (i < fileBuffers.length) {
            if (fileBuffers[i] instanceof IStateValidationSupport) {
                IStateValidationSupport support = (IStateValidationSupport)((Object)fileBuffers[i]);
                support.validationStateChanged(validationState, status);
            }
            ++i;
        }
    }

    private void validationStateChangedFailed(IFileBuffer[] fileBuffers) {
        int i = 0;
        while (i < fileBuffers.length) {
            if (fileBuffers[i] instanceof IStateValidationSupport) {
                IStateValidationSupport support = (IStateValidationSupport)((Object)fileBuffers[i]);
                support.validationStateChangeFailed();
            }
            ++i;
        }
    }

    private IStatus validateEdit(IFileBuffer[] fileBuffers, Object computationContext) {
        ArrayList<IFile> list = new ArrayList<IFile>();
        int i = 0;
        while (i < fileBuffers.length) {
            IFile file = this.getWorkspaceFile(fileBuffers[i]);
            if (file != null) {
                list.add(file);
            }
            ++i;
        }
        IFile[] files = new IFile[list.size()];
        list.toArray(files);
        return ResourcesPlugin.getWorkspace().validateEdit(files, computationContext);
    }

    private ISchedulingRule computeValidateStateRule(IFileBuffer[] fileBuffers) {
        ArrayList<IFile> list = new ArrayList<IFile>();
        int i = 0;
        while (i < fileBuffers.length) {
            IFile resource = this.getWorkspaceFile(fileBuffers[i]);
            if (resource != null) {
                list.add(resource);
            }
            ++i;
        }
        IResource[] resources = new IResource[list.size()];
        list.toArray(resources);
        IResourceRuleFactory factory = ResourcesPlugin.getWorkspace().getRuleFactory();
        return factory.validateEditRule(resources);
    }

    private IFile getWorkspaceFile(IFileBuffer fileBuffer) {
        return FileBuffers.getWorkspaceFileAtLocation(fileBuffer.getLocation());
    }

    private String getLineDelimiterPreference(IPath location) {
        IScopeContext[] scopeContext;
        IFile file = FileBuffers.getWorkspaceFileAtLocation(location);
        if (file != null && file.getProject() != null) {
            scopeContext = new IScopeContext[]{new ProjectScope(file.getProject())};
            String lineDelimiter = Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", null, scopeContext);
            if (lineDelimiter != null) {
                return lineDelimiter;
            }
        }
        scopeContext = new IScopeContext[]{new InstanceScope()};
        return Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", null, scopeContext);
    }

    private static abstract class SafeNotifier
    implements ISafeRunnable {
        private SafeNotifier() {
        }

        public void handleException(Throwable ex) {
            Status status = new Status(4, "org.eclipse.core.filebuffers", 0, "TextFileBufferManager failed to notify an ITextFileBufferListener", ex);
            FileBuffersPlugin.getDefault().getLog().log((IStatus)status);
        }
    }
}

