/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.ui.actions;

import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.IBreakpointManagerListener;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ISuspendResume;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugUIConstants;

public class RunToLineHandler
implements IDebugEventSetListener,
IBreakpointManagerListener,
IWorkspaceRunnable {
    private IDebugTarget fTarget;
    private ISuspendResume fResumee;
    private IBreakpoint fBreakpoint;
    private boolean fAutoSkip = false;

    public RunToLineHandler(IDebugTarget target, ISuspendResume suspendResume, IBreakpoint breakpoint) {
        this.fResumee = suspendResume;
        this.fTarget = target;
        this.fBreakpoint = breakpoint;
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            DebugEvent event = events[i];
            Object source = event.getSource();
            if (source instanceof IThread && event.getKind() == 2 && event.getDetail() == 16) {
                IThread thread = (IThread)source;
                IDebugTarget suspendee = (IDebugTarget)thread.getAdapter(IDebugTarget.class);
                if (this.fTarget.equals(suspendee)) {
                    this.cancel();
                }
            } else if (source instanceof IDebugTarget && event.getKind() == 8 && source.equals(this.fTarget)) {
                this.cancel();
            }
            ++i;
        }
    }

    public void breakpointManagerEnablementChanged(boolean enabled) {
        this.fAutoSkip = false;
    }

    private IBreakpointManager getBreakpointManager() {
        return this.getDebugPlugin().getBreakpointManager();
    }

    private DebugPlugin getDebugPlugin() {
        return DebugPlugin.getDefault();
    }

    public void cancel() {
        IBreakpointManager manager = this.getBreakpointManager();
        try {
            this.getDebugPlugin().removeDebugEventListener((IDebugEventSetListener)this);
            manager.removeBreakpointManagerListener((IBreakpointManagerListener)this);
            this.fTarget.breakpointRemoved(this.fBreakpoint, null);
        }
        finally {
            if (this.fAutoSkip) {
                manager.setEnabled(true);
            }
        }
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        this.getDebugPlugin().addDebugEventListener((IDebugEventSetListener)this);
        IBreakpointManager breakpointManager = this.getBreakpointManager();
        boolean bl = this.fAutoSkip = DebugUITools.getPreferenceStore().getBoolean(IDebugUIConstants.PREF_SKIP_BREAKPOINTS_DURING_RUN_TO_LINE) && breakpointManager.isEnabled();
        if (this.fAutoSkip) {
            this.getBreakpointManager().setEnabled(false);
            breakpointManager.addBreakpointManagerListener((IBreakpointManagerListener)this);
        }
        Job job = new Job(ActionMessages.RunToLineHandler_0){

            protected IStatus run(IProgressMonitor jobMonitor) {
                if (!jobMonitor.isCanceled()) {
                    RunToLineHandler.this.fTarget.breakpointAdded(RunToLineHandler.this.fBreakpoint);
                    try {
                        RunToLineHandler.this.fResumee.resume();
                    }
                    catch (DebugException e) {
                        this.cancel();
                        return e.getStatus();
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }
}

