/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.part;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.SubActionBars;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.PopupMenuExtender;
import org.eclipse.ui.internal.commands.SlaveCommandService;
import org.eclipse.ui.internal.contexts.NestableContextService;
import org.eclipse.ui.internal.expressions.ActivePartExpression;
import org.eclipse.ui.internal.handlers.NestableHandlerService;
import org.eclipse.ui.internal.services.INestable;
import org.eclipse.ui.internal.services.ServiceLocator;
import org.eclipse.ui.part.IPageSite;

public class PageSite
implements IPageSite,
INestable {
    private ArrayList menuExtenders;
    private IViewSite parentSite;
    private ISelectionProvider selectionProvider;
    private final ServiceLocator serviceLocator;
    private SubActionBars subActionBars;

    public PageSite(IViewSite parentViewSite) {
        Assert.isNotNull((Object)parentViewSite);
        this.parentSite = parentViewSite;
        this.subActionBars = new SubActionBars(parentViewSite.getActionBars(), this);
        this.serviceLocator = new ServiceLocator(this.parentSite);
        this.initializeDefaultServices();
    }

    private void initializeDefaultServices() {
        IWorkbenchPart parentPart = this.parentSite.getPart();
        ActivePartExpression defaultExpression = new ActivePartExpression(parentPart);
        IHandlerService parentService = (IHandlerService)this.parentSite.getService(IHandlerService.class);
        NestableHandlerService slave = new NestableHandlerService(parentService, defaultExpression);
        this.serviceLocator.registerService(IHandlerService.class, slave);
        IContextService contextParent = (IContextService)this.serviceLocator.getService(IContextService.class);
        NestableContextService contextSlave = new NestableContextService(contextParent, defaultExpression);
        this.serviceLocator.registerService(IContextService.class, contextSlave);
        ICommandService parentCommandService = (ICommandService)this.serviceLocator.getService(ICommandService.class);
        SlaveCommandService commandService = new SlaveCommandService(parentCommandService);
        this.serviceLocator.registerService(ICommandService.class, commandService);
    }

    protected void dispose() {
        if (this.menuExtenders != null) {
            int i = 0;
            while (i < this.menuExtenders.size()) {
                ((PopupMenuExtender)this.menuExtenders.get(i)).dispose();
                ++i;
            }
            this.menuExtenders = null;
        }
        this.subActionBars.dispose();
        this.serviceLocator.dispose();
    }

    public IActionBars getActionBars() {
        return this.subActionBars;
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public IWorkbenchPage getPage() {
        return this.parentSite.getPage();
    }

    public ISelectionProvider getSelectionProvider() {
        return this.selectionProvider;
    }

    public final Object getService(Class key) {
        return this.serviceLocator.getService(key);
    }

    public Shell getShell() {
        return this.parentSite.getShell();
    }

    public IWorkbenchWindow getWorkbenchWindow() {
        return this.parentSite.getWorkbenchWindow();
    }

    public final boolean hasService(Class key) {
        return this.serviceLocator.hasService(key);
    }

    public void registerContextMenu(String menuID, MenuManager menuMgr, ISelectionProvider selProvider) {
        if (this.menuExtenders == null) {
            this.menuExtenders = new ArrayList(1);
        }
        PartSite.registerContextMenu(menuID, menuMgr, selProvider, false, this.parentSite.getPart(), this.menuExtenders);
    }

    public void setSelectionProvider(ISelectionProvider provider) {
        this.selectionProvider = provider;
    }

    public void activate() {
        this.serviceLocator.activate();
    }

    public void deactivate() {
        this.serviceLocator.deactivate();
    }
}

