/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.tomcat.core.internal;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.server.tomcat.core.internal.IMimeMapping;
import org.eclipse.jst.server.tomcat.core.internal.ITomcatWebModule;
import org.eclipse.jst.server.tomcat.core.internal.Messages;
import org.eclipse.jst.server.tomcat.core.internal.ProgressUtil;
import org.eclipse.jst.server.tomcat.core.internal.TomcatConfiguration;
import org.eclipse.jst.server.tomcat.core.internal.Trace;
import org.eclipse.jst.server.tomcat.core.internal.WebAppDocument;
import org.eclipse.jst.server.tomcat.core.internal.WebModule;
import org.eclipse.jst.server.tomcat.core.internal.xml.Factory;
import org.eclipse.jst.server.tomcat.core.internal.xml.XMLUtil;
import org.eclipse.jst.server.tomcat.core.internal.xml.server40.Connector;
import org.eclipse.jst.server.tomcat.core.internal.xml.server40.Context;
import org.eclipse.jst.server.tomcat.core.internal.xml.server40.Engine;
import org.eclipse.jst.server.tomcat.core.internal.xml.server40.Host;
import org.eclipse.jst.server.tomcat.core.internal.xml.server40.Listener;
import org.eclipse.jst.server.tomcat.core.internal.xml.server40.Server;
import org.eclipse.jst.server.tomcat.core.internal.xml.server40.Service;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.ServerPort;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Tomcat41Configuration
extends TomcatConfiguration {
    protected static final String DEFAULT_SERVICE = "Tomcat-Standalone";
    protected static final String HTTP_CONNECTOR = "org.apache.coyote.tomcat4.CoyoteConnector";
    protected static final String JK_PROTOCOL_HANDLER = "org.apache.jk.server.JkCoyoteHandler";
    protected static final String SSL_SOCKET_FACTORY = "org.apache.coyote.tomcat4.CoyoteServerSocketFactory";
    protected static final String APACHE_CONNECTOR = "org.apache.catalina.connector.warp.WarpConnector";
    protected Server server;
    protected Factory serverFactory;
    protected boolean isServerDirty;
    protected WebAppDocument webAppDocument;
    protected Document tomcatUsersDocument;
    protected String policyFile;
    protected boolean isPolicyDirty;

    public Tomcat41Configuration(IFolder path) {
        super(path);
    }

    public ServerPort getMainPort() {
        Iterator iterator = this.getServerPorts().iterator();
        while (iterator.hasNext()) {
            ServerPort port = (ServerPort)iterator.next();
            if (!port.getName().equals("HTTP Connector")) continue;
            return port;
        }
        return null;
    }

    public List getMimeMappings() {
        return this.webAppDocument.getMimeMappings();
    }

    public List getServerPorts() {
        ArrayList<ServerPort> ports = new ArrayList<ServerPort>();
        try {
            int port = Integer.parseInt(this.server.getPort());
            ports.add(new ServerPort("server", Messages.portServer, port, "TCPIP"));
        }
        catch (Exception exception) {}
        try {
            int size = this.server.getServiceCount();
            int i = 0;
            while (i < size) {
                Service service = this.server.getService(i);
                int size2 = service.getConnectorCount();
                int j = 0;
                while (j < size2) {
                    String className;
                    Connector connector = service.getConnector(j);
                    String name = className = connector.getClassName();
                    String protocol = "TCPIP";
                    boolean advanced = true;
                    String[] contentTypes = null;
                    int port = -1;
                    try {
                        port = Integer.parseInt(connector.getPort());
                    }
                    catch (Exception exception) {}
                    if (HTTP_CONNECTOR.equals(className)) {
                        name = "HTTP Connector";
                        protocol = "HTTP";
                        contentTypes = new String[]{"web", "webservices"};
                        String protocolHandler = connector.getProtocolHandlerClassName();
                        if (JK_PROTOCOL_HANDLER.equals(protocolHandler)) {
                            name = "AJP/1.3 Connector";
                            protocol = "AJP/1.3";
                        } else {
                            try {
                                Element element = connector.getSubElement("Factory");
                                if (SSL_SOCKET_FACTORY.equals(element.getAttribute("className"))) {
                                    name = "SSL Connector";
                                    protocol = "SSL";
                                }
                            }
                            catch (Exception exception) {}
                        }
                        if ("HTTP".equals(protocol)) {
                            advanced = false;
                        }
                    } else if (APACHE_CONNECTOR.equals(className)) {
                        name = "Apache Connector";
                    }
                    if (className != null && className.length() > 0) {
                        ports.add(new ServerPort(String.valueOf(i) + "/" + j, name, port, protocol, contentTypes, advanced));
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error getting server ports", e);
        }
        return ports;
    }

    public List getWebModules() {
        ArrayList<WebModule> list = new ArrayList<WebModule>();
        try {
            int size = this.server.getServiceCount();
            int i = 0;
            while (i < size) {
                Service service = this.server.getService(i);
                if (service.getName().equalsIgnoreCase(DEFAULT_SERVICE)) {
                    Engine engine = service.getEngine();
                    Host host = engine.getHost();
                    int size2 = host.getContextCount();
                    int j = 0;
                    while (j < size2) {
                        Context context = host.getContext(j);
                        String reload = context.getReloadable();
                        if (reload == null) {
                            reload = "false";
                        }
                        WebModule module = new WebModule(context.getPath(), context.getDocBase(), context.getSource(), reload.equalsIgnoreCase("true"));
                        list.add(module);
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error getting project refs", e);
        }
        return list;
    }

    public void importFromPath(IPath path, boolean isTestEnv, IProgressMonitor monitor) throws CoreException {
        this.load(path, monitor);
        if (isTestEnv) {
            int size = this.server.getServiceCount();
            int i = 0;
            while (i < size) {
                Service service = this.server.getService(i);
                if (service.getName().equalsIgnoreCase(DEFAULT_SERVICE)) {
                    Host host = service.getEngine().getHost();
                    int size2 = host.getContextCount();
                    int j = 0;
                    while (j < size2) {
                        host.removeElement("Context", 0);
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void load(IPath path, IProgressMonitor monitor) throws CoreException {
        try {
            block9: {
                monitor = ProgressUtil.getMonitorFor(monitor);
                monitor.beginTask(Messages.loadingTask, 5);
                FileInputStream in = new FileInputStream(path.append("catalina.policy").toFile());
                ((InputStream)in).read();
                ((InputStream)in).close();
                monitor.worked(1);
                this.serverFactory = new Factory();
                this.serverFactory.setPackageName("org.eclipse.jst.server.tomcat.core.internal.xml.server40");
                this.server = (Server)this.serverFactory.loadDocument(new FileInputStream(path.append("server.xml").toFile()));
                monitor.worked(1);
                this.webAppDocument = new WebAppDocument(path.append("web.xml"));
                monitor.worked(1);
                this.tomcatUsersDocument = XMLUtil.getDocumentBuilder().parse(new InputSource(new FileInputStream(path.append("tomcat-users.xml").toFile())));
                monitor.worked(1);
                BufferedReader br = null;
                try {
                    try {
                        br = new BufferedReader(new InputStreamReader(new FileInputStream(path.append("catalina.policy").toFile())));
                        String temp = br.readLine();
                        this.policyFile = "";
                        while (temp != null) {
                            this.policyFile = String.valueOf(this.policyFile) + temp + "\n";
                            temp = br.readLine();
                        }
                    }
                    catch (Exception e) {
                        Trace.trace(Trace.WARNING, "Could not load policy file", e);
                    }
                }
                catch (Throwable throwable) {
                    Object var6_9 = null;
                    if (br == null) throw throwable;
                    br.close();
                    throw throwable;
                }
                {
                    Object var6_10 = null;
                    if (br == null) break block9;
                }
                br.close();
            }
            monitor.worked(1);
            if (monitor.isCanceled()) {
                return;
            }
            monitor.done();
            return;
        }
        catch (Exception e) {
            Trace.trace(Trace.WARNING, "Could not load Tomcat v4.0 configuration from " + path.toOSString() + ": " + e.getMessage());
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.server.tomcat.core", 0, NLS.bind((String)Messages.errorCouldNotLoadConfiguration, (Object)path.toOSString()), (Throwable)e));
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void load(IFolder folder, IProgressMonitor monitor) throws CoreException {
        try {
            block10: {
                monitor = ProgressUtil.getMonitorFor(monitor);
                monitor.beginTask(Messages.loadingTask, 800);
                IFile file = folder.getFile("catalina.policy");
                if (!file.exists()) {
                    throw new CoreException((IStatus)new Status(2, "org.eclipse.jst.server.tomcat.core", 0, NLS.bind((String)Messages.errorCouldNotLoadConfiguration, (Object)folder.getFullPath().toOSString()), null));
                }
                file = folder.getFile("server.xml");
                InputStream in = file.getContents();
                this.serverFactory = new Factory();
                this.serverFactory.setPackageName("org.eclipse.jst.server.tomcat.core.internal.xml.server40");
                this.server = (Server)this.serverFactory.loadDocument(in);
                monitor.worked(200);
                file = folder.getFile("web.xml");
                this.webAppDocument = new WebAppDocument(file);
                monitor.worked(200);
                file = folder.getFile("tomcat-users.xml");
                in = file.getContents();
                this.tomcatUsersDocument = XMLUtil.getDocumentBuilder().parse(new InputSource(in));
                monitor.worked(200);
                file = folder.getFile("catalina.policy");
                in = file.getContents();
                BufferedReader br = null;
                try {
                    try {
                        br = new BufferedReader(new InputStreamReader(in));
                        String temp = br.readLine();
                        this.policyFile = "";
                        while (temp != null) {
                            this.policyFile = String.valueOf(this.policyFile) + temp + "\n";
                            temp = br.readLine();
                        }
                    }
                    catch (Exception e) {
                        Trace.trace(Trace.WARNING, "Could not load policy file", e);
                    }
                }
                catch (Throwable throwable) {
                    Object var7_10 = null;
                    if (br == null) throw throwable;
                    br.close();
                    throw throwable;
                }
                {
                    Object var7_11 = null;
                    if (br == null) break block10;
                }
                br.close();
            }
            monitor.worked(200);
            if (monitor.isCanceled()) {
                throw new Exception("Cancelled");
            }
            monitor.done();
            return;
        }
        catch (Exception e) {
            Trace.trace(Trace.WARNING, "Could not reload Tomcat v4.1 configuration from: " + folder.getFullPath() + ": " + e.getMessage());
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.server.tomcat.core", 0, NLS.bind((String)Messages.errorCouldNotLoadConfiguration, (Object)folder.getFullPath().toOSString()), (Throwable)e));
        }
    }

    protected void save(IPath path, boolean forceDirty, IProgressMonitor monitor) throws CoreException {
        try {
            monitor = ProgressUtil.getMonitorFor(monitor);
            monitor.beginTask(Messages.savingTask, 3);
            if (!path.toFile().exists()) {
                forceDirty = true;
                path.toFile().mkdir();
            }
            monitor.worked(1);
            if (forceDirty || this.isServerDirty) {
                this.serverFactory.save(path.append("server.xml").toOSString());
            }
            monitor.worked(1);
            this.webAppDocument.save(path.append("web.xml").toOSString(), forceDirty);
            monitor.worked(1);
            if (forceDirty) {
                XMLUtil.save(path.append("tomcat-users.xml").toOSString(), this.tomcatUsersDocument);
            }
            monitor.worked(1);
            if (forceDirty || this.isPolicyDirty) {
                BufferedWriter bw = new BufferedWriter(new FileWriter(path.append("catalina.policy").toFile()));
                bw.write(this.policyFile);
                bw.close();
            }
            monitor.worked(1);
            this.isServerDirty = false;
            this.isPolicyDirty = false;
            if (monitor.isCanceled()) {
                return;
            }
            monitor.done();
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Could not save Tomcat v4.1 configuration to " + path, e);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.server.tomcat.core", 0, NLS.bind((String)Messages.errorCouldNotSaveConfiguration, (Object[])new String[]{e.getLocalizedMessage()}), (Throwable)e));
        }
    }

    public void save(IPath path, IProgressMonitor monitor) throws CoreException {
        this.save(path, true, monitor);
    }

    public void save(IFolder folder, IProgressMonitor monitor) throws CoreException {
        try {
            monitor = ProgressUtil.getMonitorFor(monitor);
            monitor.beginTask(Messages.savingTask, 900);
            byte[] data = this.serverFactory.getContents();
            ByteArrayInputStream in = new ByteArrayInputStream(data);
            IFile file = folder.getFile("server.xml");
            if (file.exists()) {
                if (this.isServerDirty) {
                    file.setContents((InputStream)in, true, true, ProgressUtil.getSubMonitorFor(monitor, 200));
                } else {
                    monitor.worked(200);
                }
            } else {
                file.create((InputStream)in, true, ProgressUtil.getSubMonitorFor(monitor, 200));
            }
            this.webAppDocument.save(folder.getFile("web.xml"), ProgressUtil.getSubMonitorFor(monitor, 200));
            data = XMLUtil.getContents(this.tomcatUsersDocument);
            in = new ByteArrayInputStream(data);
            file = folder.getFile("tomcat-users.xml");
            if (file.exists()) {
                monitor.worked(200);
            } else {
                file.create((InputStream)in, true, ProgressUtil.getSubMonitorFor(monitor, 200));
            }
            in = new ByteArrayInputStream(this.policyFile.getBytes());
            file = folder.getFile("catalina.policy");
            if (file.exists()) {
                monitor.worked(200);
            } else {
                file.create((InputStream)in, true, ProgressUtil.getSubMonitorFor(monitor, 200));
            }
            if (monitor.isCanceled()) {
                return;
            }
            monitor.done();
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Could not save Tomcat v4.1 configuration to " + folder.toString(), e);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.server.tomcat.core", 0, NLS.bind((String)Messages.errorCouldNotSaveConfiguration, (Object[])new String[]{e.getLocalizedMessage()}), (Throwable)e));
        }
    }

    protected static boolean hasMDBListener(Server server) {
        if (server == null) {
            return false;
        }
        int count = server.getListenerCount();
        if (count == 0) {
            return false;
        }
        int i = 0;
        while (i < count) {
            Listener listener = server.getListener(i);
            if (listener != null && listener.getClassName() != null && listener.getClassName().indexOf("mbean") >= 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void addMimeMapping(int index, IMimeMapping map) {
        this.webAppDocument.addMimeMapping(index, map);
        this.firePropertyChangeEvent("addMapping", new Integer(index), map);
    }

    public void addWebModule(int index, ITomcatWebModule module) {
        try {
            int size = this.server.getServiceCount();
            int i = 0;
            while (i < size) {
                Service service = this.server.getService(i);
                if (service.getName().equalsIgnoreCase(DEFAULT_SERVICE)) {
                    Engine engine = service.getEngine();
                    Host host = engine.getHost();
                    Context context = (Context)host.createElement(index, "Context");
                    context.setDocBase(module.getDocumentBase());
                    context.setPath(module.getPath());
                    context.setReloadable(module.isReloadable() ? "true" : "false");
                    if (module.getMemento() != null && module.getMemento().length() > 0) {
                        context.setSource(module.getMemento());
                    }
                    this.isServerDirty = true;
                    this.firePropertyChangeEvent("addWebModule", null, module);
                    return;
                }
                ++i;
            }
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error adding web module " + module.getPath(), e);
        }
    }

    public void modifyMimeMapping(int index, IMimeMapping map) {
        this.webAppDocument.modifyMimeMapping(index, map);
        this.firePropertyChangeEvent("modifyMapping", new Integer(index), map);
    }

    public void modifyServerPort(String id, int port) {
        try {
            if ("server".equals(id)) {
                this.server.setPort(String.valueOf(port));
                this.isServerDirty = true;
                this.firePropertyChangeEvent("modifyPort", id, new Integer(port));
                return;
            }
            int i = id.indexOf("/");
            int servNum = Integer.parseInt(id.substring(0, i));
            int connNum = Integer.parseInt(id.substring(i + 1));
            Service service = this.server.getService(servNum);
            Connector connector = service.getConnector(connNum);
            connector.setPort(String.valueOf(port));
            this.isServerDirty = true;
            this.firePropertyChangeEvent("modifyPort", id, new Integer(port));
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error modifying server port " + id, e);
        }
    }

    public void modifyWebModule(int index, String docBase, String path, boolean reloadable) {
        try {
            int size = this.server.getServiceCount();
            int i = 0;
            while (i < size) {
                Service service = this.server.getService(i);
                if (service.getName().equalsIgnoreCase(DEFAULT_SERVICE)) {
                    Engine engine = service.getEngine();
                    Host host = engine.getHost();
                    Context context = host.getContext(index);
                    context.setPath(path);
                    context.setDocBase(docBase);
                    context.setReloadable(reloadable ? "true" : "false");
                    this.isServerDirty = true;
                    WebModule module = new WebModule(path, docBase, null, reloadable);
                    this.firePropertyChangeEvent("modifyWebModule", new Integer(index), module);
                    return;
                }
                ++i;
            }
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error modifying web module " + index, e);
        }
    }

    public void removeMimeMapping(int index) {
        this.webAppDocument.removeMimeMapping(index);
        this.firePropertyChangeEvent("removeMapping", null, new Integer(index));
    }

    public void removeWebModule(int index) {
        try {
            int size = this.server.getServiceCount();
            int i = 0;
            while (i < size) {
                Service service = this.server.getService(i);
                if (service.getName().equalsIgnoreCase(DEFAULT_SERVICE)) {
                    Engine engine = service.getEngine();
                    Host host = engine.getHost();
                    host.removeElement("Context", index);
                    this.isServerDirty = true;
                    this.firePropertyChangeEvent("removeWebModule", null, new Integer(index));
                    return;
                }
                ++i;
            }
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error removing module ref " + index, e);
        }
    }

    protected IStatus publishContextConfig(IPath baseDir, IProgressMonitor monitor) {
        monitor = ProgressUtil.getMonitorFor(monitor);
        monitor.beginTask(Messages.publishConfigurationTask, 300);
        Trace.trace(Trace.FINER, "Apply context configurations");
        IPath confDir = baseDir.append("conf");
        IPath webappsDir = baseDir.append("webapps");
        try {
            monitor.subTask(Messages.publishContextConfigTask);
            Factory factory = new Factory();
            factory.setPackageName("org.eclipse.jst.server.tomcat.core.internal.xml.server40");
            Server publishedServer = (Server)factory.loadDocument(new FileInputStream(confDir.append("server.xml").toFile()));
            monitor.worked(100);
            boolean modified = false;
            MultiStatus ms = new MultiStatus("org.eclipse.jst.server.tomcat.core", 0, Messages.publishContextConfigTask, null);
            int size = publishedServer.getServiceCount();
            int i = 0;
            while (i < size) {
                Service service = publishedServer.getService(i);
                if (service.getName().equalsIgnoreCase(DEFAULT_SERVICE)) {
                    Engine engine = service.getEngine();
                    Host host = engine.getHost();
                    int size2 = host.getContextCount();
                    int j = 0;
                    while (j < size2) {
                        Context context = host.getContext(j);
                        monitor.subTask(NLS.bind((String)Messages.checkingContextTask, (Object[])new String[]{context.getPath()}));
                        if (this.addContextConfig(webappsDir, context, ms)) {
                            modified = true;
                        }
                        ++j;
                    }
                }
                ++i;
            }
            monitor.worked(100);
            if (modified) {
                monitor.subTask(Messages.savingContextConfigTask);
                factory.save(confDir.append("server.xml").toOSString());
            }
            monitor.done();
            if (ms.getChildren().length > 0) {
                return ms;
            }
            Trace.trace(Trace.FINER, "Server.xml updated with context.xml configurations");
            return Status.OK_STATUS;
        }
        catch (Exception e) {
            Trace.trace(Trace.WARNING, "Could not apply context configurations to published Tomcat v5.0 configuration from " + confDir.toOSString() + ": " + e.getMessage());
            return new Status(4, "org.eclipse.jst.server.tomcat.core", 0, NLS.bind((String)Messages.errorPublishConfiguration, (Object[])new String[]{e.getLocalizedMessage()}), (Throwable)e);
        }
    }

    protected boolean addContextConfig(IPath webappsDir, Context context, MultiStatus ms) {
        boolean modified = false;
        String source = context.getSource();
        if (source != null && source.length() > 0) {
            String docBase = context.getDocBase();
            try {
                Context contextConfig = this.loadContextConfig(webappsDir.append(docBase));
                if (contextConfig != null) {
                    if (context.hasChildNodes()) {
                        context.removeChildren();
                    }
                    contextConfig.copyChildrenTo(context);
                    Map attrs = contextConfig.getAttributes();
                    Iterator iter = attrs.keySet().iterator();
                    while (iter.hasNext()) {
                        String name = (String)iter.next();
                        if (name.equalsIgnoreCase("path") || name.equalsIgnoreCase("docBase") || name.equalsIgnoreCase("source")) continue;
                        String value = (String)attrs.get(name);
                        context.setAttributeValue(name, value);
                    }
                    modified = true;
                }
            }
            catch (Exception e) {
                String contextPath = context.getPath();
                if (contextPath.startsWith("/")) {
                    contextPath = contextPath.substring(1);
                }
                Trace.trace(Trace.SEVERE, "Error reading context.xml file for " + contextPath, e);
                Status s = new Status(4, "org.eclipse.jst.server.tomcat.core", 0, NLS.bind((String)Messages.errorCouldNotLoadContextXml, (Object)contextPath), (Throwable)e);
                ms.add((IStatus)s);
            }
        }
        return modified;
    }

    protected Context loadContextConfig(IPath webappDir) throws IOException, SAXException {
        File contextXML = new File(String.valueOf(webappDir.toOSString()) + File.separator + "META-INF" + File.separator + "context.xml");
        if (contextXML.exists()) {
            try {
                FileInputStream is = new FileInputStream(contextXML);
                Factory ctxFactory = new Factory();
                ctxFactory.setPackageName("org.eclipse.jst.server.tomcat.core.internal.xml.server40");
                Context ctx = (Context)ctxFactory.loadDocument(is);
                ((InputStream)is).close();
                return ctx;
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
        return null;
    }

    protected IStatus prepareRuntimeDirectory(IPath confDir) {
        IPath tempPath;
        Trace.trace(Trace.FINER, "Preparing runtime directory");
        File temp = confDir.append("conf").toFile();
        if (!temp.exists()) {
            temp.mkdirs();
        }
        if (!(temp = confDir.append("logs").toFile()).exists()) {
            temp.mkdirs();
        }
        if (!(temp = confDir.append("temp").toFile()).exists()) {
            temp.mkdirs();
        }
        if (!(temp = (tempPath = confDir.append("webapps/ROOT/WEB-INF")).toFile()).exists()) {
            temp.mkdirs();
        }
        if (!(temp = tempPath.append("web.xml").toFile()).exists()) {
            try {
                FileWriter fw = new FileWriter(temp);
                fw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE web-app PUBLIC \"-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN\" \"http://java.sun.com/dtd/web-app_2_3.dtd\">\n<web-app>\n</web-app>");
                fw.close();
            }
            catch (IOException e) {
                Trace.trace(Trace.WARNING, "Unable to create web.xml for ROOT context.", e);
            }
        }
        if (!(temp = confDir.append("work").toFile()).exists()) {
            temp.mkdirs();
        }
        return Status.OK_STATUS;
    }
}

