/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet.Logger;
import org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet.XDocletAnnotationPlugin;
import org.osgi.service.prefs.BackingStoreException;

public final class XDocletPreferenceStore {
    private static IPreferencesService preferencesService = null;
    private IProject project = null;
    private ProjectScope projectScope;
    private InstanceScope instanceScope;
    private boolean useGlobal;
    private IScopeContext[] lookupOrder;
    private IScopeContext[] projectLookupOrder;
    private IScopeContext[] instanceLookupOrder;
    private IEclipsePreferences instanceNode;
    private IEclipsePreferences projectNode;
    public static final String XDOCLETBUILDERACTIVE = "XDOCLETBUILDERACTIVE";
    public static final String XDOCLETUSEGLOBAL = "XDOCLETUSEGLOBAL";
    public static final String XDOCLETFORCE = "XDOCLETFORCE";
    public static final String XDOCLETHOME = "XDOCLETHOME";
    public static final String XDOCLETVERSION = "XDOCLETVERSION";
    private HashMap temporaryStore;

    public XDocletPreferenceStore(IProject project) {
        this.project = project;
        this.temporaryStore = new HashMap();
        this.init();
    }

    private void init() {
        if (this.instanceScope == null) {
            this.instanceScope = new InstanceScope();
        }
        this.instanceNode = this.instanceScope.getNode(XDocletPreferenceStore.getPreferencePrefix());
        if (this.project != null) {
            if (this.projectScope == null) {
                this.projectScope = new ProjectScope(this.project);
            }
            this.projectNode = this.projectScope.getNode(XDocletPreferenceStore.getPreferencePrefix());
            this.useGlobal = this.projectNode.getBoolean(XDOCLETUSEGLOBAL, false);
        }
        this.instanceLookupOrder = new IScopeContext[]{this.instanceScope, new DefaultScope()};
        if (this.project != null) {
            this.projectLookupOrder = new IScopeContext[]{this.projectScope, this.instanceScope, new DefaultScope()};
        }
        this.lookupOrder = this.useGlobal ? this.instanceLookupOrder : this.projectLookupOrder;
    }

    protected static String getPreferencePrefix() {
        return XDocletAnnotationPlugin.getDefault().getBundle().getSymbolicName();
    }

    private IPreferencesService getPreferencesService() {
        if (preferencesService == null) {
            preferencesService = Platform.getPreferencesService();
        }
        return preferencesService;
    }

    public void setProperty(String item, boolean value) {
        this.temporaryStore.put(item, value);
    }

    public void setProperty(String item, String value) {
        this.temporaryStore.put(item, value);
    }

    public String getProperty(String item) {
        this.init();
        if (this.temporaryStore != null && this.temporaryStore.containsKey(item)) {
            return (String)this.temporaryStore.get(item);
        }
        return this.getPreferencesService().getString(XDocletPreferenceStore.getPreferencePrefix(), item, "", this.lookupOrder);
    }

    public String getPropertyNoGlobal(String item) {
        this.init();
        if (this.project != null) {
            this.lookupOrder = this.projectLookupOrder;
        }
        if (this.temporaryStore != null && this.temporaryStore.containsKey(item)) {
            return (String)this.temporaryStore.get(item);
        }
        return this.getPreferencesService().getString(XDocletPreferenceStore.getPreferencePrefix(), item, "", this.lookupOrder);
    }

    public boolean getBooleanProperty(String item) {
        this.init();
        if (this.temporaryStore != null && this.temporaryStore.containsKey(item)) {
            return (Boolean)this.temporaryStore.get(item);
        }
        return this.getPreferencesService().getBoolean(XDocletPreferenceStore.getPreferencePrefix(), item, false, this.lookupOrder);
    }

    public boolean getBooleanPropertyNoGlobal(String item) {
        this.init();
        if (this.project != null) {
            this.lookupOrder = this.projectLookupOrder;
        }
        if (this.temporaryStore != null && this.temporaryStore.containsKey(item)) {
            return (Boolean)this.temporaryStore.get(item);
        }
        return this.getPreferencesService().getBoolean(XDocletPreferenceStore.getPreferencePrefix(), item, false, this.lookupOrder);
    }

    private IEclipsePreferences getPreferenceNode() {
        this.init();
        IEclipsePreferences node = this.projectNode;
        if (node == null) {
            node = this.instanceNode;
        }
        return node;
    }

    public void save() {
        try {
            IEclipsePreferences node = this.getPreferenceNode();
            Iterator tempProps = this.temporaryStore.keySet().iterator();
            while (tempProps.hasNext()) {
                String key = (String)tempProps.next();
                Object value = this.temporaryStore.get(key);
                if (value instanceof Boolean) {
                    Boolean bValue = (Boolean)value;
                    node.putBoolean(key, bValue.booleanValue());
                    continue;
                }
                if (!(value instanceof String)) continue;
                node.put(key, (String)value);
            }
            this.temporaryStore.clear();
            if (this.projectNode != null) {
                this.projectNode.flush();
            }
            if (this.instanceNode != null) {
                this.instanceNode.flush();
            }
        }
        catch (BackingStoreException e) {
            Logger.logException(e);
        }
    }

    public void clear() {
        try {
            this.temporaryStore.clear();
            if (this.projectNode != null) {
                this.projectNode.clear();
            }
            if (this.instanceNode != null) {
                this.instanceNode.clear();
            }
        }
        catch (BackingStoreException e) {
            Logger.logException(e);
        }
    }

    protected static void initializeDefaultPreferences(IPreferenceStore store) {
        store.setDefault(XDOCLETFORCE, true);
        store.setDefault(XDOCLETVERSION, "1.2.1");
        store.setDefault(XDOCLETHOME, "");
        store.setDefault(XDOCLETUSEGLOBAL, true);
        store.setDefault(XDOCLETBUILDERACTIVE, true);
        XDocletPreferenceStore.initDoclet(store, "org.eclipse.jst.j2ee.ejb.annotations.xdoclet.ejbDocletTaskProvider");
        XDocletPreferenceStore.initDoclet(store, "org.eclipse.jst.j2ee.ejb.annotations.xdoclet.webdocletTaskProvider");
    }

    private static void initDoclet(IPreferenceStore store, String extensionID) {
        IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint(extensionID).getExtensions();
        int i = 0;
        while (extensions != null && i < extensions.length) {
            IExtension extension = extensions[i];
            IConfigurationElement[] elements = extension.getConfigurationElements();
            if (elements != null) {
                String id = elements[0].getAttribute("id");
                boolean selected = Boolean.valueOf(elements[0].getAttribute("defaultSelection"));
                store.setDefault(String.valueOf(id) + ".defaultSelection", selected);
                int j = 1;
                while (j < elements.length) {
                    IConfigurationElement param = elements[j];
                    if ("TaskProperty".equals(param.getName())) {
                        String paramId = param.getAttribute("id");
                        String paramValue = param.getAttribute("default");
                        boolean include = Boolean.valueOf(param.getAttribute("include"));
                        store.setDefault(paramId, paramValue);
                        store.setDefault(String.valueOf(paramId) + ".include", include);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public static XDocletPreferenceStore forProject(IProject currentProject) {
        return new XDocletPreferenceStore(currentProject);
    }
}

